/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.batch.ExtendedPlannedIndependentRequirementServiceBatch;

/**
 * <p>
 *
 * The PIRs are read, updated and/or created on header and item level. You can also send batch requests.
 *
 * Use this API, if you want to work with the Change PIR or Maintain PIR app. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/c8/1d1718b16147b5811acce3f1888054/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PLND_INDEP_RQMT_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PLND_INDEP_RQMT_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Production Planning Integration(SAP_COM_0104)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BJ5'> Make-to-Stock Production - Discrete Manufacturing(BJ5)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BJ8'>Make-to-Stock - Process Manufacturing Based on Process
 * Order(BJ8)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/J44'>Material Requirements Planning(J44)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O44'>Material Requirements Planning(O44)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Planned Independent Requirement</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface ExtendedPlannedIndependentRequirementService
    extends
    BatchService<ExtendedPlannedIndependentRequirementServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_PLND_INDEP_RQMT_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    ExtendedPlannedIndependentRequirementService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmt
     * PlannedIndepRqmt} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmt
     *         PlannedIndepRqmt} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PlannedIndepRqmtFluentHelper getAllPlannedIndepRqmt();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmt
     * PlannedIndepRqmt} entity using key fields.
     *
     * @param plndIndepRqmtVersion
     *            Version Number for Independent Requirements
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param product
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param mRPArea
     *            MRP Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param requirementSegment
     *            Requirement Segment
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param plndIndepRqmtType
     *            Requirements type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param requirementPlan
     *            Requirements Plan
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmt
     *         PlannedIndepRqmt} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PlannedIndepRqmtByKeyFluentHelper getPlannedIndepRqmtByKey(
        final String product,
        final String plant,
        final String mRPArea,
        final String plndIndepRqmtType,
        final String plndIndepRqmtVersion,
        final String requirementPlan,
        final String requirementSegment );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmt
     * PlannedIndepRqmt} entity and save it to the S/4HANA system.
     *
     * @param plannedIndepRqmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmt
     *            PlannedIndepRqmt} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmt
     *         PlannedIndepRqmt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PlannedIndepRqmtCreateFluentHelper createPlannedIndepRqmt( @Nonnull final PlannedIndepRqmt plannedIndepRqmt );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmt
     * PlannedIndepRqmt} entity and save it to the S/4HANA system.
     *
     * @param plannedIndepRqmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmt
     *            PlannedIndepRqmt} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmt
     *         PlannedIndepRqmt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PlannedIndepRqmtUpdateFluentHelper updatePlannedIndepRqmt( @Nonnull final PlannedIndepRqmt plannedIndepRqmt );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItem
     * PlannedIndepRqmtItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItem
     *         PlannedIndepRqmtItem} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PlannedIndepRqmtItemFluentHelper getAllPlannedIndepRqmtItem();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItem
     * PlannedIndepRqmtItem} entity using key fields.
     *
     * @param plndIndepRqmtVersion
     *            Version Number for Independent Requirements
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param product
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param mRPArea
     *            MRP Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param requirementSegment
     *            Requirement Segment
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param periodType
     *            Type of a Period
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param plndIndepRqmtType
     *            Requirements type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param plndIndepRqmtPeriod
     *            Period Text
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param requirementPlan
     *            Requirements Plan
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItem
     *         PlannedIndepRqmtItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PlannedIndepRqmtItemByKeyFluentHelper getPlannedIndepRqmtItemByKey(
        final String product,
        final String plant,
        final String mRPArea,
        final String plndIndepRqmtType,
        final String plndIndepRqmtVersion,
        final String requirementPlan,
        final String requirementSegment,
        final String plndIndepRqmtPeriod,
        final String periodType );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItem
     * PlannedIndepRqmtItem} entity and save it to the S/4HANA system.
     *
     * @param plannedIndepRqmtItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItem
     *            PlannedIndepRqmtItem} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItem
     *         PlannedIndepRqmtItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItemCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PlannedIndepRqmtItemCreateFluentHelper
        createPlannedIndepRqmtItem( @Nonnull final PlannedIndepRqmtItem plannedIndepRqmtItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItem
     * PlannedIndepRqmtItem} entity and save it to the S/4HANA system.
     *
     * @param plannedIndepRqmtItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItem
     *            PlannedIndepRqmtItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItem
     *         PlannedIndepRqmtItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PlannedIndepRqmtItemUpdateFluentHelper
        updatePlannedIndepRqmtItem( @Nonnull final PlannedIndepRqmtItem plannedIndepRqmtItem );

}
