/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.JobAbortFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.JobCancelFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.JobScheduleFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.JobStatusGetFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.JobTemplateByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.JobTemplateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.batch.ExternalJobSchedulerIntegrationServiceBatch;

/**
 * <p>
 * This service enables you to schedule application jobs for a specified business user, to read the status and other
 * data of an application job, and to cancel an application job.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/latest/EN/aa/dfe07526c547c784c2258a9d145e6f/frameset.htm'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/BC_EXT_APPJOB_MANAGEMENT?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>BC_EXT_APPJOB_MANAGEMENT</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>2</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>External Scheduler Integration (SAP_COM_0064)</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface ExternalJobSchedulerIntegrationService
    extends
    BatchService<ExternalJobSchedulerIntegrationServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/BC_EXT_APPJOB_MANAGEMENT;v=0002";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    ExternalJobSchedulerIntegrationService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.JobTemplate
     * JobTemplate} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.JobTemplate
     *         JobTemplate} entities. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.JobTemplateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    JobTemplateFluentHelper getAllJobTemplate();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.JobTemplate
     * JobTemplate} entity using key fields.
     *
     * @param jobTemplateName
     *
     * @param jobTemplateVersion
     *
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.JobTemplate
     *         JobTemplate} entity using key fields. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.JobTemplateByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    JobTemplateByKeyFluentHelper getJobTemplateByKey( final String jobTemplateName, final String jobTemplateVersion );

    /**
     * <p>
     * Creates a fluent helper for the <b>JobSchedule</b> OData function import.
     * </p>
     *
     * @param testModeInd
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>TestModeInd</b>
     *            </p>
     * @param jobText
     *            Constraints: Not nullable, Maximum length: 120
     *            <p>
     *            Original parameter name from the Odata EDM: <b>JobText</b>
     *            </p>
     * @param jobUserName
     *            Constraints: Nullable, Maximum length: 12
     *            <p>
     *            Original parameter name from the Odata EDM: <b>JobUserName</b>
     *            </p>
     * @param jobParameterValues
     *            Constraints: Nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>JobParameterValues</b>
     *            </p>
     * @param jobUser
     *            Constraints: Nullable, Maximum length: 40
     *            <p>
     *            Original parameter name from the Odata EDM: <b>JobUser</b>
     *            </p>
     * @param jobUserID
     *            Constraints: Nullable, Maximum length: 40
     *            <p>
     *            Original parameter name from the Odata EDM: <b>JobUserID</b>
     *            </p>
     * @param jobTemplateName
     *            Constraints: Not nullable, Maximum length: 40
     *            <p>
     *            Original parameter name from the Odata EDM: <b>JobTemplateName</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>JobSchedule</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.JobScheduleFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    JobScheduleFluentHelper jobSchedule(
        @Nullable final String jobUserID,
        @Nullable final String jobUserName,
        @Nonnull final String jobText,
        @Nonnull final String jobTemplateName,
        @Nullable final String jobParameterValues,
        @Nullable final Boolean testModeInd,
        @Nullable final String jobUser );

    /**
     * <p>
     * Creates a fluent helper for the <b>JobCancel</b> OData function import.
     * </p>
     *
     * @param jobName
     *            Constraints: Not nullable, Maximum length: 32
     *            <p>
     *            Original parameter name from the Odata EDM: <b>JobName</b>
     *            </p>
     * @param jobRunCount
     *            Constraints: Not nullable, Maximum length: 14
     *            <p>
     *            Original parameter name from the Odata EDM: <b>JobRunCount</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>JobCancel</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.JobCancelFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    JobCancelFluentHelper jobCancel( @Nonnull final String jobRunCount, @Nonnull final String jobName );

    /**
     * <p>
     * Creates a fluent helper for the <b>JobAbort</b> OData function import.
     * </p>
     *
     * @param jobName
     *            Constraints: Not nullable, Maximum length: 32
     *            <p>
     *            Original parameter name from the Odata EDM: <b>JobName</b>
     *            </p>
     * @param jobRunCount
     *            Constraints: Not nullable, Maximum length: 14
     *            <p>
     *            Original parameter name from the Odata EDM: <b>JobRunCount</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>JobAbort</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.JobAbortFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    JobAbortFluentHelper jobAbort( @Nonnull final String jobRunCount, @Nonnull final String jobName );

    /**
     * <p>
     * Creates a fluent helper for the <b>JobStatusGet</b> OData function import.
     * </p>
     *
     * @param jobName
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>JobName</b>
     *            </p>
     * @param jobRunCount
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>JobRunCount</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>JobStatusGet</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.JobStatusGetFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    JobStatusGetFluentHelper jobStatusGet( @Nonnull final String jobName, @Nonnull final String jobRunCount );

}
