/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinancialPlanData;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinancialPlanDataByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinancialPlanDataCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.batch.FinancialPlanningDataServiceBatch;

/**
 * <p>
 *
 * The service exports financial plan data between systems. This API call is based on the OData protocol, and can be
 * consumed in Fiori apps and on other user interfaces.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/d5/d7064aaedb4028aad85cab986053e7/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_FINPLANNINGDATA_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_FINPLANNINGDATA_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>SAP Analytics Cloud for Planning Integration(SAP_COM_0087), Public Sector API Integration(SAP_COM_0761)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1YB'>Import Connection setup with SAP Analytics Cloud(1YB)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/6UC'>Government Budget Planning(6UC)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>FinancialPlanningEntryItem</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface FinancialPlanningDataService extends BatchService<FinancialPlanningDataServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_FINPLANNINGDATA_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    FinancialPlanningDataService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinancialPlanData
     * FinancialPlanData} entity using key fields.
     *
     * @param planDataAggrgnLvlFieldsString
     *
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinancialPlanData
     *         FinancialPlanData} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinancialPlanDataByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FinancialPlanDataByKeyFluentHelper getFinancialPlanDataByKey( final String planDataAggrgnLvlFieldsString );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinancialPlanData
     * FinancialPlanData} entity and save it to the S/4HANA system.
     *
     * @param financialPlanData
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinancialPlanData
     *            FinancialPlanData} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinancialPlanData
     *         FinancialPlanData} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinancialPlanDataCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FinancialPlanDataCreateFluentHelper createFinancialPlanData( @Nonnull final FinancialPlanData financialPlanData );

}
