/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.CompanyCodeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.CompanyCodeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.CostCenterByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.CostCenterFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanEntryItemVariableFixByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanEntryItemVariableFixFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.GLAccountInChartOfAccountsByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.GLAccountInChartOfAccountsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.ProfitCenterByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.ProfitCenterFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.batch.FinancialPlanningEntryItemServiceBatch;

/**
 * <p>
 *
 * The service contains financial planning entry items and master data of the referenced company code, cost center,
 * profit center. This API call is based on the OData protocol, and can be consumed in Fiori apps and on other user
 * interfaces..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/29/698caa770b4d29b30e6e84f033edd8/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_FINPLANNINGENTRYITEM_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_FINPLANNINGENTRYITEM_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>SAP Analytics Cloud for Planning Integration(SAP_COM_0087)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1YB'>Import Connection setup with SAP Analytics
 * Cloud(1YB)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>FinancialPlanningEntryItem</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface FinancialPlanningEntryItemService extends BatchService<FinancialPlanningEntryItemServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_FINPLANNINGENTRYITEM_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    FinancialPlanningEntryItemService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.CompanyCode
     * CompanyCode} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.CompanyCode
     *         CompanyCode} entities. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.CompanyCodeFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CompanyCodeFluentHelper getAllCompanyCode();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.CompanyCode
     * CompanyCode} entity using key fields.
     *
     * @param companyCode
     *            Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.CompanyCode
     *         CompanyCode} entity using key fields. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.CompanyCodeByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CompanyCodeByKeyFluentHelper getCompanyCodeByKey( final String companyCode );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.CostCenter
     * CostCenter} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.CostCenter
     *         CostCenter} entities. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.CostCenterFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CostCenterFluentHelper getAllCostCenter();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.CostCenter
     * CostCenter} entity using key fields.
     *
     * @param costCenter
     *            Cost Center
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param controllingArea
     *            Controlling Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param validityEndDate
     *            Valid To Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.CostCenter
     *         CostCenter} entity using key fields. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.CostCenterByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CostCenterByKeyFluentHelper getCostCenterByKey(
        final String controllingArea,
        final String costCenter,
        final LocalDateTime validityEndDate );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanEntryItemVariableFix
     * FinPlanEntryItemVariableFix} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanEntryItemVariableFix
     *         FinPlanEntryItemVariableFix} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanEntryItemVariableFixFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FinPlanEntryItemVariableFixFluentHelper getAllFinPlanEntryItemVariableFix();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanEntryItemVariableFix
     * FinPlanEntryItemVariableFix} entity using key fields.
     *
     * @param iD
     *
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanEntryItemVariableFix
     *         FinPlanEntryItemVariableFix} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanEntryItemVariableFixByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FinPlanEntryItemVariableFixByKeyFluentHelper getFinPlanEntryItemVariableFixByKey( final String iD );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem
     * FinPlanningEntryItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem
     *         FinPlanningEntryItem} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FinPlanningEntryItemFluentHelper getAllFinPlanningEntryItem();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem
     * FinPlanningEntryItem} entity using key fields.
     *
     * @param iD
     *
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem
     *         FinPlanningEntryItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FinPlanningEntryItemByKeyFluentHelper getFinPlanningEntryItemByKey( final String iD );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.GLAccountInChartOfAccounts
     * GLAccountInChartOfAccounts} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.GLAccountInChartOfAccounts
     *         GLAccountInChartOfAccounts} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.GLAccountInChartOfAccountsFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GLAccountInChartOfAccountsFluentHelper getAllGLAccountInChartOfAccounts();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.GLAccountInChartOfAccounts
     * GLAccountInChartOfAccounts} entity using key fields.
     *
     * @param gLAccount
     *            G/L Account Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param chartOfAccounts
     *            Chart of Accounts
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.GLAccountInChartOfAccounts
     *         GLAccountInChartOfAccounts} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.GLAccountInChartOfAccountsByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GLAccountInChartOfAccountsByKeyFluentHelper
        getGLAccountInChartOfAccountsByKey( final String chartOfAccounts, final String gLAccount );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.ProfitCenter
     * ProfitCenter} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.ProfitCenter
     *         ProfitCenter} entities. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.ProfitCenterFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProfitCenterFluentHelper getAllProfitCenter();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.ProfitCenter
     * ProfitCenter} entity using key fields.
     *
     * @param controllingArea
     *            Controlling Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param profitCenter
     *            Profit Center
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param validityEndDate
     *            Valid To Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.ProfitCenter
     *         ProfitCenter} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.ProfitCenterByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProfitCenterByKeyFluentHelper getProfitCenterByKey(
        final String controllingArea,
        final String profitCenter,
        final LocalDateTime validityEndDate );

}
