/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;
import java.time.LocalTime;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.Characteristic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.CharacteristicByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.CharacteristicCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.CharacteristicFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.DismantleFunctionalLocationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClass;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClassByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClassCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClassDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClassFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClassUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationLongText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationLongTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationLongTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationLongTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationLongTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationPartnerCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationWarranty;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationWarrantyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationWarrantyCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationWarrantyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationWarrantyUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.InstallFunctionalLocationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.RsetFuncLocFromMrkdForDeletionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.RsetFuncnlLocationFromInactiveFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.SetFuncLocToMarkedForDeletionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.SetFuncnlLocationToInactiveFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.Value;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.ValueByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.ValueCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.ValueFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.ValueUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.batch.FunctionalLocationServiceBatch;

/**
 * <p>
 *
 * This service contains functional location, long text, partner function, warranty, class, characteristic, and
 * characteristic value nodes. The information is sent in the request as a payload.
 *
 * The request payload contains all information required to create or update functional location. All the information in
 * the payload is used to create or update functional location including appropriate checks for restricted values and
 * authorizations. Once the functional location has been created, the functional location label is sent in the response
 * with the data included in the functional location.
 *
 * If the input in the request is not as expected when you create or update a functional location, the system displays
 * appropriate error or warning messages in the response..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/b6/a1e644059f4d53b11201b9c0aaefd7/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_FUNCTIONALLOCATION?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_FUNCTIONALLOCATION</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.1.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Asset Management Master Data Integration(SAP_COM_0395)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3D2'>Service Order Management and Monitoring(3D2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3MO'>Service Contract Management(3MO)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3XK'>In-House Repair(3XK)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4HH'>Reactive Maintenance(4HH)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4HI'>Proactive Maintenance(4HI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4VT'>Improvement Maintenance(4VT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4WM'>Operational and Overhead Maintenance(4WM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BH1'>Corrective Maintenance(BH1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BH2'>Emergency Maintenance(BH2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BJ2'>Preventive Maintenance(BJ2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OHH'>Reactive Maintenance(OHH)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OHI'>Proactive Maintenance(OHI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OJ2'>PSM: Preventive Maintenance(OJ2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OVT'>Improvement Maintenance(OVT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OWM'>Operational and Overhead Maintenance(OWM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/49X'>Service Order Processing with SAP Field Service
 * Management(49X)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/4GA'>Service Quotation(4GA)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Functional Location</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface FunctionalLocationService extends BatchService<FunctionalLocationServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_FUNCTIONALLOCATION";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    FunctionalLocationService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.Value Value}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.Value Value} entities. This
     *         fluent helper allows methods which modify the underlying query to be called before executing the query
     *         itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.ValueFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ValueFluentHelper getAllValue();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.Value Value} entity
     * using key fields.
     *
     * @param charcValuePositionNumber
     *            Characteristic value counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param charcInternalID
     *            Characteristic Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param functionalLocation
     *            Key of Object to be Classified
     *            <p>
     *            Constraints: Not nullable, Maximum length: 90
     *            </p>
     * @param classType
     *            Class Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.Value Value} entity using
     *         key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.ValueByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ValueByKeyFluentHelper getValueByKey(
        final String functionalLocation,
        final String classType,
        final String charcValuePositionNumber,
        final String charcInternalID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.Value Value} entity
     * and save it to the S/4HANA system.
     *
     * @param value
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.Value Value} entity
     *            object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.Value Value} entity. To
     *         perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.ValueCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ValueCreateFluentHelper createValue( @Nonnull final Value value );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.Value Value}
     * entity and save it to the S/4HANA system.
     *
     * @param value
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.Value Value} entity
     *            object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.Value Value} entity. To
     *         perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.ValueUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ValueUpdateFluentHelper updateValue( @Nonnull final Value value );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClass
     * FunctionalLocationClass} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClass
     *         FunctionalLocationClass} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClassFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FunctionalLocationClassFluentHelper getAllFunctionalLocationClass();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClass
     * FunctionalLocationClass} entity using key fields.
     *
     * @param classInternalID
     *            Internal Class Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param functionalLocation
     *            Key of Object to be Classified
     *            <p>
     *            Constraints: Not nullable, Maximum length: 90
     *            </p>
     * @param classType
     *            Class Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClass
     *         FunctionalLocationClass} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClassByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FunctionalLocationClassByKeyFluentHelper getFunctionalLocationClassByKey(
        final String functionalLocation,
        final String classInternalID,
        final String classType );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClass
     * FunctionalLocationClass} entity and save it to the S/4HANA system.
     *
     * @param functionalLocationClass
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClass
     *            FunctionalLocationClass} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClass
     *         FunctionalLocationClass} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClassCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FunctionalLocationClassCreateFluentHelper
        createFunctionalLocationClass( @Nonnull final FunctionalLocationClass functionalLocationClass );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClass
     * FunctionalLocationClass} entity and save it to the S/4HANA system.
     *
     * @param functionalLocationClass
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClass
     *            FunctionalLocationClass} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClass
     *         FunctionalLocationClass} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClassUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FunctionalLocationClassUpdateFluentHelper
        updateFunctionalLocationClass( @Nonnull final FunctionalLocationClass functionalLocationClass );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClass
     * FunctionalLocationClass} entity in the S/4HANA system.
     *
     * @param functionalLocationClass
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClass
     *            FunctionalLocationClass} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClass
     *         FunctionalLocationClass} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClassDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FunctionalLocationClassDeleteFluentHelper
        deleteFunctionalLocationClass( @Nonnull final FunctionalLocationClass functionalLocationClass );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.Characteristic
     * Characteristic} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.Characteristic
     *         Characteristic} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.CharacteristicFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CharacteristicFluentHelper getAllCharacteristic();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.Characteristic
     * Characteristic} entity using key fields.
     *
     * @param charcInternalID
     *            Characteristic Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param classInternalID
     *            Internal Class Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param functionalLocation
     *            Key of Object to be Classified
     *            <p>
     *            Constraints: Not nullable, Maximum length: 90
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.Characteristic
     *         Characteristic} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.CharacteristicByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CharacteristicByKeyFluentHelper getCharacteristicByKey(
        final String functionalLocation,
        final String classInternalID,
        final String charcInternalID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.Characteristic
     * Characteristic} entity and save it to the S/4HANA system.
     *
     * @param characteristic
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.Characteristic
     *            Characteristic} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.Characteristic
     *         Characteristic} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.CharacteristicCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CharacteristicCreateFluentHelper createCharacteristic( @Nonnull final Characteristic characteristic );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationWarranty
     * FunctionalLocationWarranty} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationWarranty
     *         FunctionalLocationWarranty} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationWarrantyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FunctionalLocationWarrantyFluentHelper getAllFunctionalLocationWarranty();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationWarranty
     * FunctionalLocationWarranty} entity using key fields.
     *
     * @param functionalLocation
     *            Functional location
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     * @param warrantyType
     *            Warranty type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationWarranty
     *         FunctionalLocationWarranty} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationWarrantyByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FunctionalLocationWarrantyByKeyFluentHelper
        getFunctionalLocationWarrantyByKey( final String functionalLocation, final String warrantyType );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationWarranty
     * FunctionalLocationWarranty} entity and save it to the S/4HANA system.
     *
     * @param functionalLocationWarranty
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationWarranty
     *            FunctionalLocationWarranty} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationWarranty
     *         FunctionalLocationWarranty} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationWarrantyCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FunctionalLocationWarrantyCreateFluentHelper
        createFunctionalLocationWarranty( @Nonnull final FunctionalLocationWarranty functionalLocationWarranty );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationWarranty
     * FunctionalLocationWarranty} entity and save it to the S/4HANA system.
     *
     * @param functionalLocationWarranty
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationWarranty
     *            FunctionalLocationWarranty} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationWarranty
     *         FunctionalLocationWarranty} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationWarrantyUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FunctionalLocationWarrantyUpdateFluentHelper
        updateFunctionalLocationWarranty( @Nonnull final FunctionalLocationWarranty functionalLocationWarranty );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation
     * FunctionalLocation} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation
     *         FunctionalLocation} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FunctionalLocationFluentHelper getAllFunctionalLocation();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation
     * FunctionalLocation} entity using key fields.
     *
     * @param functionalLocation
     *            Functional location
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation
     *         FunctionalLocation} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FunctionalLocationByKeyFluentHelper getFunctionalLocationByKey( final String functionalLocation );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation
     * FunctionalLocation} entity and save it to the S/4HANA system.
     *
     * @param functionalLocation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation
     *            FunctionalLocation} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation
     *         FunctionalLocation} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FunctionalLocationCreateFluentHelper
        createFunctionalLocation( @Nonnull final FunctionalLocation functionalLocation );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation
     * FunctionalLocation} entity and save it to the S/4HANA system.
     *
     * @param functionalLocation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation
     *            FunctionalLocation} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation
     *         FunctionalLocation} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FunctionalLocationUpdateFluentHelper
        updateFunctionalLocation( @Nonnull final FunctionalLocation functionalLocation );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationLongText
     * FunctionalLocationLongText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationLongText
     *         FunctionalLocationLongText} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationLongTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FunctionalLocationLongTextFluentHelper getAllFunctionalLocationLongText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationLongText
     * FunctionalLocationLongText} entity using key fields.
     *
     * @param functionalLocation
     *            Functional location
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationLongText
     *         FunctionalLocationLongText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationLongTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FunctionalLocationLongTextByKeyFluentHelper getFunctionalLocationLongTextByKey( final String functionalLocation );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationLongText
     * FunctionalLocationLongText} entity and save it to the S/4HANA system.
     *
     * @param functionalLocationLongText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationLongText
     *            FunctionalLocationLongText} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationLongText
     *         FunctionalLocationLongText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationLongTextCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FunctionalLocationLongTextCreateFluentHelper
        createFunctionalLocationLongText( @Nonnull final FunctionalLocationLongText functionalLocationLongText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationLongText
     * FunctionalLocationLongText} entity and save it to the S/4HANA system.
     *
     * @param functionalLocationLongText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationLongText
     *            FunctionalLocationLongText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationLongText
     *         FunctionalLocationLongText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationLongTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FunctionalLocationLongTextUpdateFluentHelper
        updateFunctionalLocationLongText( @Nonnull final FunctionalLocationLongText functionalLocationLongText );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationPartner
     * FunctionalLocationPartner} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationPartner
     *         FunctionalLocationPartner} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationPartnerFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FunctionalLocationPartnerFluentHelper getAllFunctionalLocationPartner();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationPartner
     * FunctionalLocationPartner} entity using key fields.
     *
     * @param partnerFunction
     *            Partner Function
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param functionalLocation
     *            Functional location
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     * @param funcnlLocPartnerObjectNmbr
     *            Counter for differentiation 6-digit
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationPartner
     *         FunctionalLocationPartner} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationPartnerByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FunctionalLocationPartnerByKeyFluentHelper getFunctionalLocationPartnerByKey(
        final String functionalLocation,
        final String partnerFunction,
        final String funcnlLocPartnerObjectNmbr );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationPartner
     * FunctionalLocationPartner} entity and save it to the S/4HANA system.
     *
     * @param functionalLocationPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationPartner
     *            FunctionalLocationPartner} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationPartner
     *         FunctionalLocationPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationPartnerCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FunctionalLocationPartnerCreateFluentHelper
        createFunctionalLocationPartner( @Nonnull final FunctionalLocationPartner functionalLocationPartner );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationPartner
     * FunctionalLocationPartner} entity and save it to the S/4HANA system.
     *
     * @param functionalLocationPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationPartner
     *            FunctionalLocationPartner} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationPartner
     *         FunctionalLocationPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationPartnerUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FunctionalLocationPartnerUpdateFluentHelper
        updateFunctionalLocationPartner( @Nonnull final FunctionalLocationPartner functionalLocationPartner );

    /**
     * <p>
     * Creates a fluent helper for the <b>DismantleFunctionalLocation</b> OData function import.
     * </p>
     *
     * @param funcLocDismantleTime
     *            Dismantle Time
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>FuncLocDismantleTime</b>
     *            </p>
     * @param functionalLocation
     *            Functional location
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>FunctionalLocation</b>
     *            </p>
     * @param funcLocDismantleDate
     *            Dismantle Date
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>FuncLocDismantleDate</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>DismantleFunctionalLocation</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.DismantleFunctionalLocationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DismantleFunctionalLocationFluentHelper dismantleFunctionalLocation(
        @Nonnull final String functionalLocation,
        @Nullable final LocalDateTime funcLocDismantleDate,
        @Nullable final LocalTime funcLocDismantleTime );

    /**
     * <p>
     * Creates a fluent helper for the <b>InstallFunctionalLocation</b> OData function import.
     * </p>
     *
     * @param funcLocInstallationTime
     *            Install Time
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>FuncLocInstallationTime</b>
     *            </p>
     * @param superiorFunctionalLocation
     *            Superior FunctLoc.
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SuperiorFunctionalLocation</b>
     *            </p>
     * @param functionalLocation
     *            Functional location
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>FunctionalLocation</b>
     *            </p>
     * @param funcLocInstallationPosNmbr
     *            Position in object
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>FuncLocInstallationPosNmbr</b>
     *            </p>
     * @param funcLocInstallationDate
     *            Install Date
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>FuncLocInstallationDate</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>InstallFunctionalLocation</b> OData function import with
     *         the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.InstallFunctionalLocationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InstallFunctionalLocationFluentHelper installFunctionalLocation(
        @Nonnull final String functionalLocation,
        @Nullable final String superiorFunctionalLocation,
        @Nullable final String funcLocInstallationPosNmbr,
        @Nullable final LocalDateTime funcLocInstallationDate,
        @Nullable final LocalTime funcLocInstallationTime );

    /**
     * <p>
     * Creates a fluent helper for the <b>RsetFuncLocFromMrkdForDeletion</b> OData function import.
     * </p>
     *
     * @param functionalLocation
     *            Functional location
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>FunctionalLocation</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>RsetFuncLocFromMrkdForDeletion</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.RsetFuncLocFromMrkdForDeletionFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RsetFuncLocFromMrkdForDeletionFluentHelper
        rsetFuncLocFromMrkdForDeletion( @Nonnull final String functionalLocation );

    /**
     * <p>
     * Creates a fluent helper for the <b>RsetFuncnlLocationFromInactive</b> OData function import.
     * </p>
     *
     * @param functionalLocation
     *            Functional location
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>FunctionalLocation</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>RsetFuncnlLocationFromInactive</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.RsetFuncnlLocationFromInactiveFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RsetFuncnlLocationFromInactiveFluentHelper
        rsetFuncnlLocationFromInactive( @Nonnull final String functionalLocation );

    /**
     * <p>
     * Creates a fluent helper for the <b>SetFuncLocToMarkedForDeletion</b> OData function import.
     * </p>
     *
     * @param functionalLocation
     *            Functional location
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>FunctionalLocation</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>SetFuncLocToMarkedForDeletion</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.SetFuncLocToMarkedForDeletionFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SetFuncLocToMarkedForDeletionFluentHelper setFuncLocToMarkedForDeletion( @Nonnull final String functionalLocation );

    /**
     * <p>
     * Creates a fluent helper for the <b>SetFuncnlLocationToInactive</b> OData function import.
     * </p>
     *
     * @param functionalLocation
     *            Functional location
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>FunctionalLocation</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>SetFuncnlLocationToInactive</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.SetFuncnlLocationToInactiveFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SetFuncnlLocationToInactiveFluentHelper setFuncnlLocationToInactive( @Nonnull final String functionalLocation );

}
