/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierNodeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierNodeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierarchyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierarchyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierarchyNodeTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierarchyNodeTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierarchyTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierarchyTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.batch.FundHierarchyServiceBatch;

/**
 * <p>
 * This service enables you to read the fund hierarchy master data from SAP S/4HANA Cloud system.
 *
 * This service is based on the OData protocol and can be consumed in SAP Fiori apps and other user interfaces..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/42/147704838d4a669cb887fcb2ef42f2/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_FUNDCOREHIERARCHY?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_FUNDCOREHIERARCHY</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.1</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Public Sector API Integration(SAP_COM_0761)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/6UC'>Government Budget Planning(6UC)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Fund</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface FundHierarchyService extends BatchService<FundHierarchyServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_FUNDCOREHIERARCHY";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    FundHierarchyService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierarchy
     * FundCoreHierarchy} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierarchy
     *         FundCoreHierarchy} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierarchyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FundCoreHierarchyFluentHelper getAllFundCoreHierarchy();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierarchy
     * FundCoreHierarchy} entity using key fields.
     *
     * @param validityEndDate
     *            Validity End Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param fundHierarchy
     *            Fund Hierarchy
     *            <p>
     *            Constraints: Not nullable, Maximum length: 42
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierarchy
     *         FundCoreHierarchy} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierarchyByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FundCoreHierarchyByKeyFluentHelper
        getFundCoreHierarchyByKey( final String fundHierarchy, final LocalDateTime validityEndDate );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierarchyNodeText
     * FundCoreHierarchyNodeText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierarchyNodeText
     *         FundCoreHierarchyNodeText} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierarchyNodeTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FundCoreHierarchyNodeTextFluentHelper getAllFundCoreHierarchyNodeText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierarchyNodeText
     * FundCoreHierarchyNodeText} entity using key fields.
     *
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param validityEndDate
     *            Validity End Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param fundHierarchy
     *            Fund Hierarchy
     *            <p>
     *            Constraints: Not nullable, Maximum length: 42
     *            </p>
     * @param hierarchyNode
     *            Hierarchy node
     *            <p>
     *            Constraints: Not nullable, Maximum length: 50
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierarchyNodeText
     *         FundCoreHierarchyNodeText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierarchyNodeTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FundCoreHierarchyNodeTextByKeyFluentHelper getFundCoreHierarchyNodeTextByKey(
        final String fundHierarchy,
        final String hierarchyNode,
        final LocalDateTime validityEndDate,
        final String language );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierarchyText
     * FundCoreHierarchyText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierarchyText
     *         FundCoreHierarchyText} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierarchyTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FundCoreHierarchyTextFluentHelper getAllFundCoreHierarchyText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierarchyText
     * FundCoreHierarchyText} entity using key fields.
     *
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param validityEndDate
     *            Validity End Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param fundHierarchy
     *            Fund Hierarchy
     *            <p>
     *            Constraints: Not nullable, Maximum length: 42
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierarchyText
     *         FundCoreHierarchyText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierarchyTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FundCoreHierarchyTextByKeyFluentHelper getFundCoreHierarchyTextByKey(
        final String fundHierarchy,
        final LocalDateTime validityEndDate,
        final String language );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierNode
     * FundCoreHierNode} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierNode
     *         FundCoreHierNode} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierNodeFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FundCoreHierNodeFluentHelper getAllFundCoreHierNode();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierNode
     * FundCoreHierNode} entity using key fields.
     *
     * @param validityEndDate
     *            Validity End Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param fundHierarchy
     *            Fund Hierarchy
     *            <p>
     *            Constraints: Not nullable, Maximum length: 42
     *            </p>
     * @param hierarchyNode
     *            Hierarchy node
     *            <p>
     *            Constraints: Not nullable, Maximum length: 50
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierNode
     *         FundCoreHierNode} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierNodeByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FundCoreHierNodeByKeyFluentHelper getFundCoreHierNodeByKey(
        final String fundHierarchy,
        final String hierarchyNode,
        final LocalDateTime validityEndDate );

}
