/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCore;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCoreByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCoreCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCoreDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCoreFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCoreUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.batch.FundServiceBatch;

/**
 * <p>
 * This service enables you to create, read, update, and delete the fund master data from SAP S/4HANA Cloud system.
 *
 * This service is based on the OData protocol and can be consumed in SAP Fiori apps and other user interfaces..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/5f/7fbc217157425b977c151a0731cb3f/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference:
 * <a href='https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_FUNDCORE?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_FUNDCORE</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.1.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Public Sector API Integration(SAP_COM_0761)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/6UC'>Government Budget Planning(6UC)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Fund</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface FundService extends BatchService<FundServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_FUNDCORE";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    FundService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCore FundCore} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCore FundCore} entities. This fluent
     *         helper allows methods which modify the underlying query to be called before executing the query itself.
     *         To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCoreFluentHelper#execute execute}
     *         method on the fluent helper object.
     */
    @Nonnull
    FundCoreFluentHelper getAllFundCore();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCore FundCore} entity using
     * key fields.
     *
     * @param financialManagementArea
     *            Financial Management Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param fund
     *            Fund
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCore FundCore} entity using key
     *         fields. This fluent helper allows methods which modify the underlying query to be called before executing
     *         the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCoreByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FundCoreByKeyFluentHelper getFundCoreByKey( final String financialManagementArea, final String fund );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCore FundCore} entity and save
     * it to the S/4HANA system.
     *
     * @param fundCore
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCore FundCore} entity object that
     *            will be created in the S/4HANA system.
     * @return A fluent helper to create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCore
     *         FundCore} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCoreCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FundCoreCreateFluentHelper createFundCore( @Nonnull final FundCore fundCore );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCore FundCore} entity and
     * save it to the S/4HANA system.
     *
     * @param fundCore
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCore FundCore} entity object that
     *            will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCore FundCore} entity. To perform
     *         execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCoreUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FundCoreUpdateFluentHelper updateFundCore( @Nonnull final FundCore fundCore );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCore FundCore} entity in
     * the S/4HANA system.
     *
     * @param fundCore
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCore FundCore} entity object that
     *            will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCore FundCore} entity. To perform
     *         execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCoreDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FundCoreDeleteFluentHelper deleteFundCore( @Nonnull final FundCore fundCore );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundText FundText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundText FundText} entities. This fluent
     *         helper allows methods which modify the underlying query to be called before executing the query itself.
     *         To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundTextFluentHelper#execute execute}
     *         method on the fluent helper object.
     */
    @Nonnull
    FundTextFluentHelper getAllFundText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundText FundText} entity using
     * key fields.
     *
     * @param financialManagementArea
     *            Financial Management Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param fund
     *            Fund
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundText FundText} entity using key
     *         fields. This fluent helper allows methods which modify the underlying query to be called before executing
     *         the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FundTextByKeyFluentHelper
        getFundTextByKey( final String financialManagementArea, final String fund, final String language );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundText FundText} entity and
     * save it to the S/4HANA system.
     *
     * @param fundText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundText FundText} entity object that
     *            will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundText FundText} entity. To perform
     *         execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FundTextUpdateFluentHelper updateFundText( @Nonnull final FundText fundText );

}
