/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccount.GLAccountInChartOfAccountsByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccount.GLAccountInChartOfAccountsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccount.GLAccountTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccount.GLAccountTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccount.batch.GeneralLedgerAccountServiceBatch;

/**
 * <p>
 *
 * This service enables you to retrieve G/L accounts in chart of accounts and their names in the respective language..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/5f/4d16d6a031437fbfd1f61937c6b3fd/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_GLACCOUNTINCHARTOFACCOUNTS_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_GLACCOUNTINCHARTOFACCOUNTS_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>SAP Analytics Cloud for Planning Integration(SAP_COM_0087), Finance - Cloud Consolidation Data Collection
 * Integration(SAP_COM_0241), Excise Tax Integration(SAP_COM_0568), Public Sector API Integration(SAP_COM_0761)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1YB'>Import Connection setup with SAP Analytics Cloud(1YB)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/287'>Group Reporting - Data from SAP Group Reporting Data
 * Collection(287)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/4LO'>Enablement of SAP Excise Tax
 * Management(4LO)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/6UC'>Government Budget Planning(6UC)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>General Ledger Account</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface GeneralLedgerAccountService extends BatchService<GeneralLedgerAccountServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_GLACCOUNTINCHARTOFACCOUNTS_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    GeneralLedgerAccountService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccount.GLAccountInChartOfAccounts
     * GLAccountInChartOfAccounts} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccount.GLAccountInChartOfAccounts
     *         GLAccountInChartOfAccounts} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccount.GLAccountInChartOfAccountsFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GLAccountInChartOfAccountsFluentHelper getAllGLAccountInChartOfAccounts();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccount.GLAccountInChartOfAccounts
     * GLAccountInChartOfAccounts} entity using key fields.
     *
     * @param gLAccount
     *            G/L Account Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param chartOfAccounts
     *            Chart of Accounts
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccount.GLAccountInChartOfAccounts
     *         GLAccountInChartOfAccounts} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccount.GLAccountInChartOfAccountsByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GLAccountInChartOfAccountsByKeyFluentHelper
        getGLAccountInChartOfAccountsByKey( final String chartOfAccounts, final String gLAccount );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccount.GLAccountText
     * GLAccountText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccount.GLAccountText
     *         GLAccountText} entities. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccount.GLAccountTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GLAccountTextFluentHelper getAllGLAccountText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccount.GLAccountText
     * GLAccountText} entity using key fields.
     *
     * @param gLAccount
     *            G/L Account Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param chartOfAccounts
     *            Chart of Accounts
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccount.GLAccountText
     *         GLAccountText} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccount.GLAccountTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GLAccountTextByKeyFluentHelper
        getGLAccountTextByKey( final String chartOfAccounts, final String gLAccount, final String language );

}
