/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierNodeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierNodeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchyNodeTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchyNodeTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchyTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchyTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.batch.GrantHierarchyServiceBatch;

/**
 * <p>
 * This service enables you to read the grant hierarchy master data from SAP S/4HANA Cloud system.
 *
 * This service is based on the OData protocol and can be consumed in SAP Fiori apps and other user interfaces. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/88/51bd5b1afb49f89cb6b4096515b792/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_GRANTCOREHIERARCHY?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_GRANTCOREHIERARCHY</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.1</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Public Sector API Integration(SAP_COM_0761)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/6UC'>Government Budget Planning(6UC)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Grant</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface GrantHierarchyService extends BatchService<GrantHierarchyServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_GRANTCOREHIERARCHY";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    GrantHierarchyService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchy
     * GrantCoreHierarchy} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchy
     *         GrantCoreHierarchy} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantCoreHierarchyFluentHelper getAllGrantCoreHierarchy();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchy
     * GrantCoreHierarchy} entity using key fields.
     *
     * @param grantHierarchy
     *            Grant Hierarchy
     *            <p>
     *            Constraints: Not nullable, Maximum length: 42
     *            </p>
     * @param validityEndDate
     *            Validity End Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchy
     *         GrantCoreHierarchy} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchyByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantCoreHierarchyByKeyFluentHelper
        getGrantCoreHierarchyByKey( final String grantHierarchy, final LocalDateTime validityEndDate );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchyNodeText
     * GrantCoreHierarchyNodeText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchyNodeText
     *         GrantCoreHierarchyNodeText} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchyNodeTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantCoreHierarchyNodeTextFluentHelper getAllGrantCoreHierarchyNodeText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchyNodeText
     * GrantCoreHierarchyNodeText} entity using key fields.
     *
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param grantHierarchy
     *            Grant Hierarchy
     *            <p>
     *            Constraints: Not nullable, Maximum length: 42
     *            </p>
     * @param validityEndDate
     *            Validity End Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param hierarchyNode
     *            Hierarchy node
     *            <p>
     *            Constraints: Not nullable, Maximum length: 50
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchyNodeText
     *         GrantCoreHierarchyNodeText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchyNodeTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantCoreHierarchyNodeTextByKeyFluentHelper getGrantCoreHierarchyNodeTextByKey(
        final String grantHierarchy,
        final String hierarchyNode,
        final LocalDateTime validityEndDate,
        final String language );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchyText
     * GrantCoreHierarchyText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchyText
     *         GrantCoreHierarchyText} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchyTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantCoreHierarchyTextFluentHelper getAllGrantCoreHierarchyText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchyText
     * GrantCoreHierarchyText} entity using key fields.
     *
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param grantHierarchy
     *            Grant Hierarchy
     *            <p>
     *            Constraints: Not nullable, Maximum length: 42
     *            </p>
     * @param validityEndDate
     *            Validity End Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchyText
     *         GrantCoreHierarchyText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchyTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantCoreHierarchyTextByKeyFluentHelper getGrantCoreHierarchyTextByKey(
        final String grantHierarchy,
        final LocalDateTime validityEndDate,
        final String language );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierNode
     * GrantCoreHierNode} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierNode
     *         GrantCoreHierNode} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierNodeFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantCoreHierNodeFluentHelper getAllGrantCoreHierNode();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierNode
     * GrantCoreHierNode} entity using key fields.
     *
     * @param grantHierarchy
     *            Grant Hierarchy
     *            <p>
     *            Constraints: Not nullable, Maximum length: 42
     *            </p>
     * @param validityEndDate
     *            Validity End Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param hierarchyNode
     *            Hierarchy node
     *            <p>
     *            Constraints: Not nullable, Maximum length: 50
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierNode
     *         GrantCoreHierNode} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierNodeByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantCoreHierNodeByKeyFluentHelper getGrantCoreHierNodeByKey(
        final String grantHierarchy,
        final String hierarchyNode,
        final LocalDateTime validityEndDate );

}
