/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.ChangeLifecycleStatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantBdgtValidityLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantBdgtValidityLinkByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantBdgtValidityLinkDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantBdgtValidityLinkFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantBdgtValidityLinkUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCoreByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCoreCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCoreDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCoreFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCoreText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCoreTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCoreTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCoreTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCoreUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCostSharingLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCostSharingLinkByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCostSharingLinkDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCostSharingLinkFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCostSharingLinkUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantFundsLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantFundsLinkByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantFundsLinkDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantFundsLinkFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantFundsLinkUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantObjOvrHeadCostCapLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantObjOvrHeadCostCapLinkByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantObjOvrHeadCostCapLinkDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantObjOvrHeadCostCapLinkFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantObjOvrHeadCostCapLinkUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostCapLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostCapLinkByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostCapLinkDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostCapLinkFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostCapLinkUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostLinkByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostLinkDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostLinkFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostLinkUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredClassesLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredClassesLinkByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredClassesLinkDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredClassesLinkFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredClassesLinkUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredProgramsLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredProgramsLinkByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredProgramsLinkDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredProgramsLinkFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredProgramsLinkUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.batch.GrantServiceBatch;

/**
 * <p>
 *
 * This service enables you to create, read, update, and delete the grant master data from SAP S/4HANA Cloud system.
 * This service is based on the OData protocol and can be consumed in SAP Fiori apps and other user interfaces..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/51/7981acd97a4f70bc28311b21cf5eea/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference:
 * <a href='https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_GRANTCORE?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_GRANTCORE</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.1.1</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Public Sector API Integration(SAP_COM_0761)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/6UC'>Government Budget Planning(6UC)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Grant</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface GrantService extends BatchService<GrantServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_GRANTCORE";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    GrantService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantBdgtValidityLink
     * GrantBdgtValidityLink} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantBdgtValidityLink
     *         GrantBdgtValidityLink} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantBdgtValidityLinkFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantBdgtValidityLinkFluentHelper getAllGrantBdgtValidityLink();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantBdgtValidityLink
     * GrantBdgtValidityLink} entity using key fields.
     *
     * @param granteeMgmtBudgetStatus
     *            Budget Status: Unreleased/Released
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param grantID
     *            Grant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param granteeMgmtBdgtPhase
     *            Budget Phase
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param gteeMBudgetValidityNumber
     *            Budget Validity Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantBdgtValidityLink
     *         GrantBdgtValidityLink} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantBdgtValidityLinkByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantBdgtValidityLinkByKeyFluentHelper getGrantBdgtValidityLinkByKey(
        final String grantID,
        final String granteeMgmtBdgtPhase,
        final String granteeMgmtBudgetStatus,
        final String gteeMBudgetValidityNumber );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantBdgtValidityLink
     * GrantBdgtValidityLink} entity and save it to the S/4HANA system.
     *
     * @param grantBdgtValidityLink
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantBdgtValidityLink
     *            GrantBdgtValidityLink} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantBdgtValidityLink
     *         GrantBdgtValidityLink} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantBdgtValidityLinkUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantBdgtValidityLinkUpdateFluentHelper
        updateGrantBdgtValidityLink( @Nonnull final GrantBdgtValidityLink grantBdgtValidityLink );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantBdgtValidityLink
     * GrantBdgtValidityLink} entity in the S/4HANA system.
     *
     * @param grantBdgtValidityLink
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantBdgtValidityLink
     *            GrantBdgtValidityLink} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantBdgtValidityLink
     *         GrantBdgtValidityLink} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantBdgtValidityLinkDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantBdgtValidityLinkDeleteFluentHelper
        deleteGrantBdgtValidityLink( @Nonnull final GrantBdgtValidityLink grantBdgtValidityLink );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore GrantCore} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore GrantCore} entities. This
     *         fluent helper allows methods which modify the underlying query to be called before executing the query
     *         itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCoreFluentHelper#execute execute}
     *         method on the fluent helper object.
     */
    @Nonnull
    GrantCoreFluentHelper getAllGrantCore();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore GrantCore} entity using
     * key fields.
     *
     * @param grantID
     *            Grant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore GrantCore} entity using key
     *         fields. This fluent helper allows methods which modify the underlying query to be called before executing
     *         the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCoreByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantCoreByKeyFluentHelper getGrantCoreByKey( final String grantID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore GrantCore} entity and
     * save it to the S/4HANA system.
     *
     * @param grantCore
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore GrantCore} entity object
     *            that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore GrantCore} entity. To perform
     *         execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCoreCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantCoreCreateFluentHelper createGrantCore( @Nonnull final GrantCore grantCore );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore GrantCore} entity
     * and save it to the S/4HANA system.
     *
     * @param grantCore
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore GrantCore} entity object
     *            that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore GrantCore} entity. To perform
     *         execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCoreUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantCoreUpdateFluentHelper updateGrantCore( @Nonnull final GrantCore grantCore );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore GrantCore} entity
     * in the S/4HANA system.
     *
     * @param grantCore
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore GrantCore} entity object
     *            that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore GrantCore} entity. To perform
     *         execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCoreDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantCoreDeleteFluentHelper deleteGrantCore( @Nonnull final GrantCore grantCore );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCoreText GrantCoreText}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCoreText GrantCoreText} entities.
     *         This fluent helper allows methods which modify the underlying query to be called before executing the
     *         query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCoreTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantCoreTextFluentHelper getAllGrantCoreText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCoreText GrantCoreText}
     * entity using key fields.
     *
     * @param grantID
     *            Grant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCoreText GrantCoreText} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCoreTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantCoreTextByKeyFluentHelper getGrantCoreTextByKey( final String grantID, final String language );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCoreText GrantCoreText}
     * entity and save it to the S/4HANA system.
     *
     * @param grantCoreText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCoreText GrantCoreText} entity
     *            object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCoreText GrantCoreText} entity. To
     *         perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCoreTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantCoreTextUpdateFluentHelper updateGrantCoreText( @Nonnull final GrantCoreText grantCoreText );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCostSharingLink
     * GrantCostSharingLink} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCostSharingLink
     *         GrantCostSharingLink} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCostSharingLinkFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantCostSharingLinkFluentHelper getAllGrantCostSharingLink();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCostSharingLink
     * GrantCostSharingLink} entity using key fields.
     *
     * @param financialManagementArea
     *            Financial Management Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param grantID
     *            Grant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param sponsoredClass
     *            Sponsored Class
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param fund
     *            Fund
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param gteeMCostSharingSource
     *            Cost Sharing Source
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param sponsoredProgram
     *            Sponsored Program
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCostSharingLink
     *         GrantCostSharingLink} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCostSharingLinkByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantCostSharingLinkByKeyFluentHelper getGrantCostSharingLinkByKey(
        final String grantID,
        final String financialManagementArea,
        final String fund,
        final String sponsoredProgram,
        final String sponsoredClass,
        final String gteeMCostSharingSource );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCostSharingLink
     * GrantCostSharingLink} entity and save it to the S/4HANA system.
     *
     * @param grantCostSharingLink
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCostSharingLink
     *            GrantCostSharingLink} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCostSharingLink
     *         GrantCostSharingLink} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCostSharingLinkUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantCostSharingLinkUpdateFluentHelper
        updateGrantCostSharingLink( @Nonnull final GrantCostSharingLink grantCostSharingLink );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCostSharingLink
     * GrantCostSharingLink} entity in the S/4HANA system.
     *
     * @param grantCostSharingLink
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCostSharingLink
     *            GrantCostSharingLink} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCostSharingLink
     *         GrantCostSharingLink} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCostSharingLinkDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantCostSharingLinkDeleteFluentHelper
        deleteGrantCostSharingLink( @Nonnull final GrantCostSharingLink grantCostSharingLink );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantFundsLink GrantFundsLink}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantFundsLink GrantFundsLink} entities.
     *         This fluent helper allows methods which modify the underlying query to be called before executing the
     *         query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantFundsLinkFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantFundsLinkFluentHelper getAllGrantFundsLink();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantFundsLink GrantFundsLink}
     * entity using key fields.
     *
     * @param financialManagementArea
     *            Financial Management Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param grantID
     *            Grant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param fund
     *            Fund
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantFundsLink GrantFundsLink} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantFundsLinkByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantFundsLinkByKeyFluentHelper
        getGrantFundsLinkByKey( final String grantID, final String financialManagementArea, final String fund );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantFundsLink
     * GrantFundsLink} entity and save it to the S/4HANA system.
     *
     * @param grantFundsLink
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantFundsLink GrantFundsLink} entity
     *            object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantFundsLink GrantFundsLink} entity.
     *         To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantFundsLinkUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantFundsLinkUpdateFluentHelper updateGrantFundsLink( @Nonnull final GrantFundsLink grantFundsLink );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantFundsLink
     * GrantFundsLink} entity in the S/4HANA system.
     *
     * @param grantFundsLink
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantFundsLink GrantFundsLink} entity
     *            object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantFundsLink GrantFundsLink} entity.
     *         To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantFundsLinkDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantFundsLinkDeleteFluentHelper deleteGrantFundsLink( @Nonnull final GrantFundsLink grantFundsLink );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantObjOvrHeadCostCapLink
     * GrantObjOvrHeadCostCapLink} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantObjOvrHeadCostCapLink
     *         GrantObjOvrHeadCostCapLink} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantObjOvrHeadCostCapLinkFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantObjOvrHeadCostCapLinkFluentHelper getAllGrantObjOvrHeadCostCapLink();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantObjOvrHeadCostCapLink
     * GrantObjOvrHeadCostCapLink} entity using key fields.
     *
     * @param grantID
     *            Grant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param sponsoredClass
     *            Sponsored Class
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param validityStartDate
     *            Valid-from Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param sponsoredProgram
     *            Sponsored Program
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantObjOvrHeadCostCapLink
     *         GrantObjOvrHeadCostCapLink} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantObjOvrHeadCostCapLinkByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantObjOvrHeadCostCapLinkByKeyFluentHelper getGrantObjOvrHeadCostCapLinkByKey(
        final String grantID,
        final String sponsoredProgram,
        final String sponsoredClass,
        final LocalDateTime validityStartDate );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantObjOvrHeadCostCapLink
     * GrantObjOvrHeadCostCapLink} entity and save it to the S/4HANA system.
     *
     * @param grantObjOvrHeadCostCapLink
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantObjOvrHeadCostCapLink
     *            GrantObjOvrHeadCostCapLink} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantObjOvrHeadCostCapLink
     *         GrantObjOvrHeadCostCapLink} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantObjOvrHeadCostCapLinkUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantObjOvrHeadCostCapLinkUpdateFluentHelper
        updateGrantObjOvrHeadCostCapLink( @Nonnull final GrantObjOvrHeadCostCapLink grantObjOvrHeadCostCapLink );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantObjOvrHeadCostCapLink
     * GrantObjOvrHeadCostCapLink} entity in the S/4HANA system.
     *
     * @param grantObjOvrHeadCostCapLink
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantObjOvrHeadCostCapLink
     *            GrantObjOvrHeadCostCapLink} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantObjOvrHeadCostCapLink
     *         GrantObjOvrHeadCostCapLink} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantObjOvrHeadCostCapLinkDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantObjOvrHeadCostCapLinkDeleteFluentHelper
        deleteGrantObjOvrHeadCostCapLink( @Nonnull final GrantObjOvrHeadCostCapLink grantObjOvrHeadCostCapLink );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostCapLink
     * GrantOverHeadCostCapLink} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostCapLink
     *         GrantOverHeadCostCapLink} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostCapLinkFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantOverHeadCostCapLinkFluentHelper getAllGrantOverHeadCostCapLink();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostCapLink
     * GrantOverHeadCostCapLink} entity using key fields.
     *
     * @param grantID
     *            Grant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param validityStartDate
     *            Valid-from Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostCapLink
     *         GrantOverHeadCostCapLink} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostCapLinkByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantOverHeadCostCapLinkByKeyFluentHelper
        getGrantOverHeadCostCapLinkByKey( final String grantID, final LocalDateTime validityStartDate );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostCapLink
     * GrantOverHeadCostCapLink} entity and save it to the S/4HANA system.
     *
     * @param grantOverHeadCostCapLink
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostCapLink
     *            GrantOverHeadCostCapLink} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostCapLink
     *         GrantOverHeadCostCapLink} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostCapLinkUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantOverHeadCostCapLinkUpdateFluentHelper
        updateGrantOverHeadCostCapLink( @Nonnull final GrantOverHeadCostCapLink grantOverHeadCostCapLink );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostCapLink
     * GrantOverHeadCostCapLink} entity in the S/4HANA system.
     *
     * @param grantOverHeadCostCapLink
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostCapLink
     *            GrantOverHeadCostCapLink} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostCapLink
     *         GrantOverHeadCostCapLink} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostCapLinkDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantOverHeadCostCapLinkDeleteFluentHelper
        deleteGrantOverHeadCostCapLink( @Nonnull final GrantOverHeadCostCapLink grantOverHeadCostCapLink );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostLink
     * GrantOverHeadCostLink} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostLink
     *         GrantOverHeadCostLink} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostLinkFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantOverHeadCostLinkFluentHelper getAllGrantOverHeadCostLink();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostLink
     * GrantOverHeadCostLink} entity using key fields.
     *
     * @param grantID
     *            Grant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param sponsoredClass
     *            Sponsored Class
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param validityStartDate
     *            Valid-from Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param sponsoredProgram
     *            Sponsored Program
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostLink
     *         GrantOverHeadCostLink} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostLinkByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantOverHeadCostLinkByKeyFluentHelper getGrantOverHeadCostLinkByKey(
        final String grantID,
        final String sponsoredProgram,
        final String sponsoredClass,
        final LocalDateTime validityStartDate );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostLink
     * GrantOverHeadCostLink} entity and save it to the S/4HANA system.
     *
     * @param grantOverHeadCostLink
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostLink
     *            GrantOverHeadCostLink} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostLink
     *         GrantOverHeadCostLink} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostLinkUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantOverHeadCostLinkUpdateFluentHelper
        updateGrantOverHeadCostLink( @Nonnull final GrantOverHeadCostLink grantOverHeadCostLink );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostLink
     * GrantOverHeadCostLink} entity in the S/4HANA system.
     *
     * @param grantOverHeadCostLink
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostLink
     *            GrantOverHeadCostLink} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostLink
     *         GrantOverHeadCostLink} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostLinkDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantOverHeadCostLinkDeleteFluentHelper
        deleteGrantOverHeadCostLink( @Nonnull final GrantOverHeadCostLink grantOverHeadCostLink );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredClassesLink
     * GrantSponsoredClassesLink} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredClassesLink
     *         GrantSponsoredClassesLink} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredClassesLinkFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantSponsoredClassesLinkFluentHelper getAllGrantSponsoredClassesLink();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredClassesLink
     * GrantSponsoredClassesLink} entity using key fields.
     *
     * @param grantID
     *            Grant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param sponsoredClass
     *            Sponsored Class
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredClassesLink
     *         GrantSponsoredClassesLink} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredClassesLinkByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantSponsoredClassesLinkByKeyFluentHelper
        getGrantSponsoredClassesLinkByKey( final String grantID, final String sponsoredClass );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredClassesLink
     * GrantSponsoredClassesLink} entity and save it to the S/4HANA system.
     *
     * @param grantSponsoredClassesLink
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredClassesLink
     *            GrantSponsoredClassesLink} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredClassesLink
     *         GrantSponsoredClassesLink} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredClassesLinkUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantSponsoredClassesLinkUpdateFluentHelper
        updateGrantSponsoredClassesLink( @Nonnull final GrantSponsoredClassesLink grantSponsoredClassesLink );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredClassesLink
     * GrantSponsoredClassesLink} entity in the S/4HANA system.
     *
     * @param grantSponsoredClassesLink
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredClassesLink
     *            GrantSponsoredClassesLink} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredClassesLink
     *         GrantSponsoredClassesLink} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredClassesLinkDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantSponsoredClassesLinkDeleteFluentHelper
        deleteGrantSponsoredClassesLink( @Nonnull final GrantSponsoredClassesLink grantSponsoredClassesLink );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredProgramsLink
     * GrantSponsoredProgramsLink} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredProgramsLink
     *         GrantSponsoredProgramsLink} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredProgramsLinkFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantSponsoredProgramsLinkFluentHelper getAllGrantSponsoredProgramsLink();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredProgramsLink
     * GrantSponsoredProgramsLink} entity using key fields.
     *
     * @param grantID
     *            Grant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param sponsoredProgram
     *            Sponsored Program
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredProgramsLink
     *         GrantSponsoredProgramsLink} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredProgramsLinkByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantSponsoredProgramsLinkByKeyFluentHelper
        getGrantSponsoredProgramsLinkByKey( final String grantID, final String sponsoredProgram );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredProgramsLink
     * GrantSponsoredProgramsLink} entity and save it to the S/4HANA system.
     *
     * @param grantSponsoredProgramsLink
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredProgramsLink
     *            GrantSponsoredProgramsLink} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredProgramsLink
     *         GrantSponsoredProgramsLink} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredProgramsLinkUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantSponsoredProgramsLinkUpdateFluentHelper
        updateGrantSponsoredProgramsLink( @Nonnull final GrantSponsoredProgramsLink grantSponsoredProgramsLink );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredProgramsLink
     * GrantSponsoredProgramsLink} entity in the S/4HANA system.
     *
     * @param grantSponsoredProgramsLink
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredProgramsLink
     *            GrantSponsoredProgramsLink} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredProgramsLink
     *         GrantSponsoredProgramsLink} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredProgramsLinkDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantSponsoredProgramsLinkDeleteFluentHelper
        deleteGrantSponsoredProgramsLink( @Nonnull final GrantSponsoredProgramsLink grantSponsoredProgramsLink );

    /**
     * <p>
     * Creates a fluent helper for the <b>ChangeLifecycleStatus</b> OData function import.
     * </p>
     *
     * @param grantID
     *            Grant
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>GrantID</b>
     *            </p>
     * @param grantLifecycleStatus
     *            Lifecycle Status
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 5
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>GrantLifecycleStatus</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ChangeLifecycleStatus</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.ChangeLifecycleStatusFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeLifecycleStatusFluentHelper
        changeLifecycleStatus( @Nonnull final String grantID, @Nullable final String grantLifecycleStatus );

}
