/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnitByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnitFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnitItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnitItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.batch.HandlingUnitServiceBatch;

/**
 * <p>
 * In every API call, you can make use of the following operations: - Retrieve header information for a handling unit.
 * For handling units processed in warehouse management, warehouse number plus handling unit number must be used as a
 * key. For handling units not relevant for warehouse management, the handling unit number is used as a key. You can use
 * filter criteria to retrieve information based on other selection criteria, for example, delivery reference. -
 * Retrieve item information for a handling unit, which contains information about the products packed in the handling
 * unit.
 *
 * You can apply the filters provided or retrieve all existing data..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2208.latest/EN/35/40bd25c1334dad9782b22c094bd748/frameset.htm?profile=20020833'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference:
 * <a href='https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_HANDLING_UNIT?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_HANDLING_UNIT</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2208</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Handling Unit Integration(SAP_COM_0364), Delivery Insights Replication App Integration
 * (Obsolete)(SAP_COM_0571)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3BS'>Warehouse Outbound Processing(3BS)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4MM'>Handling Unit Management(4MM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BD9'>Sell from Stock(BD9)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4IH'>Delivery Insights enabled by IoT(4IH)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Handling Unit</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated as of release 2105 (May 2021). Please use the
 *             odata generator to generate the VDM.
 */
@Deprecated
public interface HandlingUnitService extends BatchService<HandlingUnitServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_HANDLING_UNIT";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    HandlingUnitService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnit HandlingUnit}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnit HandlingUnit}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnitFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    HandlingUnitFluentHelper getAllHandlingUnit();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnit HandlingUnit}
     * entity using key fields.
     *
     * @param handlingUnitExternalID
     *            External Handling Unit Identification
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param warehouse
     *            Warehouse Number/Warehouse Complex
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnit HandlingUnit} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnitByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    HandlingUnitByKeyFluentHelper getHandlingUnitByKey( final String handlingUnitExternalID, final String warehouse );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnitItem
     * HandlingUnitItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnitItem
     *         HandlingUnitItem} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnitItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    HandlingUnitItemFluentHelper getAllHandlingUnitItem();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnitItem
     * HandlingUnitItem} entity using key fields.
     *
     * @param handlingUnitExternalID
     *            External Handling Unit Identification
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param stockItemUUID
     *            GUID Stock Item
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param warehouse
     *            Warehouse Number/Warehouse Complex
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnitItem
     *         HandlingUnitItem} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.HandlingUnitItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    HandlingUnitItemByKeyFluentHelper getHandlingUnitItemByKey(
        final String handlingUnitExternalID,
        final String warehouse,
        final UUID stockItemUUID );

}
