/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.math.BigDecimal;
import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.AddSerialNumberToDeliveryItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.ConfirmPutawayAllItemsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.ConfirmPutawayOneItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.CreateBatchSplitItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.DeleteAllSerialNumbersFromDeliveryItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.DeleteSerialNumberFromDeliveryItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryDocFlow;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryDocFlowByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryDocFlowUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryHeaderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryHeaderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryHeaderDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryHeaderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryHeaderUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliverySerialNmbrByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.PostGoodsReceiptFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.PutawayAllItemsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.PutawayOneItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.PutawayOneItemWithBaseQuantityFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.PutawayOneItemWithSalesQuantityFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.ReverseGoodsReceiptFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.SetPutawayQuantityWithBaseQuantityFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.batch.InboundDeliveryV2ServiceBatch;

/**
 * <p>
 * This service enables you to create, read, update and delete inbound deliveries. It can be consumed in Fiori apps and
 * on other user interfaces.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/d1/0ec16c462a44a7be6c6721c9bb0a93/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_INBOUND_DELIVERY_SRV_0002?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_INBOUND_DELIVERY_SRV_0002</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>2.1.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Delivery Processing Integration(SAP_COM_0106)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/2TX'>Direct Procurement with Inbound Delivery(2TX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BD9'>Sell from Stock(BD9)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BDD'>Lean Customer Returns(BDD)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OD9'>Sell from Stock(OD9)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1MI'>Delivery Processing without Order Reference(1MI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BDA'>Free of Charge Delivery(BDA)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BKP'>Customer Returns(BKP)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Inbound Delivery</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface InboundDeliveryV2Service extends BatchService<InboundDeliveryV2ServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_INBOUND_DELIVERY_SRV;v=0002";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    InboundDeliveryV2Service withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryDocFlow
     * InbDeliveryDocFlow} entity using key fields.
     *
     * @param precedingDocument
     *            Preceding Doc.
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param precedingDocumentItem
     *            Preceding Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param subsequentDocumentCategory
     *            Subs.Doc.Categ.
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryDocFlow
     *         InbDeliveryDocFlow} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryDocFlowByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InbDeliveryDocFlowByKeyFluentHelper getInbDeliveryDocFlowByKey(
        final String precedingDocument,
        final String precedingDocumentItem,
        final String subsequentDocumentCategory );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryDocFlow
     * InbDeliveryDocFlow} entity and save it to the S/4HANA system.
     *
     * @param inbDeliveryDocFlow
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryDocFlow
     *            InbDeliveryDocFlow} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryDocFlow
     *         InbDeliveryDocFlow} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryDocFlowUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InbDeliveryDocFlowUpdateFluentHelper
        updateInbDeliveryDocFlow( @Nonnull final InbDeliveryDocFlow inbDeliveryDocFlow );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryHeader
     * InbDeliveryHeader} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryHeader
     *         InbDeliveryHeader} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryHeaderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InbDeliveryHeaderFluentHelper getAllInbDeliveryHeader();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryHeader
     * InbDeliveryHeader} entity using key fields.
     *
     * @param deliveryDocument
     *            Delivery
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryHeader
     *         InbDeliveryHeader} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryHeaderByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InbDeliveryHeaderByKeyFluentHelper getInbDeliveryHeaderByKey( final String deliveryDocument );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryHeader
     * InbDeliveryHeader} entity and save it to the S/4HANA system.
     *
     * @param inbDeliveryHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryHeader
     *            InbDeliveryHeader} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryHeader
     *         InbDeliveryHeader} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryHeaderCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InbDeliveryHeaderCreateFluentHelper createInbDeliveryHeader( @Nonnull final InbDeliveryHeader inbDeliveryHeader );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryHeader
     * InbDeliveryHeader} entity and save it to the S/4HANA system.
     *
     * @param inbDeliveryHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryHeader
     *            InbDeliveryHeader} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryHeader
     *         InbDeliveryHeader} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryHeaderUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InbDeliveryHeaderUpdateFluentHelper updateInbDeliveryHeader( @Nonnull final InbDeliveryHeader inbDeliveryHeader );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryHeader InbDeliveryHeader}
     * entity in the S/4HANA system.
     *
     * @param inbDeliveryHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryHeader
     *            InbDeliveryHeader} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryHeader
     *         InbDeliveryHeader} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryHeaderDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InbDeliveryHeaderDeleteFluentHelper deleteInbDeliveryHeader( @Nonnull final InbDeliveryHeader inbDeliveryHeader );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryItem
     * InbDeliveryItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryItem
     *         InbDeliveryItem} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InbDeliveryItemFluentHelper getAllInbDeliveryItem();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryItem
     * InbDeliveryItem} entity using key fields.
     *
     * @param deliveryDocument
     *            Delivery
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param deliveryDocumentItem
     *            Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryItem
     *         InbDeliveryItem} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InbDeliveryItemByKeyFluentHelper
        getInbDeliveryItemByKey( final String deliveryDocument, final String deliveryDocumentItem );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryItem
     * InbDeliveryItem} entity and save it to the S/4HANA system.
     *
     * @param inbDeliveryItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryItem
     *            InbDeliveryItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryItem
     *         InbDeliveryItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InbDeliveryItemUpdateFluentHelper updateInbDeliveryItem( @Nonnull final InbDeliveryItem inbDeliveryItem );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryItem
     * InbDeliveryItem} entity in the S/4HANA system.
     *
     * @param inbDeliveryItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryItem
     *            InbDeliveryItem} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryItem
     *         InbDeliveryItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryItemDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InbDeliveryItemDeleteFluentHelper deleteInbDeliveryItem( @Nonnull final InbDeliveryItem inbDeliveryItem );

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryPartner
     * InbDeliveryPartner} entity using key fields.
     *
     * @param partnerFunction
     *            Partner Functn
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param sDDocument
     *            SD Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryPartner
     *         InbDeliveryPartner} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliveryPartnerByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InbDeliveryPartnerByKeyFluentHelper
        getInbDeliveryPartnerByKey( final String partnerFunction, final String sDDocument );

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliverySerialNmbr
     * InbDeliverySerialNmbr} entity using key fields.
     *
     * @param maintenanceItemObjectList
     *            Object list
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliverySerialNmbr
     *         InbDeliverySerialNmbr} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.InbDeliverySerialNmbrByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InbDeliverySerialNmbrByKeyFluentHelper getInbDeliverySerialNmbrByKey( final Long maintenanceItemObjectList );

    /**
     * <p>
     * Creates a fluent helper for the <b>ConfirmPutawayAllItems</b> OData function import.
     * </p>
     *
     * @param deliveryDocument
     *            Delivery
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryDocument</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ConfirmPutawayAllItems</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.ConfirmPutawayAllItemsFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ConfirmPutawayAllItemsFluentHelper confirmPutawayAllItems( @Nonnull final String deliveryDocument );

    /**
     * <p>
     * Creates a fluent helper for the <b>ConfirmPutawayOneItem</b> OData function import.
     * </p>
     *
     * @param deliveryDocument
     *            Delivery
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryDocument</b>
     *            </p>
     * @param deliveryDocumentItem
     *            Item
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryDocumentItem</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ConfirmPutawayOneItem</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.ConfirmPutawayOneItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ConfirmPutawayOneItemFluentHelper
        confirmPutawayOneItem( @Nonnull final String deliveryDocument, @Nonnull final String deliveryDocumentItem );

    /**
     * <p>
     * Creates a fluent helper for the <b>PostGoodsReceipt</b> OData function import.
     * </p>
     *
     * @param deliveryDocument
     *            Delivery
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryDocument</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>PostGoodsReceipt</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.PostGoodsReceiptFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PostGoodsReceiptFluentHelper postGoodsReceipt( @Nonnull final String deliveryDocument );

    /**
     * <p>
     * Creates a fluent helper for the <b>PostGoodsReceipt</b> OData function import.
     * </p>
     *
     * @param deliveryDocument
     *            Delivery
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryDocument</b>
     *            </p>
     * @param actualGoodsMovementDate
     *            Time Stamp
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 7
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ActualGoodsMovementDate</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>PostGoodsReceipt</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.PostGoodsReceiptFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PostGoodsReceiptFluentHelper postGoodsReceipt(
        @Nonnull final String deliveryDocument,
        @Nullable final LocalDateTime actualGoodsMovementDate );

    /**
     * <p>
     * Creates a fluent helper for the <b>PutawayAllItems</b> OData function import.
     * </p>
     *
     * @param deliveryDocument
     *            Delivery
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryDocument</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>PutawayAllItems</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.PutawayAllItemsFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PutawayAllItemsFluentHelper putawayAllItems( @Nonnull final String deliveryDocument );

    /**
     * <p>
     * Creates a fluent helper for the <b>PutawayOneItem</b> OData function import.
     * </p>
     *
     * @param deliveryDocument
     *            Delivery
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryDocument</b>
     *            </p>
     * @param deliveryDocumentItem
     *            Item
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryDocumentItem</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>PutawayOneItem</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.PutawayOneItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PutawayOneItemFluentHelper
        putawayOneItem( @Nonnull final String deliveryDocument, @Nonnull final String deliveryDocumentItem );

    /**
     * <p>
     * Creates a fluent helper for the <b>ReverseGoodsReceipt</b> OData function import.
     * </p>
     *
     * @param deliveryDocument
     *            Delivery
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryDocument</b>
     *            </p>
     * @param actualGoodsMovementDate
     *            Actual GI Date
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ActualGoodsMovementDate</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ReverseGoodsReceipt</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.ReverseGoodsReceiptFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ReverseGoodsReceiptFluentHelper reverseGoodsReceipt(
        @Nonnull final String deliveryDocument,
        @Nonnull final LocalDateTime actualGoodsMovementDate );

    /**
     * <p>
     * Creates a fluent helper for the <b>CreateBatchSplitItem</b> OData function import.
     * </p>
     *
     * @param shelfLifeExpirationDate
     *            Time Stamp
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ShelfLifeExpirationDate</b>
     *            </p>
     * @param deliveryDocument
     *            Constraints: Not nullable, Maximum length: 10
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryDocument</b>
     *            </p>
     * @param deliveryQuantityUnit
     *            Constraints: Not nullable, Maximum length: 3
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryQuantityUnit</b>
     *            </p>
     * @param batch
     *            Constraints: Not nullable, Maximum length: 10
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Batch</b>
     *            </p>
     * @param manufactureDate
     *            Time Stamp
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ManufactureDate</b>
     *            </p>
     * @param putawayQuantityInOrderUnit
     *            Constraints: Nullable, Precision: 3, Scale: 3
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PutawayQuantityInOrderUnit</b>
     *            </p>
     * @param actualDeliveryQuantity
     *            Constraints: Not nullable, Precision: 3, Scale: 3
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ActualDeliveryQuantity</b>
     *            </p>
     * @param batchBySupplier
     *            Constraints: Nullable, Maximum length: 15
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BatchBySupplier</b>
     *            </p>
     * @param deliveryDocumentItem
     *            Constraints: Not nullable, Maximum length: 6
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryDocumentItem</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>CreateBatchSplitItem</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.CreateBatchSplitItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreateBatchSplitItemFluentHelper createBatchSplitItem(
        @Nonnull final BigDecimal actualDeliveryQuantity,
        @Nonnull final String batch,
        @Nonnull final String deliveryDocument,
        @Nonnull final String deliveryDocumentItem,
        @Nonnull final String deliveryQuantityUnit,
        @Nullable final BigDecimal putawayQuantityInOrderUnit,
        @Nullable final LocalDateTime shelfLifeExpirationDate,
        @Nullable final LocalDateTime manufactureDate,
        @Nullable final String batchBySupplier );

    /**
     * <p>
     * Creates a fluent helper for the <b>AddSerialNumberToDeliveryItem</b> OData function import.
     * </p>
     *
     * @param serialNumber
     *            Serial Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SerialNumber</b>
     *            </p>
     * @param deliveryDocument
     *            Delivery
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryDocument</b>
     *            </p>
     * @param deliveryDocumentItem
     *            Item
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryDocumentItem</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>AddSerialNumberToDeliveryItem</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.AddSerialNumberToDeliveryItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AddSerialNumberToDeliveryItemFluentHelper addSerialNumberToDeliveryItem(
        @Nonnull final String deliveryDocument,
        @Nonnull final String deliveryDocumentItem,
        @Nonnull final String serialNumber );

    /**
     * <p>
     * Creates a fluent helper for the <b>DeleteAllSerialNumbersFromDeliveryItem</b> OData function import.
     * </p>
     *
     * @param deliveryDocument
     *            Delivery
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryDocument</b>
     *            </p>
     * @param deliveryDocumentItem
     *            Item
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryDocumentItem</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>DeleteAllSerialNumbersFromDeliveryItem</b> OData function
     *         import with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.DeleteAllSerialNumbersFromDeliveryItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DeleteAllSerialNumbersFromDeliveryItemFluentHelper deleteAllSerialNumbersFromDeliveryItem(
        @Nonnull final String deliveryDocument,
        @Nonnull final String deliveryDocumentItem );

    /**
     * <p>
     * Creates a fluent helper for the <b>DeleteSerialNumberFromDeliveryItem</b> OData function import.
     * </p>
     *
     * @param serialNumber
     *            Serial Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SerialNumber</b>
     *            </p>
     * @param deliveryDocument
     *            Delivery
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryDocument</b>
     *            </p>
     * @param deliveryDocumentItem
     *            Item
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryDocumentItem</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>DeleteSerialNumberFromDeliveryItem</b> OData function
     *         import with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.DeleteSerialNumberFromDeliveryItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DeleteSerialNumberFromDeliveryItemFluentHelper deleteSerialNumberFromDeliveryItem(
        @Nonnull final String deliveryDocument,
        @Nonnull final String deliveryDocumentItem,
        @Nonnull final String serialNumber );

    /**
     * <p>
     * Creates a fluent helper for the <b>SetPutawayQuantityWithBaseQuantity</b> OData function import.
     * </p>
     *
     * @param baseUnit
     *            Base Unit
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BaseUnit</b>
     *            </p>
     * @param deliveryDocument
     *            Delivery
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryDocument</b>
     *            </p>
     * @param actualDeliveredQtyInBaseUnit
     *            Qty (stckp.unt)
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Precision: 3, Scale: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ActualDeliveredQtyInBaseUnit</b>
     *            </p>
     * @param deliveryDocumentItem
     *            Item
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryDocumentItem</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>SetPutawayQuantityWithBaseQuantity</b> OData function
     *         import with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.SetPutawayQuantityWithBaseQuantityFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SetPutawayQuantityWithBaseQuantityFluentHelper setPutawayQuantityWithBaseQuantity(
        @Nonnull final BigDecimal actualDeliveredQtyInBaseUnit,
        @Nonnull final String baseUnit,
        @Nonnull final String deliveryDocument,
        @Nonnull final String deliveryDocumentItem );

    /**
     * <p>
     * Creates a fluent helper for the <b>PutawayOneItemWithBaseQuantity</b> OData function import.
     * </p>
     *
     * @param baseUnit
     *            Base Unit
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BaseUnit</b>
     *            </p>
     * @param deliveryDocument
     *            Delivery
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryDocument</b>
     *            </p>
     * @param actualDeliveredQtyInBaseUnit
     *            Qty (stckp.unt)
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Precision: 3, Scale: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ActualDeliveredQtyInBaseUnit</b>
     *            </p>
     * @param deliveryDocumentItem
     *            Item
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryDocumentItem</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>PutawayOneItemWithBaseQuantity</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.PutawayOneItemWithBaseQuantityFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PutawayOneItemWithBaseQuantityFluentHelper putawayOneItemWithBaseQuantity(
        @Nonnull final BigDecimal actualDeliveredQtyInBaseUnit,
        @Nonnull final String baseUnit,
        @Nonnull final String deliveryDocument,
        @Nonnull final String deliveryDocumentItem );

    /**
     * <p>
     * Creates a fluent helper for the <b>PutawayOneItemWithSalesQuantity</b> OData function import.
     * </p>
     *
     * @param deliveryDocument
     *            Delivery
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryDocument</b>
     *            </p>
     * @param deliveryQuantityUnit
     *            Sales Unit
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryQuantityUnit</b>
     *            </p>
     * @param actualDeliveryQuantity
     *            Delivery qty
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Precision: 3, Scale: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ActualDeliveryQuantity</b>
     *            </p>
     * @param deliveryDocumentItem
     *            Item
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryDocumentItem</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>PutawayOneItemWithSalesQuantity</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inbounddeliveryv2.PutawayOneItemWithSalesQuantityFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PutawayOneItemWithSalesQuantityFluentHelper putawayOneItemWithSalesQuantity(
        @Nonnull final BigDecimal actualDeliveryQuantity,
        @Nonnull final String deliveryDocument,
        @Nonnull final String deliveryDocumentItem,
        @Nonnull final String deliveryQuantityUnit );

}
