/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInvoiceBindingRecord;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInvoiceBindingRecordByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInvoiceBindingRecordCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInvoiceBindingRecordFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.DeclareInvoiceFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.ReceiveInvoiceFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.SignoffInvoiceFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.batch.IncomingVATInvoiceChinaServiceBatch;

/**
 * <p>
 *
 * The service is based on the *OData* protocol, and can be consumed by external systems and user interfaces to
 * integrate with incoming VAT invoice management in SAP S/4HANA Cloud. You can create a complete China VAT invoice
 * record including invoice header, item and binding record in one single call. You can also perform the following
 * operations: declare, receive, and sign off the invoice. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/66/70fe5b84bb4be28cf0782f1d60c328/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_CN_VAT_INVOICE_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_CN_VAT_INVOICE_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Incoming China VAT Invoice Integration(SAP_COM_0546)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/J58'>Accounting and Financial Close(J58)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>China VAT Invoice</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface IncomingVATInvoiceChinaService extends BatchService<IncomingVATInvoiceChinaServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_CN_VAT_INVOICE_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    IncomingVATInvoiceChinaService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice
     * CN_TaxInputInvoice} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice
     *         CN_TaxInputInvoice} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CN_TaxInputInvoiceFluentHelper getAllCN_TaxInputInvoice();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice
     * CN_TaxInputInvoice} entity using key fields.
     *
     * @param cN_TaxInvcUUID
     *            China Tax Invoice UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice
     *         CN_TaxInputInvoice} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CN_TaxInputInvoiceByKeyFluentHelper getCN_TaxInputInvoiceByKey( final UUID cN_TaxInvcUUID );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice
     * CN_TaxInputInvoice} entity and save it to the S/4HANA system.
     *
     * @param cN_TaxInputInvoice
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice
     *            CN_TaxInputInvoice} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoice
     *         CN_TaxInputInvoice} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CN_TaxInputInvoiceCreateFluentHelper
        createCN_TaxInputInvoice( @Nonnull final CN_TaxInputInvoice cN_TaxInputInvoice );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItem
     * CN_TaxInputInvoiceItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItem
     *         CN_TaxInputInvoiceItem} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CN_TaxInputInvoiceItemFluentHelper getAllCN_TaxInputInvoiceItem();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItem
     * CN_TaxInputInvoiceItem} entity using key fields.
     *
     * @param cN_TaxInvcUUID
     *            China Tax Invoice UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param taxInvoiceItemUUID
     *            Invoice Item UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItem
     *         CN_TaxInputInvoiceItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CN_TaxInputInvoiceItemByKeyFluentHelper
        getCN_TaxInputInvoiceItemByKey( final UUID taxInvoiceItemUUID, final UUID cN_TaxInvcUUID );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItem
     * CN_TaxInputInvoiceItem} entity and save it to the S/4HANA system.
     *
     * @param cN_TaxInputInvoiceItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItem
     *            CN_TaxInputInvoiceItem} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItem
     *         CN_TaxInputInvoiceItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInputInvoiceItemCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CN_TaxInputInvoiceItemCreateFluentHelper
        createCN_TaxInputInvoiceItem( @Nonnull final CN_TaxInputInvoiceItem cN_TaxInputInvoiceItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInvoiceBindingRecord
     * CN_TaxInvoiceBindingRecord} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInvoiceBindingRecord
     *         CN_TaxInvoiceBindingRecord} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInvoiceBindingRecordFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CN_TaxInvoiceBindingRecordFluentHelper getAllCN_TaxInvoiceBindingRecord();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInvoiceBindingRecord
     * CN_TaxInvoiceBindingRecord} entity using key fields.
     *
     * @param cN_TaxInvcBindgUUID
     *            China Tax Invoice Binding UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param cN_TaxInvcBindgItmUUID
     *            China Tax Invoice Binding Item UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInvoiceBindingRecord
     *         CN_TaxInvoiceBindingRecord} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInvoiceBindingRecordByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CN_TaxInvoiceBindingRecordByKeyFluentHelper
        getCN_TaxInvoiceBindingRecordByKey( final UUID cN_TaxInvcBindgUUID, final UUID cN_TaxInvcBindgItmUUID );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInvoiceBindingRecord
     * CN_TaxInvoiceBindingRecord} entity and save it to the S/4HANA system.
     *
     * @param cN_TaxInvoiceBindingRecord
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInvoiceBindingRecord
     *            CN_TaxInvoiceBindingRecord} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInvoiceBindingRecord
     *         CN_TaxInvoiceBindingRecord} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.CN_TaxInvoiceBindingRecordCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CN_TaxInvoiceBindingRecordCreateFluentHelper
        createCN_TaxInvoiceBindingRecord( @Nonnull final CN_TaxInvoiceBindingRecord cN_TaxInvoiceBindingRecord );

    /**
     * <p>
     * Creates a fluent helper for the <b>receiveInvoice</b> OData function import.
     * </p>
     *
     * @param cN_TaxInvcUUID
     *            UUID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CN_TaxInvcUUID</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>receiveInvoice</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.ReceiveInvoiceFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ReceiveInvoiceFluentHelper receiveInvoice( @Nonnull final UUID cN_TaxInvcUUID );

    /**
     * <p>
     * Creates a fluent helper for the <b>signoffInvoice</b> OData function import.
     * </p>
     *
     * @param cN_TaxInvcUUID
     *            UUID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CN_TaxInvcUUID</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>signoffInvoice</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.SignoffInvoiceFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SignoffInvoiceFluentHelper signoffInvoice( @Nonnull final UUID cN_TaxInvcUUID );

    /**
     * <p>
     * Creates a fluent helper for the <b>declareInvoice</b> OData function import.
     * </p>
     *
     * @param declnMonth
     *            Constraints: Not nullable, Maximum length: 2
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeclnMonth</b>
     *            </p>
     * @param cN_TaxInvcUUID
     *            UUID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CN_TaxInvcUUID</b>
     *            </p>
     * @param declnYear
     *            Constraints: Not nullable, Maximum length: 4
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeclnYear</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>declareInvoice</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.incomingvatinvoicechina.DeclareInvoiceFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DeclareInvoiceFluentHelper declareInvoice(
        @Nonnull final UUID cN_TaxInvcUUID,
        @Nonnull final String declnMonth,
        @Nonnull final String declnYear );

}
