/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethodByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethodFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethodTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethodTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.batch.InspectionMethodServiceBatch;

/**
 * <p>
 *
 * An inspection method is a master data record that describes the procedure for performing the quality inspection of a
 * characteristic. This service enables you to retrieve inspection methods with their settings and administrative data..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/93/c446582d6e0a02e10000000a44147b/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_INSPECTIONMETHOD_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_INSPECTIONMETHOD_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>2.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Inspection Master Data Integration(SAP_COM_0110)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1E1'>Quality Management in Discrete Manufacturing(1E1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1FM'>Quality Management in Procurement(1FM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1MP'>Quality Management in Sales(1MP)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1MR'>Quality Management in Stock Handling(1MR)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2QN'>Nonconformance Management(2QN)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Inspection Method</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface InspectionMethodService extends BatchService<InspectionMethodServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_INSPECTIONMETHOD_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    InspectionMethodService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethod
     * InspectionMethod} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethod
     *         InspectionMethod} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethodFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspectionMethodFluentHelper getAllInspectionMethod();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethod
     * InspectionMethod} entity using key fields.
     *
     * @param inspectionMethodVersion
     *            Version Number of Inspection Method
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param inspectionMethodPlant
     *            Plant for Inspection Method
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param inspectionMethod
     *            Inspection Method
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethod
     *         InspectionMethod} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethodByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspectionMethodByKeyFluentHelper getInspectionMethodByKey(
        final String inspectionMethod,
        final String inspectionMethodVersion,
        final String inspectionMethodPlant );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethodText
     * InspectionMethodText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethodText
     *         InspectionMethodText} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethodTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspectionMethodTextFluentHelper getAllInspectionMethodText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethodText
     * InspectionMethodText} entity using key fields.
     *
     * @param inspectionMethodVersion
     *            Version Number for the Inspection Method Text (QM)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param inspectionMethodPlant
     *            Plant for Inspection Method
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param inspectionMethod
     *            Inspection Method
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethodText
     *         InspectionMethodText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionmethod.InspectionMethodTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspectionMethodTextByKeyFluentHelper getInspectionMethodTextByKey(
        final String inspectionMethodPlant,
        final String inspectionMethod,
        final String inspectionMethodVersion,
        final String language );

}
