/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharcByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharcCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharcDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharcFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharcUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmtByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmtCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmtDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmtFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmtUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristicByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristicCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristicDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristicFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristicUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRTByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRTCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRTDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRTFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRTUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOperation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOperationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOperationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOperationDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOperationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOperationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlanByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlanCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlanDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlanFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlanUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.batch.InspectionPlanServiceBatch;

/**
 * <p>
 *
 * Inspection plans help you to describe how a quality inspection of one or several materials is to take place. In the
 * inspection plan, you define the sequence of inspection operations and the range of specifications available for
 * inspecting inspection characteristics..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/df/80a14a344046d99ebd21b59861d131/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_INSPECTIONPLAN_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_INSPECTIONPLAN_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Inspection Master Data Integration(SAP_COM_0110)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1E1'>Quality Management in Discrete Manufacturing(1E1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1FM'>Quality Management in Procurement(1FM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1MP'>Quality Management in Sales(1MP)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1MR'>Quality Management in Stock Handling(1MR)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2QN'>Nonconformance Management(2QN)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Inspection Plan</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface InspectionPlanService extends BatchService<InspectionPlanServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_INSPECTIONPLAN_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    InspectionPlanService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan
     * InspectionPlan} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan InspectionPlan}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlanFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspectionPlanFluentHelper getAllInspectionPlan();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan
     * InspectionPlan} entity using key fields.
     *
     * @param inspectionPlan
     *            Group Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param inspectionPlanInternalVersion
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param inspectionPlanGroup
     *            Key for Task List Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan InspectionPlan}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlanByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspectionPlanByKeyFluentHelper getInspectionPlanByKey(
        final String inspectionPlanGroup,
        final String inspectionPlan,
        final String inspectionPlanInternalVersion );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan
     * InspectionPlan} entity and save it to the S/4HANA system.
     *
     * @param inspectionPlan
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan
     *            InspectionPlan} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan InspectionPlan}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlanCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspectionPlanCreateFluentHelper createInspectionPlan( @Nonnull final InspectionPlan inspectionPlan );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan
     * InspectionPlan} entity and save it to the S/4HANA system.
     *
     * @param inspectionPlan
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan
     *            InspectionPlan} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan InspectionPlan}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlanUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspectionPlanUpdateFluentHelper updateInspectionPlan( @Nonnull final InspectionPlan inspectionPlan );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan
     * InspectionPlan} entity in the S/4HANA system.
     *
     * @param inspectionPlan
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan
     *            InspectionPlan} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlan InspectionPlan}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspectionPlanDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspectionPlanDeleteFluentHelper deleteInspectionPlan( @Nonnull final InspectionPlan inspectionPlan );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc
     * InspPlanDepdntCharc} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc
     *         InspPlanDepdntCharc} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharcFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspPlanDepdntCharcFluentHelper getAllInspPlanDepdntCharc();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc
     * InspPlanDepdntCharc} entity using key fields.
     *
     * @param bOOOperationInternalID
     *            Number of the Task List Node
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param bOOCharacteristic
     *            Inspection Characteristic Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param bOOCharacteristicVersion
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param bOODpndantCharcSpec
     *            Number for Dependent Characteristic Specifications
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param inspectionPlan
     *            Group Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param bOODpndantCharcSpecVers
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param inspectionPlanInternalVersion
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param inspectionPlanGroup
     *            Key for Task List Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param bOOOpInternalVersionCounter
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc
     *         InspPlanDepdntCharc} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharcByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspPlanDepdntCharcByKeyFluentHelper getInspPlanDepdntCharcByKey(
        final String inspectionPlanGroup,
        final String inspectionPlan,
        final String inspectionPlanInternalVersion,
        final String bOOOperationInternalID,
        final String bOOOpInternalVersionCounter,
        final String bOOCharacteristic,
        final String bOOCharacteristicVersion,
        final String bOODpndantCharcSpec,
        final String bOODpndantCharcSpecVers );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc
     * InspPlanDepdntCharc} entity and save it to the S/4HANA system.
     *
     * @param inspPlanDepdntCharc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc
     *            InspPlanDepdntCharc} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc
     *         InspPlanDepdntCharc} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharcCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspPlanDepdntCharcCreateFluentHelper
        createInspPlanDepdntCharc( @Nonnull final InspPlanDepdntCharc inspPlanDepdntCharc );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc
     * InspPlanDepdntCharc} entity and save it to the S/4HANA system.
     *
     * @param inspPlanDepdntCharc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc
     *            InspPlanDepdntCharc} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc
     *         InspPlanDepdntCharc} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharcUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspPlanDepdntCharcUpdateFluentHelper
        updateInspPlanDepdntCharc( @Nonnull final InspPlanDepdntCharc inspPlanDepdntCharc );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc
     * InspPlanDepdntCharc} entity in the S/4HANA system.
     *
     * @param inspPlanDepdntCharc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc
     *            InspPlanDepdntCharc} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharc
     *         InspPlanDepdntCharc} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanDepdntCharcDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspPlanDepdntCharcDeleteFluentHelper
        deleteInspPlanDepdntCharc( @Nonnull final InspPlanDepdntCharc inspPlanDepdntCharc );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt
     * InspPlanMaterialAssgmt} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt
     *         InspPlanMaterialAssgmt} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmtFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspPlanMaterialAssgmtFluentHelper getAllInspPlanMaterialAssgmt();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt
     * InspPlanMaterialAssgmt} entity using key fields.
     *
     * @param material
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param inspPlanMatlAssignment
     *            Counter for Additional Criteria
     *            <p>
     *            Constraints: Not nullable, Maximum length: 7
     *            </p>
     * @param inspPlanMatlAssgmtIntVersion
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param inspectionPlan
     *            Group Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param inspectionPlanGroup
     *            Key for Task List Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt
     *         InspPlanMaterialAssgmt} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmtByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspPlanMaterialAssgmtByKeyFluentHelper getInspPlanMaterialAssgmtByKey(
        final String material,
        final String plant,
        final String inspectionPlanGroup,
        final String inspectionPlan,
        final String inspPlanMatlAssignment,
        final String inspPlanMatlAssgmtIntVersion );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt
     * InspPlanMaterialAssgmt} entity and save it to the S/4HANA system.
     *
     * @param inspPlanMaterialAssgmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt
     *            InspPlanMaterialAssgmt} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt
     *         InspPlanMaterialAssgmt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmtCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspPlanMaterialAssgmtCreateFluentHelper
        createInspPlanMaterialAssgmt( @Nonnull final InspPlanMaterialAssgmt inspPlanMaterialAssgmt );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt
     * InspPlanMaterialAssgmt} entity and save it to the S/4HANA system.
     *
     * @param inspPlanMaterialAssgmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt
     *            InspPlanMaterialAssgmt} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt
     *         InspPlanMaterialAssgmt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmtUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspPlanMaterialAssgmtUpdateFluentHelper
        updateInspPlanMaterialAssgmt( @Nonnull final InspPlanMaterialAssgmt inspPlanMaterialAssgmt );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt
     * InspPlanMaterialAssgmt} entity in the S/4HANA system.
     *
     * @param inspPlanMaterialAssgmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt
     *            InspPlanMaterialAssgmt} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmt
     *         InspPlanMaterialAssgmt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanMaterialAssgmtDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspPlanMaterialAssgmtDeleteFluentHelper
        deleteInspPlanMaterialAssgmt( @Nonnull final InspPlanMaterialAssgmt inspPlanMaterialAssgmt );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic
     * InspPlanOpCharacteristic} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic
     *         InspPlanOpCharacteristic} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristicFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspPlanOpCharacteristicFluentHelper getAllInspPlanOpCharacteristic();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic
     * InspPlanOpCharacteristic} entity using key fields.
     *
     * @param bOOOperationInternalID
     *            Number of the Task List Node
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param bOOCharacteristic
     *            Inspection Characteristic Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param bOOCharacteristicVersion
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param inspectionPlan
     *            Group Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param inspectionPlanInternalVersion
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param inspectionPlanGroup
     *            Key for Task List Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param bOOOpInternalVersionCounter
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic
     *         InspPlanOpCharacteristic} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristicByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspPlanOpCharacteristicByKeyFluentHelper getInspPlanOpCharacteristicByKey(
        final String inspectionPlanGroup,
        final String bOOOperationInternalID,
        final String bOOCharacteristic,
        final String bOOCharacteristicVersion,
        final String bOOOpInternalVersionCounter,
        final String inspectionPlanInternalVersion,
        final String inspectionPlan );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic
     * InspPlanOpCharacteristic} entity and save it to the S/4HANA system.
     *
     * @param inspPlanOpCharacteristic
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic
     *            InspPlanOpCharacteristic} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic
     *         InspPlanOpCharacteristic} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristicCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspPlanOpCharacteristicCreateFluentHelper
        createInspPlanOpCharacteristic( @Nonnull final InspPlanOpCharacteristic inspPlanOpCharacteristic );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic
     * InspPlanOpCharacteristic} entity and save it to the S/4HANA system.
     *
     * @param inspPlanOpCharacteristic
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic
     *            InspPlanOpCharacteristic} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic
     *         InspPlanOpCharacteristic} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristicUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspPlanOpCharacteristicUpdateFluentHelper
        updateInspPlanOpCharacteristic( @Nonnull final InspPlanOpCharacteristic inspPlanOpCharacteristic );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic
     * InspPlanOpCharacteristic} entity in the S/4HANA system.
     *
     * @param inspPlanOpCharacteristic
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic
     *            InspPlanOpCharacteristic} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristic
     *         InspPlanOpCharacteristic} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpCharacteristicDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspPlanOpCharacteristicDeleteFluentHelper
        deleteInspPlanOpCharacteristic( @Nonnull final InspPlanOpCharacteristic inspPlanOpCharacteristic );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOperation
     * InspPlanOperation} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOperation
     *         InspPlanOperation} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOperationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspPlanOperationFluentHelper getAllInspPlanOperation();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOperation
     * InspPlanOperation} entity using key fields.
     *
     * @param bOOOperationInternalID
     *            Number of the Task List Node
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param inspectionPlan
     *            Group Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param inspectionPlanInternalVersion
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param inspectionPlanGroup
     *            Key for Task List Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param bOOOpInternalVersionCounter
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOperation
     *         InspPlanOperation} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOperationByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspPlanOperationByKeyFluentHelper getInspPlanOperationByKey(
        final String inspectionPlanGroup,
        final String bOOOperationInternalID,
        final String inspectionPlanInternalVersion,
        final String bOOOpInternalVersionCounter,
        final String inspectionPlan );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOperation
     * InspPlanOperation} entity and save it to the S/4HANA system.
     *
     * @param inspPlanOperation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOperation
     *            InspPlanOperation} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOperation
     *         InspPlanOperation} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOperationCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspPlanOperationCreateFluentHelper createInspPlanOperation( @Nonnull final InspPlanOperation inspPlanOperation );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOperation
     * InspPlanOperation} entity and save it to the S/4HANA system.
     *
     * @param inspPlanOperation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOperation
     *            InspPlanOperation} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOperation
     *         InspPlanOperation} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOperationUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspPlanOperationUpdateFluentHelper updateInspPlanOperation( @Nonnull final InspPlanOperation inspPlanOperation );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOperation
     * InspPlanOperation} entity in the S/4HANA system.
     *
     * @param inspPlanOperation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOperation
     *            InspPlanOperation} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOperation
     *         InspPlanOperation} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOperationDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspPlanOperationDeleteFluentHelper deleteInspPlanOperation( @Nonnull final InspPlanOperation inspPlanOperation );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT
     * InspPlanOpPRT} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT InspPlanOpPRT}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRTFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspPlanOpPRTFluentHelper getAllInspPlanOpPRT();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT
     * InspPlanOpPRT} entity using key fields.
     *
     * @param bOOOperationInternalID
     *            Number of the Task List Node
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param bOOOperationPRTInternalID
     *            Item Counter for Production Resources/Tools
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param inspectionPlan
     *            Group Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param inspectionPlanInternalVersion
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param inspectionPlanGroup
     *            Key for Task List Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param bOOOpInternalVersionCounter
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT InspPlanOpPRT}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRTByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspPlanOpPRTByKeyFluentHelper getInspPlanOpPRTByKey(
        final String inspectionPlanGroup,
        final String inspectionPlan,
        final String inspectionPlanInternalVersion,
        final String bOOOpInternalVersionCounter,
        final String bOOOperationInternalID,
        final String bOOOperationPRTInternalID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT
     * InspPlanOpPRT} entity and save it to the S/4HANA system.
     *
     * @param inspPlanOpPRT
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT InspPlanOpPRT}
     *            entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT InspPlanOpPRT}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRTCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspPlanOpPRTCreateFluentHelper createInspPlanOpPRT( @Nonnull final InspPlanOpPRT inspPlanOpPRT );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT
     * InspPlanOpPRT} entity and save it to the S/4HANA system.
     *
     * @param inspPlanOpPRT
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT InspPlanOpPRT}
     *            entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT InspPlanOpPRT}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRTUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspPlanOpPRTUpdateFluentHelper updateInspPlanOpPRT( @Nonnull final InspPlanOpPRT inspPlanOpPRT );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT
     * InspPlanOpPRT} entity in the S/4HANA system.
     *
     * @param inspPlanOpPRT
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT InspPlanOpPRT}
     *            entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRT InspPlanOpPRT}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.inspectionplan.InspPlanOpPRTDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspPlanOpPRTDeleteFluentHelper deleteInspPlanOpPRT( @Nonnull final InspPlanOpPRT inspPlanOpPRT );

}
