/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.intelligentproductproposal.SalesDocumentProposalItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.intelligentproductproposal.SalesDocumentProposalItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.intelligentproductproposal.batch.IntelligentProductProposalServiceBatch;

/**
 * <p>
 *
 * In this API, you can retrieve product and quantity proposals. Apply any of the filters provided or retrieve all
 * existing data..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/73/122fae9acf4206a29b3ce0932d72d2/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_INTELLIGENTPRODUCTPROPOSAL_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_INTELLIGENTPRODUCTPROPOSAL_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Intelligent Product Proposal Integration(SAP_COM_0718)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BD9'>Sell from Stock(BD9)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OD9'>Sell from Stock(OD9)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Sales Order</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface IntelligentProductProposalService extends BatchService<IntelligentProductProposalServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_INTELLIGENTPRODUCTPROPOSAL_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    IntelligentProductProposalService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.intelligentproductproposal.SalesDocumentProposalItem
     * SalesDocumentProposalItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.intelligentproductproposal.SalesDocumentProposalItem
     *         SalesDocumentProposalItem} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.intelligentproductproposal.SalesDocumentProposalItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesDocumentProposalItemFluentHelper getAllSalesDocumentProposalItem();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.intelligentproductproposal.SalesDocumentProposalItem
     * SalesDocumentProposalItem} entity using key fields.
     *
     * @param organizationDivision
     *            Division
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param soldToParty
     *            Customer Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param salesOffice
     *            Sales Office
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param salesGroup
     *            Sales Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param distributionChannel
     *            Distribution Channel
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param salesDocumentType
     *            Sales Document Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param salesOrganization
     *            Sales Organization
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.intelligentproductproposal.SalesDocumentProposalItem
     *         SalesDocumentProposalItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.intelligentproductproposal.SalesDocumentProposalItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesDocumentProposalItemByKeyFluentHelper getSalesDocumentProposalItemByKey(
        final String salesOrganization,
        final String distributionChannel,
        final String organizationDivision,
        final String salesGroup,
        final String salesOffice,
        final String soldToParty,
        final String salesDocumentType );

}
