/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.jointventurebilling.GetAttachmentLinksFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.jointventurebilling.batch.JointVentureBillingServiceBatch;

/**
 * <p>
 * The service enables you to retrieve list of billing files generated for a Joint Venture Partner. This list would
 * provide details on key attributes which would be required to fetch attachments using the Attachment Reuse Service.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/d9/c2f5bdb8e449ac95686f00a9e0f676/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_JVA_BILLING_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_JVA_BILLING_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Joint Venture Partner Billing Files Integration(SAP_COM_0381)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3F7'>Joint Venture Accounting(3F7)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Joint Venture Billing - Read</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface JointVentureBillingService extends BatchService<JointVentureBillingServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_JVA_BILLING_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    JointVentureBillingService withServicePath( @Nonnull final String servicePath );

    /**
     * Get Billing File
     * <p>
     * </p>
     * <p>
     * Creates a fluent helper for the <b>GetAttachmentLinks</b> OData function import.
     * </p>
     *
     * @param companyCode
     *            Constraints: Not nullable, Maximum length: 4
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CompanyCode</b>
     *            </p>
     * @param fiscalPeriod
     *            Constraints: Not nullable, Maximum length: 3
     *            <p>
     *            Original parameter name from the Odata EDM: <b>FiscalPeriod</b>
     *            </p>
     * @param fiscalYear
     *            Constraints: Not nullable, Maximum length: 4
     *            <p>
     *            Original parameter name from the Odata EDM: <b>FiscalYear</b>
     *            </p>
     * @param jointVenturePartner
     *            Constraints: Nullable, Maximum length: 10
     *            <p>
     *            Original parameter name from the Odata EDM: <b>JointVenturePartner</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>GetAttachmentLinks</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.jointventurebilling.GetAttachmentLinksFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GetAttachmentLinksFluentHelper getAttachmentLinks(
        @Nonnull final String companyCode,
        @Nonnull final String fiscalYear,
        @Nonnull final String fiscalPeriod,
        @Nullable final String jointVenturePartner );

}
