/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrpByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrpCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrpFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrpUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatlByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatlCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatlDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatlFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatlUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeaderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeaderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeaderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeaderUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompGrp;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompGrpByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompGrpCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompGrpDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompGrpFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompGrpUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatl;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatlByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatlCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatlDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatlFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatlUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextHdr;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextHdrByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextHdrCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextHdrDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextHdrFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextHdrUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.batch.JustInTimeCallServiceBatch;

/**
 * <p>
 *
 * JIT processing is a common practice in manufacturing industries for efficient demand-driven production and logistics
 * across supply chains. Just-In-Time Supply to Customer covers JIT processes from the perspective of a supplier. This
 * service enables you to read, create, and update JIT calls. For example, you can use this service to create a JIT call
 * or to allocate or delete component materials..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/e6/26b94c627e4f30b5b64b657dafbee4/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_JIT_CALL_PROCESS_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_JIT_CALL_PROCESS_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Logistics - Just In Time Inbound Integration(SAP_COM_0168)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/2EM'>Just-In-Time Supply to Customer(2EM)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Just In Time Call</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface JustInTimeCallService extends BatchService<JustInTimeCallServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_JIT_CALL_PROCESS_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    JustInTimeCallService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp
     * JITCallCompGrp} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp JITCallCompGrp}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrpFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    JITCallCompGrpFluentHelper getAllJITCallCompGrp();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp
     * JITCallCompGrp} entity using key fields.
     *
     * @param compGrpNumber
     *            Component Group Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 60
     *            </p>
     * @param internalJITCallNumber
     *            Call Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp JITCallCompGrp}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrpByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    JITCallCompGrpByKeyFluentHelper
        getJITCallCompGrpByKey( final String internalJITCallNumber, final String compGrpNumber );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp
     * JITCallCompGrp} entity and save it to the S/4HANA system.
     *
     * @param jITCallCompGrp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp
     *            JITCallCompGrp} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp JITCallCompGrp}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrpCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    JITCallCompGrpCreateFluentHelper createJITCallCompGrp( @Nonnull final JITCallCompGrp jITCallCompGrp );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp
     * JITCallCompGrp} entity and save it to the S/4HANA system.
     *
     * @param jITCallCompGrp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp
     *            JITCallCompGrp} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrp JITCallCompGrp}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompGrpUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    JITCallCompGrpUpdateFluentHelper updateJITCallCompGrp( @Nonnull final JITCallCompGrp jITCallCompGrp );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl
     * JITCallCompMatl} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl
     *         JITCallCompMatl} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatlFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    JITCallCompMatlFluentHelper getAllJITCallCompMatl();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl
     * JITCallCompMatl} entity using key fields.
     *
     * @param compGrpNumber
     *            Component Group Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 60
     *            </p>
     * @param jITCallItemNumber
     *            Call Item Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param internalJITCallNumber
     *            Call Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl
     *         JITCallCompMatl} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatlByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    JITCallCompMatlByKeyFluentHelper getJITCallCompMatlByKey(
        final String internalJITCallNumber,
        final String compGrpNumber,
        final String jITCallItemNumber );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl
     * JITCallCompMatl} entity and save it to the S/4HANA system.
     *
     * @param jITCallCompMatl
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl
     *            JITCallCompMatl} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl
     *         JITCallCompMatl} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatlCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    JITCallCompMatlCreateFluentHelper createJITCallCompMatl( @Nonnull final JITCallCompMatl jITCallCompMatl );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl
     * JITCallCompMatl} entity and save it to the S/4HANA system.
     *
     * @param jITCallCompMatl
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl
     *            JITCallCompMatl} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl
     *         JITCallCompMatl} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatlUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    JITCallCompMatlUpdateFluentHelper updateJITCallCompMatl( @Nonnull final JITCallCompMatl jITCallCompMatl );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl
     * JITCallCompMatl} entity in the S/4HANA system.
     *
     * @param jITCallCompMatl
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl
     *            JITCallCompMatl} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatl
     *         JITCallCompMatl} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallCompMatlDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    JITCallCompMatlDeleteFluentHelper deleteJITCallCompMatl( @Nonnull final JITCallCompMatl jITCallCompMatl );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader
     * JITCallHeader} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader JITCallHeader}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeaderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    JITCallHeaderFluentHelper getAllJITCallHeader();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader
     * JITCallHeader} entity using key fields.
     *
     * @param internalJITCallNumber
     *            Call Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader JITCallHeader}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeaderByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    JITCallHeaderByKeyFluentHelper getJITCallHeaderByKey( final String internalJITCallNumber );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader
     * JITCallHeader} entity and save it to the S/4HANA system.
     *
     * @param jITCallHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader JITCallHeader}
     *            entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader JITCallHeader}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeaderCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    JITCallHeaderCreateFluentHelper createJITCallHeader( @Nonnull final JITCallHeader jITCallHeader );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader
     * JITCallHeader} entity and save it to the S/4HANA system.
     *
     * @param jITCallHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader JITCallHeader}
     *            entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeader JITCallHeader}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallHeaderUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    JITCallHeaderUpdateFluentHelper updateJITCallHeader( @Nonnull final JITCallHeader jITCallHeader );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompGrp
     * JITCallRefTextCompGrp} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompGrp
     *         JITCallRefTextCompGrp} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompGrpFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    JITCallRefTextCompGrpFluentHelper getAllJITCallRefTextCompGrp();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompGrp
     * JITCallRefTextCompGrp} entity using key fields.
     *
     * @param compGrpNumber
     *            Component Group Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 60
     *            </p>
     * @param jITRefType
     *            Type of Reference Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param internalJITCallNumber
     *            Call Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompGrp
     *         JITCallRefTextCompGrp} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompGrpByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    JITCallRefTextCompGrpByKeyFluentHelper getJITCallRefTextCompGrpByKey(
        final String internalJITCallNumber,
        final String compGrpNumber,
        final String jITRefType );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompGrp
     * JITCallRefTextCompGrp} entity and save it to the S/4HANA system.
     *
     * @param jITCallRefTextCompGrp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompGrp
     *            JITCallRefTextCompGrp} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompGrp
     *         JITCallRefTextCompGrp} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompGrpCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    JITCallRefTextCompGrpCreateFluentHelper
        createJITCallRefTextCompGrp( @Nonnull final JITCallRefTextCompGrp jITCallRefTextCompGrp );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompGrp
     * JITCallRefTextCompGrp} entity and save it to the S/4HANA system.
     *
     * @param jITCallRefTextCompGrp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompGrp
     *            JITCallRefTextCompGrp} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompGrp
     *         JITCallRefTextCompGrp} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompGrpUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    JITCallRefTextCompGrpUpdateFluentHelper
        updateJITCallRefTextCompGrp( @Nonnull final JITCallRefTextCompGrp jITCallRefTextCompGrp );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompGrp
     * JITCallRefTextCompGrp} entity in the S/4HANA system.
     *
     * @param jITCallRefTextCompGrp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompGrp
     *            JITCallRefTextCompGrp} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompGrp
     *         JITCallRefTextCompGrp} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompGrpDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    JITCallRefTextCompGrpDeleteFluentHelper
        deleteJITCallRefTextCompGrp( @Nonnull final JITCallRefTextCompGrp jITCallRefTextCompGrp );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatl
     * JITCallRefTextCompMatl} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatl
     *         JITCallRefTextCompMatl} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatlFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    JITCallRefTextCompMatlFluentHelper getAllJITCallRefTextCompMatl();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatl
     * JITCallRefTextCompMatl} entity using key fields.
     *
     * @param compGrpNumber
     *            Component Group Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 60
     *            </p>
     * @param jITCallItemNumber
     *            Call Item Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param jITRefType
     *            Type of Reference Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param internalJITCallNumber
     *            Call Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatl
     *         JITCallRefTextCompMatl} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatlByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    JITCallRefTextCompMatlByKeyFluentHelper getJITCallRefTextCompMatlByKey(
        final String internalJITCallNumber,
        final String compGrpNumber,
        final String jITCallItemNumber,
        final String jITRefType );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatl
     * JITCallRefTextCompMatl} entity and save it to the S/4HANA system.
     *
     * @param jITCallRefTextCompMatl
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatl
     *            JITCallRefTextCompMatl} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatl
     *         JITCallRefTextCompMatl} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatlCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    JITCallRefTextCompMatlCreateFluentHelper
        createJITCallRefTextCompMatl( @Nonnull final JITCallRefTextCompMatl jITCallRefTextCompMatl );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatl
     * JITCallRefTextCompMatl} entity and save it to the S/4HANA system.
     *
     * @param jITCallRefTextCompMatl
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatl
     *            JITCallRefTextCompMatl} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatl
     *         JITCallRefTextCompMatl} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatlUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    JITCallRefTextCompMatlUpdateFluentHelper
        updateJITCallRefTextCompMatl( @Nonnull final JITCallRefTextCompMatl jITCallRefTextCompMatl );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatl
     * JITCallRefTextCompMatl} entity in the S/4HANA system.
     *
     * @param jITCallRefTextCompMatl
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatl
     *            JITCallRefTextCompMatl} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatl
     *         JITCallRefTextCompMatl} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextCompMatlDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    JITCallRefTextCompMatlDeleteFluentHelper
        deleteJITCallRefTextCompMatl( @Nonnull final JITCallRefTextCompMatl jITCallRefTextCompMatl );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextHdr
     * JITCallRefTextHdr} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextHdr
     *         JITCallRefTextHdr} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextHdrFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    JITCallRefTextHdrFluentHelper getAllJITCallRefTextHdr();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextHdr
     * JITCallRefTextHdr} entity using key fields.
     *
     * @param jITRefType
     *            Type of Reference Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param internalJITCallNumber
     *            Call Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextHdr
     *         JITCallRefTextHdr} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextHdrByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    JITCallRefTextHdrByKeyFluentHelper
        getJITCallRefTextHdrByKey( final String internalJITCallNumber, final String jITRefType );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextHdr
     * JITCallRefTextHdr} entity and save it to the S/4HANA system.
     *
     * @param jITCallRefTextHdr
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextHdr
     *            JITCallRefTextHdr} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextHdr
     *         JITCallRefTextHdr} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextHdrCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    JITCallRefTextHdrCreateFluentHelper createJITCallRefTextHdr( @Nonnull final JITCallRefTextHdr jITCallRefTextHdr );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextHdr
     * JITCallRefTextHdr} entity and save it to the S/4HANA system.
     *
     * @param jITCallRefTextHdr
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextHdr
     *            JITCallRefTextHdr} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextHdr
     *         JITCallRefTextHdr} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextHdrUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    JITCallRefTextHdrUpdateFluentHelper updateJITCallRefTextHdr( @Nonnull final JITCallRefTextHdr jITCallRefTextHdr );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextHdr
     * JITCallRefTextHdr} entity in the S/4HANA system.
     *
     * @param jITCallRefTextHdr
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextHdr
     *            JITCallRefTextHdr} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextHdr
     *         JITCallRefTextHdr} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.justintimecall.JITCallRefTextHdrDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    JITCallRefTextHdrDeleteFluentHelper deleteJITCallRefTextHdr( @Nonnull final JITCallRefTextHdr jITCallRefTextHdr );

}
