/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.math.BigDecimal;
import java.time.ZonedDateTime;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.AddEventDrivenKanbanContainerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainerDeliveryAddrByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainerDeliveryAddrFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycleByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycleCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycleDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycleFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycleUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanCtnDetailedQtyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanCtnDetailedQtyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanDeliveryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanDeliveryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.SetKanbanContainerLockFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.SetKanbanContainerStatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.SetKanbanControlCycleLifeCycleStatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.WithdrawQuantityFromControlCycleFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.WithdrawQuantityFromKanbanContainerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.batch.KanbanControlCycleV2ServiceBatch;

/**
 * <p>
 *
 * The kanban OData API enables you to create and retrieve kanban control cycles and their kanban container data.
 * Additionally, it is possible to change control cycles, to set the status both on control cycle and on container
 * level, and to lock/unlock containers. Furthermore, you can add new containers for event-driven kanban control cycles
 * and you can report the withdrawal out of one or more containers.
 *
 * The service is based on the OData protocol and can be consumed by external systems and user interfaces..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/a2/71dc21bc514d2b80701e88409533f9/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_KANBAN_CONTROL_CYCLE_SRV_0002?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_KANBAN_CONTROL_CYCLE_SRV_0002</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>2.1.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Kanban Control Cycle Integration(SAP_COM_0330)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1E3'>Material Replenishment with Kanban - External
 * Procurement(1E3)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/4B3'>Material Replenishment with Kanban -
 * In-House Production(4B3)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/4B4'>Material Replenishment with Kanban
 * - Stock Transfer(4B4)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Kanban Control Cycle</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface KanbanControlCycleV2Service extends BatchService<KanbanControlCycleV2ServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_KANBAN_CONTROL_CYCLE_SRV;v=0002";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    KanbanControlCycleV2Service withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer
     * KanbanContainer} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer
     *         KanbanContainer} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainerFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    KanbanContainerFluentHelper getAllKanbanContainer();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer
     * KanbanContainer} entity using key fields.
     *
     * @param kanbanContainer
     *            Kanban Container
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer
     *         KanbanContainer} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainerByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    KanbanContainerByKeyFluentHelper getKanbanContainerByKey( final String kanbanContainer );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainerDeliveryAddr
     * KanbanContainerDeliveryAddr} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainerDeliveryAddr
     *         KanbanContainerDeliveryAddr} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainerDeliveryAddrFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    KanbanContainerDeliveryAddrFluentHelper getAllKanbanContainerDeliveryAddr();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainerDeliveryAddr
     * KanbanContainerDeliveryAddr} entity using key fields.
     *
     * @param kanbanControlCycle
     *            Kanban Control Cycle
     *            <p>
     *            Constraints: Not nullable, Maximum length: 7
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainerDeliveryAddr
     *         KanbanContainerDeliveryAddr} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainerDeliveryAddrByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    KanbanContainerDeliveryAddrByKeyFluentHelper getKanbanContainerDeliveryAddrByKey( final String kanbanControlCycle );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle
     * KanbanControlCycle} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle
     *         KanbanControlCycle} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycleFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    KanbanControlCycleFluentHelper getAllKanbanControlCycle();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle
     * KanbanControlCycle} entity using key fields.
     *
     * @param kanbanControlCycle
     *            Kanban Control Cycle
     *            <p>
     *            Constraints: Not nullable, Maximum length: 7
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle
     *         KanbanControlCycle} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycleByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    KanbanControlCycleByKeyFluentHelper getKanbanControlCycleByKey( final String kanbanControlCycle );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle
     * KanbanControlCycle} entity and save it to the S/4HANA system.
     *
     * @param kanbanControlCycle
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle
     *            KanbanControlCycle} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle
     *         KanbanControlCycle} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycleCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    KanbanControlCycleCreateFluentHelper
        createKanbanControlCycle( @Nonnull final KanbanControlCycle kanbanControlCycle );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle
     * KanbanControlCycle} entity and save it to the S/4HANA system.
     *
     * @param kanbanControlCycle
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle
     *            KanbanControlCycle} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle
     *         KanbanControlCycle} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycleUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    KanbanControlCycleUpdateFluentHelper
        updateKanbanControlCycle( @Nonnull final KanbanControlCycle kanbanControlCycle );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle
     * KanbanControlCycle} entity in the S/4HANA system.
     *
     * @param kanbanControlCycle
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle
     *            KanbanControlCycle} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle
     *         KanbanControlCycle} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycleDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    KanbanControlCycleDeleteFluentHelper
        deleteKanbanControlCycle( @Nonnull final KanbanControlCycle kanbanControlCycle );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanCtnDetailedQty
     * KanbanCtnDetailedQty} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanCtnDetailedQty
     *         KanbanCtnDetailedQty} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanCtnDetailedQtyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    KanbanCtnDetailedQtyFluentHelper getAllKanbanCtnDetailedQty();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanCtnDetailedQty
     * KanbanCtnDetailedQty} entity using key fields.
     *
     * @param batch
     *            Batch Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param kanbanContainer
     *            Kanban Identification Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanCtnDetailedQty
     *         KanbanCtnDetailedQty} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanCtnDetailedQtyByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    KanbanCtnDetailedQtyByKeyFluentHelper
        getKanbanCtnDetailedQtyByKey( final String kanbanContainer, final String batch );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanDelivery
     * KanbanDelivery} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanDelivery
     *         KanbanDelivery} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanDeliveryFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    KanbanDeliveryFluentHelper getAllKanbanDelivery();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanDelivery
     * KanbanDelivery} entity using key fields.
     *
     * @param kanbanContainer
     *            Kanban Identification Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanDelivery
     *         KanbanDelivery} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanDeliveryByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    KanbanDeliveryByKeyFluentHelper getKanbanDeliveryByKey( final String kanbanContainer );

    /**
     * <p>
     * Creates a fluent helper for the <b>SetKanbanContainerStatus</b> OData function import.
     * </p>
     *
     * @param actualQuantityInUnitOfEntry
     *            Actual Quantity
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 13, Scale: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ActualQuantityInUnitOfEntry</b>
     *            </p>
     * @param deliveryNote
     *            Delivery note
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 16
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryNote</b>
     *            </p>
     * @param kanbanContainerStatus
     *            Kanban Status
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>KanbanContainerStatus</b>
     *            </p>
     * @param batch
     *            Batch
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Batch</b>
     *            </p>
     * @param kanbanCtnStatusChangeDateTime
     *            Time Stamp
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 7
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>KanbanCtnStatusChangeDateTime</b>
     *            </p>
     * @param kanbanContainer
     *            Kanban ID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>KanbanContainer</b>
     *            </p>
     * @param unitOfEntry
     *            Unit
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>UnitOfEntry</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>SetKanbanContainerStatus</b> OData function import with
     *         the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.SetKanbanContainerStatusFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SetKanbanContainerStatusFluentHelper setKanbanContainerStatus(
        @Nonnull final String kanbanContainer,
        @Nullable final String kanbanContainerStatus,
        @Nullable final BigDecimal actualQuantityInUnitOfEntry,
        @Nullable final String unitOfEntry,
        @Nullable final String batch,
        @Nullable final ZonedDateTime kanbanCtnStatusChangeDateTime,
        @Nullable final String deliveryNote );

    /**
     * <p>
     * Creates a fluent helper for the <b>SetKanbanContainerLock</b> OData function import.
     * </p>
     *
     * @param isLocked
     *            Kanban is Locked
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>IsLocked</b>
     *            </p>
     * @param kanbanContainer
     *            Kanban ID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>KanbanContainer</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>SetKanbanContainerLock</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.SetKanbanContainerLockFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SetKanbanContainerLockFluentHelper
        setKanbanContainerLock( @Nonnull final String kanbanContainer, @Nonnull final Boolean isLocked );

    /**
     * <p>
     * Creates a fluent helper for the <b>SetKanbanControlCycleLifeCycleStatus</b> OData function import.
     * </p>
     *
     * @param kanbanCtrlCycleLifeCycleStatus
     *            Lifecycle Status
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>KanbanCtrlCycleLifeCycleStatus</b>
     *            </p>
     * @param kanbanControlCycle
     *            Control Cycle
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 7
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>KanbanControlCycle</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>SetKanbanControlCycleLifeCycleStatus</b> OData function
     *         import with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.SetKanbanControlCycleLifeCycleStatusFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SetKanbanControlCycleLifeCycleStatusFluentHelper setKanbanControlCycleLifeCycleStatus(
        @Nonnull final String kanbanControlCycle,
        @Nonnull final String kanbanCtrlCycleLifeCycleStatus );

    /**
     * <p>
     * Creates a fluent helper for the <b>AddEventDrivenKanbanContainer</b> OData function import.
     * </p>
     *
     * @param requestedDeliveryDateTime
     *            Time Stamp
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 7
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>RequestedDeliveryDateTime</b>
     *            </p>
     * @param numberOfLoadCarriers
     *            No.Load Carriers
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>NumberOfLoadCarriers</b>
     *            </p>
     * @param packingInstruction
     *            Packing instruction
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 20
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PackingInstruction</b>
     *            </p>
     * @param requestedQuantityInBaseUnit
     *            Requested Quantity
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 13, Scale: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>RequestedQuantityInBaseUnit</b>
     *            </p>
     * @param kanbanControlCycle
     *            Control Cycle
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 7
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>KanbanControlCycle</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>AddEventDrivenKanbanContainer</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.AddEventDrivenKanbanContainerFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AddEventDrivenKanbanContainerFluentHelper addEventDrivenKanbanContainer(
        @Nonnull final String kanbanControlCycle,
        @Nullable final BigDecimal requestedQuantityInBaseUnit,
        @Nullable final ZonedDateTime requestedDeliveryDateTime,
        @Nullable final String packingInstruction,
        @Nullable final Short numberOfLoadCarriers );

    /**
     * <p>
     * Creates a fluent helper for the <b>WithdrawQuantityFromControlCycle</b> OData function import.
     * </p>
     *
     * @param kanbanCtrlCycWthdrwlQtyInBsUnt
     *            Withdrawal quantity
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Precision: 13, Scale: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>KanbanCtrlCycWthdrwlQtyInBsUnt</b>
     *            </p>
     * @param kanbanControlCycle
     *            Control Cycle
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 7
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>KanbanControlCycle</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>WithdrawQuantityFromControlCycle</b> OData function
     *         import with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.WithdrawQuantityFromControlCycleFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WithdrawQuantityFromControlCycleFluentHelper withdrawQuantityFromControlCycle(
        @Nonnull final String kanbanControlCycle,
        @Nonnull final BigDecimal kanbanCtrlCycWthdrwlQtyInBsUnt );

    /**
     * <p>
     * Creates a fluent helper for the <b>WithdrawQuantityFromKanbanContainer</b> OData function import.
     * </p>
     *
     * @param kanbanCtnWithdrawalQtyInBsUnt
     *            Withdrawal quantity
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Precision: 13, Scale: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>KanbanCtnWithdrawalQtyInBsUnt</b>
     *            </p>
     * @param kanbanContainer
     *            Kanban ID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>KanbanContainer</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>WithdrawQuantityFromKanbanContainer</b> OData function
     *         import with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.WithdrawQuantityFromKanbanContainerFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WithdrawQuantityFromKanbanContainerFluentHelper withdrawQuantityFromKanbanContainer(
        @Nonnull final String kanbanContainer,
        @Nonnull final BigDecimal kanbanCtnWithdrawalQtyInBsUnt );

}
