/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.LglCntntMAccessLvlByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.LglCntntMAccessLvlFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.LglCntntMAccessLvlTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.LglCntntMAccessLvlTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.batch.LegalDocumentAccessLevelServiceBatch;

/**
 * <p>
 *
 * This synchronous inbound service is based on the OData protocol and can be consumed in integration scenarios or other
 * user interfaces. Access level is an attribute used for authorization checks in Enterprise Contract Management. This
 * service contains access level and access level text nodes. Using this service, you can read the access levels
 * maintained in its configuration..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/13/d3a2eeb9d9431fac2b6173d0d669b2/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/A_LGLCNTNTMACCESSLVL_CDS?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>A_LGLCNTNTMACCESSLVL_CDS</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Enterprise Contract Management and Assembly Integration(SAP_COM_0437)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/2OQ'>Integration to SAP Enterprise Contract Assembly(2OQ)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Legal Access Level</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface LegalDocumentAccessLevelService extends BatchService<LegalDocumentAccessLevelServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/A_LGLCNTNTMACCESSLVL_CDS";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    LegalDocumentAccessLevelService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.LglCntntMAccessLvl
     * LglCntntMAccessLvl} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.LglCntntMAccessLvl
     *         LglCntntMAccessLvl} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.LglCntntMAccessLvlFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglCntntMAccessLvlFluentHelper getAllLglCntntMAccessLvl();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.LglCntntMAccessLvl
     * LglCntntMAccessLvl} entity using key fields.
     *
     * @param lglCntntMAccessLvl
     *            Access Level
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.LglCntntMAccessLvl
     *         LglCntntMAccessLvl} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.LglCntntMAccessLvlByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglCntntMAccessLvlByKeyFluentHelper getLglCntntMAccessLvlByKey( final String lglCntntMAccessLvl );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.LglCntntMAccessLvlText
     * LglCntntMAccessLvlText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.LglCntntMAccessLvlText
     *         LglCntntMAccessLvlText} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.LglCntntMAccessLvlTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglCntntMAccessLvlTextFluentHelper getAllLglCntntMAccessLvlText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.LglCntntMAccessLvlText
     * LglCntntMAccessLvlText} entity using key fields.
     *
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param lglCntntMAccessLvl
     *            Access Level
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.LglCntntMAccessLvlText
     *         LglCntntMAccessLvlText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.LglCntntMAccessLvlTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglCntntMAccessLvlTextByKeyFluentHelper
        getLglCntntMAccessLvlTextByKey( final String lglCntntMAccessLvl, final String language );

}
