/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocument;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocumentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocumentCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocumentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocCategory;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocCategoryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocCategoryCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocCategoryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocParCategory;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocParCategoryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocParCategoryCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocParCategoryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglDocStamp;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglDocStampByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglDocStampCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglDocStampFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.SetLegalDocumentToAcceptedFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.batch.LegalDocumentServiceBatch;

/**
 * <p>
 *
 * Legal documents are instances of legal content which are tailored to a specific legal transaction. The service
 * contains legal document and legal document stamp nodes. The information sent in the request as a payload is used when
 * creating a legal document, including appropriate checks for restricted values and authorizations. Once the legal
 * document is created, the legal document ID is sent in the response with the data included in the legal document. If
 * there are any issues when the legal document is created, the system displays error messages in the response. Note
 * that to create or change the content of the legal document you need to use the Attachment Service that is also
 * published in the SAP API Business Hub. For more information, refer to the business documentation of this API..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/76/617b87de1c40cb876e874ea78981a2/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_LEGAL_DOCUMENT_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_LEGAL_DOCUMENT_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.1.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Legal Document Integration(SAP_COM_0178), Procurement - Supplier Quotation Management
 * Integration(SAP_COM_0760)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1XV'>SAP S/4HANA for Enterprise Contract Management(1XV)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4RD'>Direct Material Sourcing(4RD)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Legal Document</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface LegalDocumentService extends BatchService<LegalDocumentServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_LEGAL_DOCUMENT_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    LegalDocumentService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocument
     * LegalDocument} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocument LegalDocument}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocumentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LegalDocumentFluentHelper getAllLegalDocument();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocument
     * LegalDocument} entity using key fields.
     *
     * @param lglCntntMDocumentUUID
     *            Universal Unique Identifier
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocument LegalDocument}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocumentByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LegalDocumentByKeyFluentHelper getLegalDocumentByKey( final UUID lglCntntMDocumentUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocument
     * LegalDocument} entity and save it to the S/4HANA system.
     *
     * @param legalDocument
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocument LegalDocument}
     *            entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocument LegalDocument}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocumentCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LegalDocumentCreateFluentHelper createLegalDocument( @Nonnull final LegalDocument legalDocument );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocCategory
     * LglCntntMDocCategory} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocCategory
     *         LglCntntMDocCategory} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocCategoryFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglCntntMDocCategoryFluentHelper getAllLglCntntMDocCategory();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocCategory
     * LglCntntMDocCategory} entity using key fields.
     *
     * @param lglCntntMDocCategoryUUID
     *            Universal Unique Identifier
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocCategory
     *         LglCntntMDocCategory} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocCategoryByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglCntntMDocCategoryByKeyFluentHelper getLglCntntMDocCategoryByKey( final UUID lglCntntMDocCategoryUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocCategory
     * LglCntntMDocCategory} entity and save it to the S/4HANA system.
     *
     * @param lglCntntMDocCategory
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocCategory
     *            LglCntntMDocCategory} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocCategory
     *         LglCntntMDocCategory} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocCategoryCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglCntntMDocCategoryCreateFluentHelper
        createLglCntntMDocCategory( @Nonnull final LglCntntMDocCategory lglCntntMDocCategory );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocParCategory
     * LglCntntMDocParCategory} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocParCategory
     *         LglCntntMDocParCategory} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocParCategoryFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglCntntMDocParCategoryFluentHelper getAllLglCntntMDocParCategory();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocParCategory
     * LglCntntMDocParCategory} entity using key fields.
     *
     * @param lglCntntMDocParCatUUID
     *            Universal Unique Identifier
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocParCategory
     *         LglCntntMDocParCategory} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocParCategoryByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglCntntMDocParCategoryByKeyFluentHelper getLglCntntMDocParCategoryByKey( final UUID lglCntntMDocParCatUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocParCategory
     * LglCntntMDocParCategory} entity and save it to the S/4HANA system.
     *
     * @param lglCntntMDocParCategory
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocParCategory
     *            LglCntntMDocParCategory} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocParCategory
     *         LglCntntMDocParCategory} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocParCategoryCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglCntntMDocParCategoryCreateFluentHelper
        createLglCntntMDocParCategory( @Nonnull final LglCntntMDocParCategory lglCntntMDocParCategory );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglDocStamp LglDocStamp}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglDocStamp LglDocStamp}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglDocStampFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglDocStampFluentHelper getAllLglDocStamp();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglDocStamp LglDocStamp}
     * entity using key fields.
     *
     * @param lglCntntMDocumentStampUUID
     *            Universal Unique Identifier
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglDocStamp LglDocStamp} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglDocStampByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglDocStampByKeyFluentHelper getLglDocStampByKey( final UUID lglCntntMDocumentStampUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglDocStamp LglDocStamp}
     * entity and save it to the S/4HANA system.
     *
     * @param lglDocStamp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglDocStamp LglDocStamp}
     *            entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglDocStamp LglDocStamp} entity.
     *         To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglDocStampCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglDocStampCreateFluentHelper createLglDocStamp( @Nonnull final LglDocStamp lglDocStamp );

    /**
     * <p>
     * Creates a fluent helper for the <b>SetLegalDocumentToAccepted</b> OData function import.
     * </p>
     *
     * @param lglCntntMDocumentUUID
     *            Universal Unique ID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>LglCntntMDocumentUUID</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>SetLegalDocumentToAccepted</b> OData function import with
     *         the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.SetLegalDocumentToAcceptedFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SetLegalDocumentToAcceptedFluentHelper setLegalDocumentToAccepted( @Nonnull final UUID lglCntntMDocumentUUID );

}
