/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.LegalDocumentStatusByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.LegalDocumentStatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.LegalDocumentStatusTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.LegalDocumentStatusTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.batch.LegalDocumentStatusServiceBatch;

/**
 * <p>
 *
 * This service is based on the OData protocol and helps you to read the possible values of legal document status
 * through an API call. This describes the status of a legal document. For example, &#39;In Process&#39;,
 * &#39;Accepted&#39; and so on are the various statuses assigned to a legal document. This service contains legal
 * document status and legal document status text nodes. Using this service, you can read the legal document status type
 * maintained in the system. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/41/236bdf6d594cdc8c553e68c0a1b617/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_LEGALDOCUMENTSTATUS?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_LEGALDOCUMENTSTATUS</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.1</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Legal Document Integration(SAP_COM_0178)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1XV'>SAP S/4HANA for Enterprise Contract Management(1XV)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Legal Document Status</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface LegalDocumentStatusService extends BatchService<LegalDocumentStatusServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_LEGALDOCUMENTSTATUS";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    LegalDocumentStatusService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.LegalDocumentStatus
     * LegalDocumentStatus} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.LegalDocumentStatus
     *         LegalDocumentStatus} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.LegalDocumentStatusFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LegalDocumentStatusFluentHelper getAllLegalDocumentStatus();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.LegalDocumentStatus
     * LegalDocumentStatus} entity using key fields.
     *
     * @param internalDocumentStatus
     *            Document Status
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.LegalDocumentStatus
     *         LegalDocumentStatus} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.LegalDocumentStatusByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LegalDocumentStatusByKeyFluentHelper getLegalDocumentStatusByKey( final String internalDocumentStatus );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.LegalDocumentStatusText
     * LegalDocumentStatusText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.LegalDocumentStatusText
     *         LegalDocumentStatusText} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.LegalDocumentStatusTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LegalDocumentStatusTextFluentHelper getAllLegalDocumentStatusText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.LegalDocumentStatusText
     * LegalDocumentStatusText} entity using key fields.
     *
     * @param internalDocumentStatus
     *            Document Status
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.LegalDocumentStatusText
     *         LegalDocumentStatusText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.LegalDocumentStatusTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LegalDocumentStatusTextByKeyFluentHelper
        getLegalDocumentStatusTextByKey( final String internalDocumentStatus, final String language );

}
