/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.CancelFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransaction;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransactionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransactionCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransactionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransactionUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransCategoryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransCategoryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransCategoryGroupByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransCategoryGroupFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransDateByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransDateCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransDateDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransDateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransDateUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntityByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntityCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntityDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntityFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntityUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContact;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContactByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContactCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContactDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContactFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContactUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContact;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContactByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContactCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContactDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContactFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContactUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjects;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjectsByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjectsCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjectsDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjectsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjectsUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransParentCategoryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransParentCategoryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationship;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationshipByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationshipCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationshipDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationshipFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationshipUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.TerminateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.batch.LegalTransactionServiceBatch;

/**
 * <p>
 *
 * Legal Transactions are business objects that are used to manage the lifecycle of legal content. The service contains
 * legal transactions, categories, category groups, parent categories, dates, entities, external contacts, internal
 * contacts, linked objects, and relationships nodes. The information sent in the request as a payload, is used when
 * creating a legal transaction, including appropriate checks for restricted values and authorizations. Once the legal
 * transaction has been created, the legal transaction ID is sent in the response with the data included in the legal
 * transaction. If there are any issues when the legal transaction is created, the system displays error messages in the
 * response. Note that we support only deep create for the legal transaction node..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/1f/6862d0c8734cc9aacfc2a7746ed6b7/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_LEGAL_TRANSACTION_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_LEGAL_TRANSACTION_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Legal Transaction Integration(SAP_COM_0140), Procurement - Supplier Quotation Management
 * Integration(SAP_COM_0760)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1XV'>SAP S/4HANA for Enterprise Contract Management(1XV)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4RD'>Direct Material Sourcing(4RD)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Legal Transaction</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface LegalTransactionService extends BatchService<LegalTransactionServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_LEGAL_TRANSACTION_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    LegalTransactionService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransaction
     * LegalTransaction} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransaction
     *         LegalTransaction} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransactionFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LegalTransactionFluentHelper getAllLegalTransaction();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransaction
     * LegalTransaction} entity using key fields.
     *
     * @param legalTransactionUUID
     *            Universal Unique Identifier
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransaction
     *         LegalTransaction} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransactionByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LegalTransactionByKeyFluentHelper getLegalTransactionByKey( final UUID legalTransactionUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransaction
     * LegalTransaction} entity and save it to the S/4HANA system.
     *
     * @param legalTransaction
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransaction
     *            LegalTransaction} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransaction
     *         LegalTransaction} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransactionCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LegalTransactionCreateFluentHelper createLegalTransaction( @Nonnull final LegalTransaction legalTransaction );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransaction
     * LegalTransaction} entity and save it to the S/4HANA system.
     *
     * @param legalTransaction
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransaction
     *            LegalTransaction} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransaction
     *         LegalTransaction} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransactionUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LegalTransactionUpdateFluentHelper updateLegalTransaction( @Nonnull final LegalTransaction legalTransaction );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransCategory
     * LglTransCategory} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransCategory
     *         LglTransCategory} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransCategoryFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglTransCategoryFluentHelper getAllLglTransCategory();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransCategory
     * LglTransCategory} entity using key fields.
     *
     * @param legalTransactionCategoryUUID
     *            Universal Unique Identifier
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransCategory
     *         LglTransCategory} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransCategoryByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglTransCategoryByKeyFluentHelper getLglTransCategoryByKey( final UUID legalTransactionCategoryUUID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransCategoryGroup
     * LglTransCategoryGroup} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransCategoryGroup
     *         LglTransCategoryGroup} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransCategoryGroupFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglTransCategoryGroupFluentHelper getAllLglTransCategoryGroup();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransCategoryGroup
     * LglTransCategoryGroup} entity using key fields.
     *
     * @param legalTransactionCatGroupUUID
     *            Universal Unique Identifier
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransCategoryGroup
     *         LglTransCategoryGroup} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransCategoryGroupByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglTransCategoryGroupByKeyFluentHelper getLglTransCategoryGroupByKey( final UUID legalTransactionCatGroupUUID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransDate
     * LglTransDate} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransDate LglTransDate}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransDateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglTransDateFluentHelper getAllLglTransDate();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransDate
     * LglTransDate} entity using key fields.
     *
     * @param legalTransactionDateUUID
     *            Universal Unique Identifier
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransDate LglTransDate}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransDateByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglTransDateByKeyFluentHelper getLglTransDateByKey( final UUID legalTransactionDateUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransDate
     * LglTransDate} entity and save it to the S/4HANA system.
     *
     * @param lglTransDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransDate LglTransDate}
     *            entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransDate LglTransDate}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransDateCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglTransDateCreateFluentHelper createLglTransDate( @Nonnull final LglTransDate lglTransDate );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransDate
     * LglTransDate} entity and save it to the S/4HANA system.
     *
     * @param lglTransDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransDate LglTransDate}
     *            entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransDate LglTransDate}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransDateUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglTransDateUpdateFluentHelper updateLglTransDate( @Nonnull final LglTransDate lglTransDate );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransDate
     * LglTransDate} entity in the S/4HANA system.
     *
     * @param lglTransDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransDate LglTransDate}
     *            entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransDate LglTransDate}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransDateDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglTransDateDeleteFluentHelper deleteLglTransDate( @Nonnull final LglTransDate lglTransDate );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntity
     * LglTransEntity} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntity
     *         LglTransEntity} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntityFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglTransEntityFluentHelper getAllLglTransEntity();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntity
     * LglTransEntity} entity using key fields.
     *
     * @param legalTransactionEntityUUID
     *            Universal Unique Identifier
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntity
     *         LglTransEntity} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntityByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglTransEntityByKeyFluentHelper getLglTransEntityByKey( final UUID legalTransactionEntityUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntity
     * LglTransEntity} entity and save it to the S/4HANA system.
     *
     * @param lglTransEntity
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntity
     *            LglTransEntity} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntity
     *         LglTransEntity} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntityCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglTransEntityCreateFluentHelper createLglTransEntity( @Nonnull final LglTransEntity lglTransEntity );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntity
     * LglTransEntity} entity and save it to the S/4HANA system.
     *
     * @param lglTransEntity
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntity
     *            LglTransEntity} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntity
     *         LglTransEntity} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntityUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglTransEntityUpdateFluentHelper updateLglTransEntity( @Nonnull final LglTransEntity lglTransEntity );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntity
     * LglTransEntity} entity in the S/4HANA system.
     *
     * @param lglTransEntity
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntity
     *            LglTransEntity} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntity
     *         LglTransEntity} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntityDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglTransEntityDeleteFluentHelper deleteLglTransEntity( @Nonnull final LglTransEntity lglTransEntity );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContact
     * LglTransExternalContact} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContact
     *         LglTransExternalContact} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContactFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglTransExternalContactFluentHelper getAllLglTransExternalContact();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContact
     * LglTransExternalContact} entity using key fields.
     *
     * @param legalTransactionExtCntctUUID
     *            Universal Unique Identifier
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContact
     *         LglTransExternalContact} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContactByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglTransExternalContactByKeyFluentHelper getLglTransExternalContactByKey( final UUID legalTransactionExtCntctUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContact
     * LglTransExternalContact} entity and save it to the S/4HANA system.
     *
     * @param lglTransExternalContact
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContact
     *            LglTransExternalContact} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContact
     *         LglTransExternalContact} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContactCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglTransExternalContactCreateFluentHelper
        createLglTransExternalContact( @Nonnull final LglTransExternalContact lglTransExternalContact );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContact
     * LglTransExternalContact} entity and save it to the S/4HANA system.
     *
     * @param lglTransExternalContact
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContact
     *            LglTransExternalContact} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContact
     *         LglTransExternalContact} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContactUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglTransExternalContactUpdateFluentHelper
        updateLglTransExternalContact( @Nonnull final LglTransExternalContact lglTransExternalContact );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContact
     * LglTransExternalContact} entity in the S/4HANA system.
     *
     * @param lglTransExternalContact
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContact
     *            LglTransExternalContact} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContact
     *         LglTransExternalContact} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContactDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglTransExternalContactDeleteFluentHelper
        deleteLglTransExternalContact( @Nonnull final LglTransExternalContact lglTransExternalContact );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContact
     * LglTransInternalContact} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContact
     *         LglTransInternalContact} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContactFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglTransInternalContactFluentHelper getAllLglTransInternalContact();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContact
     * LglTransInternalContact} entity using key fields.
     *
     * @param legalTransactionIntCntctUUID
     *            Universal Unique Identifier
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContact
     *         LglTransInternalContact} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContactByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglTransInternalContactByKeyFluentHelper getLglTransInternalContactByKey( final UUID legalTransactionIntCntctUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContact
     * LglTransInternalContact} entity and save it to the S/4HANA system.
     *
     * @param lglTransInternalContact
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContact
     *            LglTransInternalContact} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContact
     *         LglTransInternalContact} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContactCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglTransInternalContactCreateFluentHelper
        createLglTransInternalContact( @Nonnull final LglTransInternalContact lglTransInternalContact );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContact
     * LglTransInternalContact} entity and save it to the S/4HANA system.
     *
     * @param lglTransInternalContact
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContact
     *            LglTransInternalContact} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContact
     *         LglTransInternalContact} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContactUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglTransInternalContactUpdateFluentHelper
        updateLglTransInternalContact( @Nonnull final LglTransInternalContact lglTransInternalContact );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContact
     * LglTransInternalContact} entity in the S/4HANA system.
     *
     * @param lglTransInternalContact
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContact
     *            LglTransInternalContact} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContact
     *         LglTransInternalContact} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContactDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglTransInternalContactDeleteFluentHelper
        deleteLglTransInternalContact( @Nonnull final LglTransInternalContact lglTransInternalContact );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjects
     * LglTransLinkedObjects} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjects
     *         LglTransLinkedObjects} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjectsFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglTransLinkedObjectsFluentHelper getAllLglTransLinkedObjects();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjects
     * LglTransLinkedObjects} entity using key fields.
     *
     * @param legalTransactionLinkdObjUUID
     *            Universal Unique Identifier
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjects
     *         LglTransLinkedObjects} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjectsByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglTransLinkedObjectsByKeyFluentHelper getLglTransLinkedObjectsByKey( final UUID legalTransactionLinkdObjUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjects
     * LglTransLinkedObjects} entity and save it to the S/4HANA system.
     *
     * @param lglTransLinkedObjects
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjects
     *            LglTransLinkedObjects} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjects
     *         LglTransLinkedObjects} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjectsCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglTransLinkedObjectsCreateFluentHelper
        createLglTransLinkedObjects( @Nonnull final LglTransLinkedObjects lglTransLinkedObjects );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjects
     * LglTransLinkedObjects} entity and save it to the S/4HANA system.
     *
     * @param lglTransLinkedObjects
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjects
     *            LglTransLinkedObjects} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjects
     *         LglTransLinkedObjects} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjectsUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglTransLinkedObjectsUpdateFluentHelper
        updateLglTransLinkedObjects( @Nonnull final LglTransLinkedObjects lglTransLinkedObjects );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjects
     * LglTransLinkedObjects} entity in the S/4HANA system.
     *
     * @param lglTransLinkedObjects
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjects
     *            LglTransLinkedObjects} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjects
     *         LglTransLinkedObjects} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjectsDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglTransLinkedObjectsDeleteFluentHelper
        deleteLglTransLinkedObjects( @Nonnull final LglTransLinkedObjects lglTransLinkedObjects );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransParentCategory
     * LglTransParentCategory} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransParentCategory
     *         LglTransParentCategory} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransParentCategoryFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglTransParentCategoryFluentHelper getAllLglTransParentCategory();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransParentCategory
     * LglTransParentCategory} entity using key fields.
     *
     * @param legalTransactionParCatUUID
     *            Universal Unique Identifier
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransParentCategory
     *         LglTransParentCategory} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransParentCategoryByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglTransParentCategoryByKeyFluentHelper getLglTransParentCategoryByKey( final UUID legalTransactionParCatUUID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationship
     * LglTransRelationship} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationship
     *         LglTransRelationship} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationshipFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglTransRelationshipFluentHelper getAllLglTransRelationship();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationship
     * LglTransRelationship} entity using key fields.
     *
     * @param legalTransactionRelshpUUID
     *            Universal Unique Identifier
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationship
     *         LglTransRelationship} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationshipByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglTransRelationshipByKeyFluentHelper getLglTransRelationshipByKey( final UUID legalTransactionRelshpUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationship
     * LglTransRelationship} entity and save it to the S/4HANA system.
     *
     * @param lglTransRelationship
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationship
     *            LglTransRelationship} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationship
     *         LglTransRelationship} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationshipCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglTransRelationshipCreateFluentHelper
        createLglTransRelationship( @Nonnull final LglTransRelationship lglTransRelationship );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationship
     * LglTransRelationship} entity and save it to the S/4HANA system.
     *
     * @param lglTransRelationship
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationship
     *            LglTransRelationship} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationship
     *         LglTransRelationship} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationshipUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglTransRelationshipUpdateFluentHelper
        updateLglTransRelationship( @Nonnull final LglTransRelationship lglTransRelationship );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationship
     * LglTransRelationship} entity in the S/4HANA system.
     *
     * @param lglTransRelationship
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationship
     *            LglTransRelationship} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationship
     *         LglTransRelationship} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationshipDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LglTransRelationshipDeleteFluentHelper
        deleteLglTransRelationship( @Nonnull final LglTransRelationship lglTransRelationship );

    /**
     * <p>
     * Creates a fluent helper for the <b>Cancel</b> OData function import.
     * </p>
     *
     * @param legalTransactionUUID
     *            Universal Unique ID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>LegalTransactionUUID</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>Cancel</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.CancelFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CancelFluentHelper cancel( @Nonnull final UUID legalTransactionUUID );

    /**
     * <p>
     * Creates a fluent helper for the <b>Terminate</b> OData function import.
     * </p>
     *
     * @param legalTransactionUUID
     *            Universal Unique ID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>LegalTransactionUUID</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>Terminate</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.TerminateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    TerminateFluentHelper terminate( @Nonnull final UUID legalTransactionUUID );

}
