/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItmByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItmFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.batch.LineItemOfTreasuryPostingJournalEntryServiceBatch;

/**
 * <p>
 * This gives you detailed information about the posted and reversed flows of financial transactions and treasury
 * positions. It is based on the OData protocol and can be consumed in Fiori apps and on other user interfaces.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/a5/c19312428b4fa7a956fbbf88440f44/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_TRSYPOSTGJRNLENTRITM_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_TRSYPOSTGJRNLENTRITM_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Finance - Treasury Posting Journal Integration(SAP_COM_0333)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1XN'>Market Rates Management - Manually via Upload(1XN)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OXN'>Market Data for Treasury and Risk Management(OXN)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>TreasuryPostingJournal</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface LineItemOfTreasuryPostingJournalEntryService
    extends
    BatchService<LineItemOfTreasuryPostingJournalEntryServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/A_TRSYPOSTGJRNLENTRITM_CDS";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    LineItemOfTreasuryPostingJournalEntryService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm
     * TrsyPostgJrnlEntrItm} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm
     *         TrsyPostgJrnlEntrItm} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItmFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    TrsyPostgJrnlEntrItmFluentHelper getAllTrsyPostgJrnlEntrItm();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm
     * TrsyPostgJrnlEntrItm} entity using key fields.
     *
     * @param trsyPositionContextUUID
     *            Object Identity in Database Format
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param trsyAccountingDocumentUUID
     *            Object Identity in Database Format
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param accountingDocumentItemRef
     *            Accounting Document Line Item Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm
     *         TrsyPostgJrnlEntrItm} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItmByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    TrsyPostgJrnlEntrItmByKeyFluentHelper getTrsyPostgJrnlEntrItmByKey(
        final UUID trsyAccountingDocumentUUID,
        final String accountingDocumentItemRef,
        final UUID trsyPositionContextUUID );

}
