/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.BOMItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.BOMItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.BOMItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.BOMItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.BOMItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.BOMItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.CreateVariantBOMFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.GetMaintBOMItemsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeaderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeaderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeaderDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeaderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeaderUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.batch.MaintenanceBillOfMaterialServiceBatch;

/**
 * <p>
 *
 * This service enables you to create, update, or delete the bill of material header and item. It is based on the OData
 * protocol and can be consumed in SAP Fiori apps and on other user interfaces. The service contains header and item
 * nodes for the bill of material. When performing an operation, the necessary information is sent in the request as a
 * payload. All information used when creating a maintenance BOM is checked for restricted values and authorizations. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/21/317859a54d477b89e43e4501249157/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_MAINTENANCEBOM?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_MAINTENANCEBOM</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.1</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Maintenance BOM API Integration(SAP_COM_0762)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/4HH'>Reactive Maintenance(4HH)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4HI'>Proactive Maintenance(4HI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4VT'>Improvement Maintenance(4VT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4WM'>Operational and Overhead Maintenance(4WM)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Maintenance Bill Of Material</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface MaintenanceBillOfMaterialService extends BatchService<MaintenanceBillOfMaterialServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_MAINTENANCEBOM";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    MaintenanceBillOfMaterialService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.BOMItem
     * BOMItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.BOMItem BOMItem}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.BOMItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BOMItemFluentHelper getAllBOMItem();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.BOMItem
     * BOMItem} entity using key fields.
     *
     * @param billOfMaterialCategory
     *            BOM category
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param billOfMaterialVersion
     *            BOM Version
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param engineeringChangeDocument
     *            Change Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param billOfMaterial
     *
     * @param technicalObject
     *            Material 1
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param billOfMaterialVariant
     *            Alternative BOM
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param billOfMaterialItemNodeNumber
     *            BOM item node number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param billOfMaterialVariantUsage
     *            BOM Usage
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.BOMItem BOMItem}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.BOMItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BOMItemByKeyFluentHelper getBOMItemByKey(
        final String billOfMaterial,
        final String billOfMaterialCategory,
        final String billOfMaterialVariant,
        final String billOfMaterialVersion,
        final String technicalObject,
        final String plant,
        final String engineeringChangeDocument,
        final String billOfMaterialVariantUsage,
        final String billOfMaterialItemNodeNumber );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.BOMItem
     * BOMItem} entity and save it to the S/4HANA system.
     *
     * @param bOMItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.BOMItem BOMItem}
     *            entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.BOMItem BOMItem}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.BOMItemCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BOMItemCreateFluentHelper createBOMItem( @Nonnull final BOMItem bOMItem );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.BOMItem
     * BOMItem} entity and save it to the S/4HANA system.
     *
     * @param bOMItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.BOMItem BOMItem}
     *            entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.BOMItem BOMItem}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.BOMItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BOMItemUpdateFluentHelper updateBOMItem( @Nonnull final BOMItem bOMItem );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.BOMItem
     * BOMItem} entity in the S/4HANA system.
     *
     * @param bOMItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.BOMItem BOMItem}
     *            entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.BOMItem BOMItem}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.BOMItemDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BOMItemDeleteFluentHelper deleteBOMItem( @Nonnull final BOMItem bOMItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader
     * MaintBOMHeader} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader
     *         MaintBOMHeader} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeaderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintBOMHeaderFluentHelper getAllMaintBOMHeader();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader
     * MaintBOMHeader} entity using key fields.
     *
     * @param billOfMaterialCategory
     *            BOM category
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param billOfMaterialVersion
     *            BOM Version
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param engineeringChangeDocument
     *            Change Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param billOfMaterial
     *
     * @param technicalObject
     *            Material 1
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param billOfMaterialVariant
     *            Alternative BOM
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param billOfMaterialVariantUsage
     *            BOM Usage
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader
     *         MaintBOMHeader} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeaderByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintBOMHeaderByKeyFluentHelper getMaintBOMHeaderByKey(
        final String billOfMaterial,
        final String billOfMaterialCategory,
        final String billOfMaterialVariant,
        final String billOfMaterialVersion,
        final String technicalObject,
        final String plant,
        final String engineeringChangeDocument,
        final String billOfMaterialVariantUsage );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader
     * MaintBOMHeader} entity and save it to the S/4HANA system.
     *
     * @param maintBOMHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader
     *            MaintBOMHeader} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader
     *         MaintBOMHeader} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeaderCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintBOMHeaderCreateFluentHelper createMaintBOMHeader( @Nonnull final MaintBOMHeader maintBOMHeader );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader
     * MaintBOMHeader} entity and save it to the S/4HANA system.
     *
     * @param maintBOMHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader
     *            MaintBOMHeader} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader
     *         MaintBOMHeader} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeaderUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintBOMHeaderUpdateFluentHelper updateMaintBOMHeader( @Nonnull final MaintBOMHeader maintBOMHeader );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader
     * MaintBOMHeader} entity in the S/4HANA system.
     *
     * @param maintBOMHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader
     *            MaintBOMHeader} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader
     *         MaintBOMHeader} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeaderDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintBOMHeaderDeleteFluentHelper deleteMaintBOMHeader( @Nonnull final MaintBOMHeader maintBOMHeader );

    /**
     * <p>
     * Creates a fluent helper for the <b>CreateVariantBOM</b> OData function import.
     * </p>
     *
     * @param billOfMaterialCategory
     *            BOM category
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialCategory</b>
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Plant</b>
     *            </p>
     * @param headerValidityStartDate
     *            Valid From
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>HeaderValidityStartDate</b>
     *            </p>
     * @param engineeringChangeDocument
     *            Change Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>EngineeringChangeDocument</b>
     *            </p>
     * @param technicalObject
     *            Technical Object
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>TechnicalObject</b>
     *            </p>
     * @param billOfMaterialVariantUsage
     *            BOM Usage
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialVariantUsage</b>
     *            </p>
     * @param referenceObjectID
     *            Owner object ID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 70
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ReferenceObjectID</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>CreateVariantBOM</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.CreateVariantBOMFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreateVariantBOMFluentHelper createVariantBOM(
        @Nonnull final String technicalObject,
        @Nonnull final String billOfMaterialVariantUsage,
        @Nonnull final String plant,
        @Nonnull final String billOfMaterialCategory,
        @Nonnull final String referenceObjectID,
        @Nullable final LocalDateTime headerValidityStartDate,
        @Nullable final String engineeringChangeDocument );

    /**
     * <p>
     * Creates a fluent helper for the <b>GetMaintBOMItems</b> OData function import.
     * </p>
     *
     * @param billOfMaterialCategory
     *            BOM category
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialCategory</b>
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Plant</b>
     *            </p>
     * @param billOfMaterialVersion
     *            BOM Version
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialVersion</b>
     *            </p>
     * @param technicalObject
     *            Technical Object
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>TechnicalObject</b>
     *            </p>
     * @param billOfMaterialVariant
     *            Alternative BOM
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialVariant</b>
     *            </p>
     * @param billOfMaterialVariantUsage
     *            BOM Usage
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialVariantUsage</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>GetMaintBOMItems</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.GetMaintBOMItemsFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GetMaintBOMItemsFluentHelper getMaintBOMItems(
        @Nonnull final String technicalObject,
        @Nonnull final String billOfMaterialVariantUsage,
        @Nonnull final String plant,
        @Nonnull final String billOfMaterialCategory,
        @Nonnull final String billOfMaterialVariant,
        @Nonnull final String billOfMaterialVersion );

}
