/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintItemObjectListItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintItemObjectListItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintItemObjectListItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintItemObjectListItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintItemObjectListItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCause;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCauseByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCauseCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCauseDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCauseFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCauseText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCauseTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCauseTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCauseTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCauseTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCauseUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReason;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenancePlanCallObjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenancePlanCallObjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.batch.MaintenanceItemServiceBatch;

/**
 * <p>
 *
 * This API allows you to read, create, and update maintenance items. The request contains all the information that is
 * necessary to read, create, and update maintenance items. If the input in the request is not as expected, the system
 * displays appropriate error or warning messages in the response. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/31/4f4099993e40d7b8ae0f90174015ea/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_MAINTENANCEITEM?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_MAINTENANCEITEM</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.3.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Maintenance Planning Integration(SAP_COM_0396)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3D2'>Service Order Management and Monitoring(3D2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4HH'>Reactive Maintenance(4HH)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4HI'>Proactive Maintenance(4HI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4VT'>Improvement Maintenance(4VT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4WM'>Operational and Overhead Maintenance(4WM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BH1'>Corrective Maintenance(BH1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BH2'>Emergency Maintenance(BH2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BJ2'>Preventive Maintenance(BJ2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OHH'>Reactive Maintenance(OHH)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OHI'>Proactive Maintenance(OHI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OJ2'>PSM: Preventive Maintenance(OJ2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OVT'>Improvement Maintenance(OVT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OWM'>Operational and Overhead Maintenance(OWM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4X5'>Recurring Services(4X5)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Maintenance Item</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface MaintenanceItemService extends BatchService<MaintenanceItemServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_MAINTENANCEITEM";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    MaintenanceItemService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem
     * MaintenanceItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem
     *         MaintenanceItem} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemFluentHelper getAllMaintenanceItem();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem
     * MaintenanceItem} entity using key fields.
     *
     * @param maintenanceItem
     *            Maintenance Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 16
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem
     *         MaintenanceItem} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemByKeyFluentHelper getMaintenanceItemByKey( final String maintenanceItem );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem
     * MaintenanceItem} entity and save it to the S/4HANA system.
     *
     * @param maintenanceItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem
     *            MaintenanceItem} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem
     *         MaintenanceItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemCreateFluentHelper createMaintenanceItem( @Nonnull final MaintenanceItem maintenanceItem );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem
     * MaintenanceItem} entity and save it to the S/4HANA system.
     *
     * @param maintenanceItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem
     *            MaintenanceItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem
     *         MaintenanceItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemUpdateFluentHelper updateMaintenanceItem( @Nonnull final MaintenanceItem maintenanceItem );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCause
     * MaintenanceItemCause} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCause
     *         MaintenanceItemCause} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCauseFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemCauseFluentHelper getAllMaintenanceItemCause();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCause
     * MaintenanceItemCause} entity using key fields.
     *
     * @param nmbrOfMaintComplianceItems
     *            Sequential Number for Compliance
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param maintenanceItem
     *            Maintenance Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 16
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCause
     *         MaintenanceItemCause} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCauseByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemCauseByKeyFluentHelper
        getMaintenanceItemCauseByKey( final String maintenanceItem, final String nmbrOfMaintComplianceItems );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCause
     * MaintenanceItemCause} entity and save it to the S/4HANA system.
     *
     * @param maintenanceItemCause
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCause
     *            MaintenanceItemCause} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCause
     *         MaintenanceItemCause} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCauseCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemCauseCreateFluentHelper
        createMaintenanceItemCause( @Nonnull final MaintenanceItemCause maintenanceItemCause );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCause
     * MaintenanceItemCause} entity and save it to the S/4HANA system.
     *
     * @param maintenanceItemCause
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCause
     *            MaintenanceItemCause} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCause
     *         MaintenanceItemCause} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCauseUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemCauseUpdateFluentHelper
        updateMaintenanceItemCause( @Nonnull final MaintenanceItemCause maintenanceItemCause );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCause
     * MaintenanceItemCause} entity in the S/4HANA system.
     *
     * @param maintenanceItemCause
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCause
     *            MaintenanceItemCause} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCause
     *         MaintenanceItemCause} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCauseDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemCauseDeleteFluentHelper
        deleteMaintenanceItemCause( @Nonnull final MaintenanceItemCause maintenanceItemCause );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCauseText
     * MaintenanceItemCauseText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCauseText
     *         MaintenanceItemCauseText} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCauseTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemCauseTextFluentHelper getAllMaintenanceItemCauseText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCauseText
     * MaintenanceItemCauseText} entity using key fields.
     *
     * @param nmbrOfMaintComplianceItems
     *            Sequential Number for Compliance
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param maintenanceItem
     *            Maintenance Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 16
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCauseText
     *         MaintenanceItemCauseText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCauseTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemCauseTextByKeyFluentHelper getMaintenanceItemCauseTextByKey(
        final String maintenanceItem,
        final String nmbrOfMaintComplianceItems,
        final String language );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCauseText
     * MaintenanceItemCauseText} entity and save it to the S/4HANA system.
     *
     * @param maintenanceItemCauseText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCauseText
     *            MaintenanceItemCauseText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCauseText
     *         MaintenanceItemCauseText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCauseTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemCauseTextUpdateFluentHelper
        updateMaintenanceItemCauseText( @Nonnull final MaintenanceItemCauseText maintenanceItemCauseText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCauseText
     * MaintenanceItemCauseText} entity in the S/4HANA system.
     *
     * @param maintenanceItemCauseText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCauseText
     *            MaintenanceItemCauseText} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCauseText
     *         MaintenanceItemCauseText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCauseTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemCauseTextDeleteFluentHelper
        deleteMaintenanceItemCauseText( @Nonnull final MaintenanceItemCauseText maintenanceItemCauseText );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReason
     * MaintenanceItemReason} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReason
     *         MaintenanceItemReason} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemReasonFluentHelper getAllMaintenanceItemReason();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReason
     * MaintenanceItemReason} entity using key fields.
     *
     * @param nmbrOfMaintComplianceItems
     *            Sequential Number for Compliance
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param maintenanceItem
     *            Maintenance Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 16
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReason
     *         MaintenanceItemReason} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemReasonByKeyFluentHelper
        getMaintenanceItemReasonByKey( final String maintenanceItem, final String nmbrOfMaintComplianceItems );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReason
     * MaintenanceItemReason} entity and save it to the S/4HANA system.
     *
     * @param maintenanceItemReason
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReason
     *            MaintenanceItemReason} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReason
     *         MaintenanceItemReason} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemReasonCreateFluentHelper
        createMaintenanceItemReason( @Nonnull final MaintenanceItemReason maintenanceItemReason );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReason
     * MaintenanceItemReason} entity and save it to the S/4HANA system.
     *
     * @param maintenanceItemReason
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReason
     *            MaintenanceItemReason} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReason
     *         MaintenanceItemReason} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemReasonUpdateFluentHelper
        updateMaintenanceItemReason( @Nonnull final MaintenanceItemReason maintenanceItemReason );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReason
     * MaintenanceItemReason} entity in the S/4HANA system.
     *
     * @param maintenanceItemReason
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReason
     *            MaintenanceItemReason} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReason
     *         MaintenanceItemReason} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemReasonDeleteFluentHelper
        deleteMaintenanceItemReason( @Nonnull final MaintenanceItemReason maintenanceItemReason );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonText
     * MaintenanceItemReasonText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonText
     *         MaintenanceItemReasonText} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemReasonTextFluentHelper getAllMaintenanceItemReasonText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonText
     * MaintenanceItemReasonText} entity using key fields.
     *
     * @param nmbrOfMaintComplianceItems
     *            Sequential Number for Compliance
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param maintenanceItem
     *            Maintenance Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 16
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonText
     *         MaintenanceItemReasonText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemReasonTextByKeyFluentHelper getMaintenanceItemReasonTextByKey(
        final String maintenanceItem,
        final String nmbrOfMaintComplianceItems,
        final String language );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonText
     * MaintenanceItemReasonText} entity and save it to the S/4HANA system.
     *
     * @param maintenanceItemReasonText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonText
     *            MaintenanceItemReasonText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonText
     *         MaintenanceItemReasonText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemReasonTextUpdateFluentHelper
        updateMaintenanceItemReasonText( @Nonnull final MaintenanceItemReasonText maintenanceItemReasonText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonText
     * MaintenanceItemReasonText} entity in the S/4HANA system.
     *
     * @param maintenanceItemReasonText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonText
     *            MaintenanceItemReasonText} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonText
     *         MaintenanceItemReasonText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemReasonTextDeleteFluentHelper
        deleteMaintenanceItemReasonText( @Nonnull final MaintenanceItemReasonText maintenanceItemReasonText );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemText
     * MaintenanceItemText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemText
     *         MaintenanceItemText} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemTextFluentHelper getAllMaintenanceItemText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemText
     * MaintenanceItemText} entity using key fields.
     *
     * @param maintenanceItem
     *            Maintenance Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 16
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemText
     *         MaintenanceItemText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemTextByKeyFluentHelper
        getMaintenanceItemTextByKey( final String maintenanceItem, final String language );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemText
     * MaintenanceItemText} entity and save it to the S/4HANA system.
     *
     * @param maintenanceItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemText
     *            MaintenanceItemText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemText
     *         MaintenanceItemText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemTextUpdateFluentHelper
        updateMaintenanceItemText( @Nonnull final MaintenanceItemText maintenanceItemText );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintItemObjectListItem
     * MaintItemObjectListItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintItemObjectListItem
     *         MaintItemObjectListItem} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintItemObjectListItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintItemObjectListItemFluentHelper getAllMaintItemObjectListItem();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintItemObjectListItem
     * MaintItemObjectListItem} entity using key fields.
     *
     * @param maintenanceItemObjectList
     *            Object list number
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param maintenanceItem
     *            Maintenance Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 16
     *            </p>
     * @param maintenanceObjectListItem
     *            Object list counters
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintItemObjectListItem
     *         MaintItemObjectListItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintItemObjectListItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintItemObjectListItemByKeyFluentHelper getMaintItemObjectListItemByKey(
        final String maintenanceItem,
        final Long maintenanceItemObjectList,
        final Integer maintenanceObjectListItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintItemObjectListItem
     * MaintItemObjectListItem} entity and save it to the S/4HANA system.
     *
     * @param maintItemObjectListItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintItemObjectListItem
     *            MaintItemObjectListItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintItemObjectListItem
     *         MaintItemObjectListItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintItemObjectListItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintItemObjectListItemUpdateFluentHelper
        updateMaintItemObjectListItem( @Nonnull final MaintItemObjectListItem maintItemObjectListItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintItemObjectListItem
     * MaintItemObjectListItem} entity in the S/4HANA system.
     *
     * @param maintItemObjectListItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintItemObjectListItem
     *            MaintItemObjectListItem} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintItemObjectListItem
     *         MaintItemObjectListItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintItemObjectListItemDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintItemObjectListItemDeleteFluentHelper
        deleteMaintItemObjectListItem( @Nonnull final MaintItemObjectListItem maintItemObjectListItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenancePlanCallObject
     * MaintenancePlanCallObject} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenancePlanCallObject
     *         MaintenancePlanCallObject} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenancePlanCallObjectFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenancePlanCallObjectFluentHelper getAllMaintenancePlanCallObject();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenancePlanCallObject
     * MaintenancePlanCallObject} entity using key fields.
     *
     * @param maintenancePlanCallNumber
     *            Maintenance Plan Call Number
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param maintenancePlan
     *            Maintenance Plan
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param maintenanceItem
     *            Maintenance Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 16
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenancePlanCallObject
     *         MaintenancePlanCallObject} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenancePlanCallObjectByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenancePlanCallObjectByKeyFluentHelper getMaintenancePlanCallObjectByKey(
        final String maintenancePlan,
        final Integer maintenancePlanCallNumber,
        final String maintenanceItem );

}
