/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.CompleteMaintNotificationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivityByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivityCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivityFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivityUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCause;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCauseByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCauseCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCauseFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCauseUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationPartnerCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.SetMaintNotifToInProcessFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.batch.MaintenanceNotificationServiceBatch;

/**
 * <p>
 *
 * This service contains maintenance notification header details, item, item cause, item activity, and partner function.
 * The information is sent in the request as a payload.
 *
 * The request payload contains all information required to create or update a maintenance notification. All the
 * information in the payload is used to create or update a maintenance notification including appropriate checks for
 * restricted values and authorizations. Once the maintenance notification has been created, the notification number is
 * sent in the response with the data included.
 *
 * If the input in the request is not as expected when you create or update a maintenance notification, the system
 * displays appropriate error or warning messages in the response..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/f4/30cbb1950c4880810e27a8308db301/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_MAINTNOTIFICATION?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_MAINTNOTIFICATION</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.3.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Maintenance Processing Integration(SAP_COM_0397)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/4HH'>Reactive Maintenance(4HH)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4HI'>Proactive Maintenance(4HI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4VT'>Improvement Maintenance(4VT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4WM'>Operational and Overhead Maintenance(4WM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BH1'>Corrective Maintenance(BH1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BH2'>Emergency Maintenance(BH2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BJ2'>Preventive Maintenance(BJ2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OHH'>Reactive Maintenance(OHH)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OHI'>Proactive Maintenance(OHI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OVT'>Improvement Maintenance(OVT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OWM'>Operational and Overhead Maintenance(OWM)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Maintenance Notification</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface MaintenanceNotificationService extends BatchService<MaintenanceNotificationServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_MAINTNOTIFICATION";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    MaintenanceNotificationService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification
     * MaintenanceNotification} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification
     *         MaintenanceNotification} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceNotificationFluentHelper getAllMaintenanceNotification();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification
     * MaintenanceNotification} entity using key fields.
     *
     * @param maintenanceNotification
     *            Notification Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification
     *         MaintenanceNotification} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceNotificationByKeyFluentHelper getMaintenanceNotificationByKey( final String maintenanceNotification );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification
     * MaintenanceNotification} entity and save it to the S/4HANA system.
     *
     * @param maintenanceNotification
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification
     *            MaintenanceNotification} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification
     *         MaintenanceNotification} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceNotificationCreateFluentHelper
        createMaintenanceNotification( @Nonnull final MaintenanceNotification maintenanceNotification );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification
     * MaintenanceNotification} entity and save it to the S/4HANA system.
     *
     * @param maintenanceNotification
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification
     *            MaintenanceNotification} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotification
     *         MaintenanceNotification} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceNotificationUpdateFluentHelper
        updateMaintenanceNotification( @Nonnull final MaintenanceNotification maintenanceNotification );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItem
     * MaintenanceNotificationItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItem
     *         MaintenanceNotificationItem} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceNotificationItemFluentHelper getAllMaintenanceNotificationItem();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItem
     * MaintenanceNotificationItem} entity using key fields.
     *
     * @param maintenanceNotificationItem
     *            Item Number in Item Record
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param maintenanceNotification
     *            Notification Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItem
     *         MaintenanceNotificationItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceNotificationItemByKeyFluentHelper getMaintenanceNotificationItemByKey(
        final String maintenanceNotification,
        final String maintenanceNotificationItem );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItem
     * MaintenanceNotificationItem} entity and save it to the S/4HANA system.
     *
     * @param maintenanceNotificationItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItem
     *            MaintenanceNotificationItem} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItem
     *         MaintenanceNotificationItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItemCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceNotificationItemCreateFluentHelper
        createMaintenanceNotificationItem( @Nonnull final MaintenanceNotificationItem maintenanceNotificationItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItem
     * MaintenanceNotificationItem} entity and save it to the S/4HANA system.
     *
     * @param maintenanceNotificationItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItem
     *            MaintenanceNotificationItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItem
     *         MaintenanceNotificationItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceNotificationItemUpdateFluentHelper
        updateMaintenanceNotificationItem( @Nonnull final MaintenanceNotificationItem maintenanceNotificationItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationPartner
     * MaintenanceNotificationPartner} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationPartner
     *         MaintenanceNotificationPartner} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationPartnerFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceNotificationPartnerFluentHelper getAllMaintenanceNotificationPartner();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationPartner
     * MaintenanceNotificationPartner} entity using key fields.
     *
     * @param partnerFunction
     *            Partner Function
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param maintenanceNotification
     *            Notification Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param notificationPartnerObjectNmbr
     *            Counter for differentiation 6-digit
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationPartner
     *         MaintenanceNotificationPartner} entity using key fields. This fluent helper allows methods which modify
     *         the underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationPartnerByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceNotificationPartnerByKeyFluentHelper getMaintenanceNotificationPartnerByKey(
        final String maintenanceNotification,
        final String partnerFunction,
        final String notificationPartnerObjectNmbr );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationPartner
     * MaintenanceNotificationPartner} entity and save it to the S/4HANA system.
     *
     * @param maintenanceNotificationPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationPartner
     *            MaintenanceNotificationPartner} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationPartner
     *         MaintenanceNotificationPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationPartnerCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceNotificationPartnerCreateFluentHelper createMaintenanceNotificationPartner(
        @Nonnull final MaintenanceNotificationPartner maintenanceNotificationPartner );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationPartner
     * MaintenanceNotificationPartner} entity and save it to the S/4HANA system.
     *
     * @param maintenanceNotificationPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationPartner
     *            MaintenanceNotificationPartner} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationPartner
     *         MaintenanceNotificationPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintenanceNotificationPartnerUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceNotificationPartnerUpdateFluentHelper updateMaintenanceNotificationPartner(
        @Nonnull final MaintenanceNotificationPartner maintenanceNotificationPartner );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivity
     * MaintNotificationItemActivity} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivity
     *         MaintNotificationItemActivity} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivityFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintNotificationItemActivityFluentHelper getAllMaintNotificationItemActivity();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivity
     * MaintNotificationItemActivity} entity using key fields.
     *
     * @param maintNotificationActivity
     *            Consecutive Number of Activity
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param maintenanceNotificationItem
     *            Item Number in Item Record
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param maintenanceNotification
     *            Notification Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivity
     *         MaintNotificationItemActivity} entity using key fields. This fluent helper allows methods which modify
     *         the underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivityByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintNotificationItemActivityByKeyFluentHelper getMaintNotificationItemActivityByKey(
        final String maintNotificationActivity,
        final String maintenanceNotification,
        final String maintenanceNotificationItem );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivity
     * MaintNotificationItemActivity} entity and save it to the S/4HANA system.
     *
     * @param maintNotificationItemActivity
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivity
     *            MaintNotificationItemActivity} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivity
     *         MaintNotificationItemActivity} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivityCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintNotificationItemActivityCreateFluentHelper createMaintNotificationItemActivity(
        @Nonnull final MaintNotificationItemActivity maintNotificationItemActivity );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivity
     * MaintNotificationItemActivity} entity and save it to the S/4HANA system.
     *
     * @param maintNotificationItemActivity
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivity
     *            MaintNotificationItemActivity} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivity
     *         MaintNotificationItemActivity} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivityUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintNotificationItemActivityUpdateFluentHelper updateMaintNotificationItemActivity(
        @Nonnull final MaintNotificationItemActivity maintNotificationItemActivity );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCause
     * MaintNotificationItemCause} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCause
     *         MaintNotificationItemCause} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCauseFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintNotificationItemCauseFluentHelper getAllMaintNotificationItemCause();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCause
     * MaintNotificationItemCause} entity using key fields.
     *
     * @param maintenanceNotificationItem
     *            Item Number in Item Record
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param maintenanceNotificationCause
     *            Sequential Number for Cause
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param maintenanceNotification
     *            Notification Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCause
     *         MaintNotificationItemCause} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCauseByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintNotificationItemCauseByKeyFluentHelper getMaintNotificationItemCauseByKey(
        final String maintenanceNotification,
        final String maintenanceNotificationItem,
        final String maintenanceNotificationCause );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCause
     * MaintNotificationItemCause} entity and save it to the S/4HANA system.
     *
     * @param maintNotificationItemCause
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCause
     *            MaintNotificationItemCause} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCause
     *         MaintNotificationItemCause} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCauseCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintNotificationItemCauseCreateFluentHelper
        createMaintNotificationItemCause( @Nonnull final MaintNotificationItemCause maintNotificationItemCause );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCause
     * MaintNotificationItemCause} entity and save it to the S/4HANA system.
     *
     * @param maintNotificationItemCause
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCause
     *            MaintNotificationItemCause} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCause
     *         MaintNotificationItemCause} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemCauseUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintNotificationItemCauseUpdateFluentHelper
        updateMaintNotificationItemCause( @Nonnull final MaintNotificationItemCause maintNotificationItemCause );

    /**
     * <p>
     * Creates a fluent helper for the <b>CompleteMaintNotification</b> OData function import.
     * </p>
     *
     * @param notificationReferenceDate
     *            Reference Date
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>NotificationReferenceDate</b>
     *            </p>
     * @param maintenanceNotification
     *            Notification
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceNotification</b>
     *            </p>
     * @param notificationReferenceTime
     *            Reference Time
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>NotificationReferenceTime</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>CompleteMaintNotification</b> OData function import with
     *         the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.CompleteMaintNotificationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CompleteMaintNotificationFluentHelper completeMaintNotification(
        @Nonnull final String maintenanceNotification,
        @Nullable final LocalDateTime notificationReferenceDate,
        @Nullable final LocalTime notificationReferenceTime );

    /**
     * <p>
     * Creates a fluent helper for the <b>CompleteMaintNotification</b> OData function import.
     * </p>
     *
     * @param notificationReferenceDate
     *            Reference Date
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>NotificationReferenceDate</b>
     *            </p>
     * @param maintenanceNotification
     *            Notification
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceNotification</b>
     *            </p>
     * @param notificationReferenceTime
     *            Reference Time
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>NotificationReferenceTime</b>
     *            </p>
     * @param maintNotifReferenceDateTime
     *            Reference Date Time
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintNotifReferenceDateTime</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>CompleteMaintNotification</b> OData function import with
     *         the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.CompleteMaintNotificationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CompleteMaintNotificationFluentHelper completeMaintNotification(
        @Nonnull final String maintenanceNotification,
        @Nullable final LocalDateTime notificationReferenceDate,
        @Nullable final LocalTime notificationReferenceTime,
        @Nullable final ZonedDateTime maintNotifReferenceDateTime );

    /**
     * <p>
     * Creates a fluent helper for the <b>SetMaintNotifToInProcess</b> OData function import.
     * </p>
     *
     * @param maintenanceNotification
     *            Notification
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceNotification</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>SetMaintNotifToInProcess</b> OData function import with
     *         the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.SetMaintNotifToInProcessFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SetMaintNotifToInProcessFluentHelper setMaintNotifToInProcess( @Nonnull final String maintenanceNotification );

}
