/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.CancelMaintOrderConfirmationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.LongText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.LongTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.LongTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.LongTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.batch.MaintenanceOrderOperationConfirmationServiceBatch;

/**
 * <p>
 *
 * This synchronous inbound service enables you to create new maintenance order confirmations and cancel confirmations
 * that are already posted. You can display and use this data, for example, in an external application. The API is based
 * on the OData V2 protocol..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/7d/6c7de7b9234747978552d4ca44466b/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_MAINTORDERCONFIRMATION?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_MAINTORDERCONFIRMATION</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Plant Maintenance Execution Integration(SAP_COM_0398)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3D2'>Service Order Management and Monitoring(3D2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3MO'>Service Contract Management(3MO)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3XK'>In-House Repair(3XK)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4HH'>Reactive Maintenance(4HH)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4HI'>Proactive Maintenance(4HI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4VT'>Improvement Maintenance(4VT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4WM'>Operational and Overhead Maintenance(4WM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BH1'>Corrective Maintenance(BH1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BH2'>Emergency Maintenance(BH2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BJ2'>Preventive Maintenance(BJ2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OHH'>Reactive Maintenance(OHH)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OHI'>Proactive Maintenance(OHI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OJ2'>PSM: Preventive Maintenance(OJ2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OVT'>Improvement Maintenance(OVT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OWM'>Operational and Overhead Maintenance(OWM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/49X'>Service Order Processing with SAP Field Service
 * Management(49X)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/4GA'>Service Quotation(4GA)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>MaintenanceOrderConfirmation</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface MaintenanceOrderOperationConfirmationService
    extends
    BatchService<MaintenanceOrderOperationConfirmationServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_MAINTORDERCONFIRMATION";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    MaintenanceOrderOperationConfirmationService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmation
     * MaintOrderConfirmation} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmation
     *         MaintOrderConfirmation} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintOrderConfirmationFluentHelper getAllMaintOrderConfirmation();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmation
     * MaintOrderConfirmation} entity using key fields.
     *
     * @param maintOrderConf
     *            Completion confirmation number for the operation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param maintOrderConfCntrValue
     *            Confirmation counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmation
     *         MaintOrderConfirmation} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmationByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintOrderConfirmationByKeyFluentHelper
        getMaintOrderConfirmationByKey( final String maintOrderConf, final String maintOrderConfCntrValue );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmation
     * MaintOrderConfirmation} entity and save it to the S/4HANA system.
     *
     * @param maintOrderConfirmation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmation
     *            MaintOrderConfirmation} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmation
     *         MaintOrderConfirmation} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmationCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintOrderConfirmationCreateFluentHelper
        createMaintOrderConfirmation( @Nonnull final MaintOrderConfirmation maintOrderConfirmation );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.LongText
     * LongText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.LongText
     *         LongText} entities. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.LongTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LongTextFluentHelper getAllLongText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.LongText
     * LongText} entity using key fields.
     *
     * @param maintOrderConf
     *            Completion confirmation number for the operation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param maintOrderConfCntrValue
     *            Confirmation counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.LongText
     *         LongText} entity using key fields. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.LongTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LongTextByKeyFluentHelper getLongTextByKey( final String maintOrderConf, final String maintOrderConfCntrValue );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.LongText
     * LongText} entity and save it to the S/4HANA system.
     *
     * @param longText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.LongText
     *            LongText} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.LongText
     *         LongText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.LongTextCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LongTextCreateFluentHelper createLongText( @Nonnull final LongText longText );

    /**
     * <p>
     * Creates a fluent helper for the <b>CancelMaintOrderConfirmation</b> OData function import.
     * </p>
     *
     * @param maintOrderConf
     *            Confirmation
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintOrderConf</b>
     *            </p>
     * @param maintOrderConfCntrValue
     *            Counter
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintOrderConfCntrValue</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>CancelMaintOrderConfirmation</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.CancelMaintOrderConfirmationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CancelMaintOrderConfirmationFluentHelper cancelMaintOrderConfirmation(
        @Nonnull final String maintOrderConf,
        @Nonnull final String maintOrderConfCntrValue );

}
