/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.ZonedDateTime;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.ActvtMaintOrderOpPhaseControlFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.ActvtMaintOrderPhaseControlFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.ApproveMaintenanceOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.AssignMaintNotificationToOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.DactvtMaintOrderOpPhaseControlFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.DactvtMaintOrderPhaseControlFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHistByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHistFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItmByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm_TypeParametersByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderObjectListItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderObjectListItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderObjectListItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderObjectListItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderObjectListItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpCompLongText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpCompLongTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpCompLongTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpCompLongTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpCompLongTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpComponent;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpComponentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpComponentCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpComponentDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpComponentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpComponentUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpLongText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpLongTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpLongTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpLongTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpLongTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpPhaseControlByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpPhaseControlFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceTool;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceToolByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceToolDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceToolFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceToolUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationshipByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationshipDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationshipFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationshipUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderSettlmtDistrRule;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderSettlmtDistrRuleByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderSettlmtDistrRuleDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderSettlmtDistrRuleFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderSettlmtDistrRuleUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrder;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderLongText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderLongTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderLongTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderLongTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderLongTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperationDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderPartnerDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintnanceOrderPhaseControlByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintnanceOrderPhaseControlFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.RejectMaintenanceOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.ReleaseMaintenanceOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.ResetMaintOrdOpsStsDispatchedFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.ResetMaintOrdStsMainWorkCmpltFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.ResetMaintOrdStsMrkdForDeltnFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.ResetMaintOrdStsTechCompletedFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.ResetMaintOrderOpStsDispatchedFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.ResetMaintOrderStatusClosedFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.ResetMaintOrderStsRdyForSchedgFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.ScheduleMaintenanceOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.SetMaintOrdStsToMrkdForDeltnFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.SetMaintOrdToMainWorkCompleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.SetMaintOrdToTechCompletedFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.SetMaintOrderOpToDispatchedFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.SetMaintOrderOpsToDispatchedFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.SetMaintOrderStatusToClosedFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.SetMaintOrderStatusToLockedFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.SetMaintOrderStatusToUnlockedFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.SetMaintOrderToDoNotExecuteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.SetMaintOrderToReadyForSchedgFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.SubmitMaintOrderForApprovalFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.batch.MaintenanceOrderServiceBatch;

/**
 * <p>
 *
 * This service enables you to create, read, updated and delete maintenance order data. It contains order header,
 * operation, component, object list item, operation relationship, long text and settlement rule nodes. The service is
 * based on the OData V2 protocol, and can be consumed in external systems, Fiori applications and on other user
 * interfaces.
 *
 * If there are any issues when retrieving the maintenance order data, the system displays appropriate warning or error
 * messages in the response..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/d3/f02cfccf00407ab9776ea2ec2030d3/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_MAINTENANCEORDER?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_MAINTENANCEORDER</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.2.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Maintenance Processing Integration(SAP_COM_0397)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/4HH'>Reactive Maintenance(4HH)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4HI'>Proactive Maintenance(4HI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4VT'>Improvement Maintenance(4VT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4WM'>Operational and Overhead Maintenance(4WM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BH1'>Corrective Maintenance(BH1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BH2'>Emergency Maintenance(BH2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BJ2'>Preventive Maintenance(BJ2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OHH'>Reactive Maintenance(OHH)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OHI'>Proactive Maintenance(OHI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OVT'>Improvement Maintenance(OVT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OWM'>Operational and Overhead Maintenance(OWM)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Maintenance Order</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface MaintenanceOrderService extends BatchService<MaintenanceOrderServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_MAINTENANCEORDER";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    MaintenanceOrderService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrder
     * MaintenanceOrder} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrder
     *         MaintenanceOrder} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceOrderFluentHelper getAllMaintenanceOrder();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrder
     * MaintenanceOrder} entity using key fields.
     *
     * @param maintenanceOrder
     *            Order Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrder
     *         MaintenanceOrder} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceOrderByKeyFluentHelper getMaintenanceOrderByKey( final String maintenanceOrder );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrder
     * MaintenanceOrder} entity and save it to the S/4HANA system.
     *
     * @param maintenanceOrder
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrder
     *            MaintenanceOrder} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrder
     *         MaintenanceOrder} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceOrderCreateFluentHelper createMaintenanceOrder( @Nonnull final MaintenanceOrder maintenanceOrder );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrder
     * MaintenanceOrder} entity and save it to the S/4HANA system.
     *
     * @param maintenanceOrder
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrder
     *            MaintenanceOrder} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrder
     *         MaintenanceOrder} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceOrderUpdateFluentHelper updateMaintenanceOrder( @Nonnull final MaintenanceOrder maintenanceOrder );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderLongText
     * MaintenanceOrderLongText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderLongText
     *         MaintenanceOrderLongText} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderLongTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceOrderLongTextFluentHelper getAllMaintenanceOrderLongText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderLongText
     * MaintenanceOrderLongText} entity using key fields.
     *
     * @param maintenanceOrder
     *            Order Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param textObjectType
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderLongText
     *         MaintenanceOrderLongText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderLongTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceOrderLongTextByKeyFluentHelper getMaintenanceOrderLongTextByKey(
        final String maintenanceOrder,
        final String textObjectType,
        final String language );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderLongText
     * MaintenanceOrderLongText} entity and save it to the S/4HANA system.
     *
     * @param maintenanceOrderLongText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderLongText
     *            MaintenanceOrderLongText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderLongText
     *         MaintenanceOrderLongText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderLongTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceOrderLongTextUpdateFluentHelper
        updateMaintenanceOrderLongText( @Nonnull final MaintenanceOrderLongText maintenanceOrderLongText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderLongText
     * MaintenanceOrderLongText} entity in the S/4HANA system.
     *
     * @param maintenanceOrderLongText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderLongText
     *            MaintenanceOrderLongText} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderLongText
     *         MaintenanceOrderLongText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderLongTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceOrderLongTextDeleteFluentHelper
        deleteMaintenanceOrderLongText( @Nonnull final MaintenanceOrderLongText maintenanceOrderLongText );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation
     * MaintenanceOrderOperation} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation
     *         MaintenanceOrderOperation} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceOrderOperationFluentHelper getAllMaintenanceOrderOperation();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation
     * MaintenanceOrderOperation} entity using key fields.
     *
     * @param maintenanceOrder
     *            Order Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param maintenanceOrderOperation
     *            Maintenance Order Operation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param maintenanceOrderSubOperation
     *            Maintenance Order Suboperation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation
     *         MaintenanceOrderOperation} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperationByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceOrderOperationByKeyFluentHelper getMaintenanceOrderOperationByKey(
        final String maintenanceOrder,
        final String maintenanceOrderOperation,
        final String maintenanceOrderSubOperation );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation
     * MaintenanceOrderOperation} entity and save it to the S/4HANA system.
     *
     * @param maintenanceOrderOperation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation
     *            MaintenanceOrderOperation} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation
     *         MaintenanceOrderOperation} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperationCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceOrderOperationCreateFluentHelper
        createMaintenanceOrderOperation( @Nonnull final MaintenanceOrderOperation maintenanceOrderOperation );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation
     * MaintenanceOrderOperation} entity and save it to the S/4HANA system.
     *
     * @param maintenanceOrderOperation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation
     *            MaintenanceOrderOperation} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation
     *         MaintenanceOrderOperation} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperationUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceOrderOperationUpdateFluentHelper
        updateMaintenanceOrderOperation( @Nonnull final MaintenanceOrderOperation maintenanceOrderOperation );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation
     * MaintenanceOrderOperation} entity in the S/4HANA system.
     *
     * @param maintenanceOrderOperation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation
     *            MaintenanceOrderOperation} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperation
     *         MaintenanceOrderOperation} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderOperationDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceOrderOperationDeleteFluentHelper
        deleteMaintenanceOrderOperation( @Nonnull final MaintenanceOrderOperation maintenanceOrderOperation );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderPartner
     * MaintenanceOrderPartner} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderPartner
     *         MaintenanceOrderPartner} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderPartnerFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceOrderPartnerFluentHelper getAllMaintenanceOrderPartner();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderPartner
     * MaintenanceOrderPartner} entity using key fields.
     *
     * @param maintenanceOrder
     *            Order Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param partnerFunction
     *            Partner Function
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param maintenanceOrderPartner
     *            Partner
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderPartner
     *         MaintenanceOrderPartner} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderPartnerByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceOrderPartnerByKeyFluentHelper getMaintenanceOrderPartnerByKey(
        final String maintenanceOrder,
        final String partnerFunction,
        final String maintenanceOrderPartner );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderPartner
     * MaintenanceOrderPartner} entity in the S/4HANA system.
     *
     * @param maintenanceOrderPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderPartner
     *            MaintenanceOrderPartner} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderPartner
     *         MaintenanceOrderPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintenanceOrderPartnerDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceOrderPartnerDeleteFluentHelper
        deleteMaintenanceOrderPartner( @Nonnull final MaintenanceOrderPartner maintenanceOrderPartner );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintnanceOrderPhaseControl
     * MaintnanceOrderPhaseControl} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintnanceOrderPhaseControl
     *         MaintnanceOrderPhaseControl} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintnanceOrderPhaseControlFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintnanceOrderPhaseControlFluentHelper getAllMaintnanceOrderPhaseControl();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintnanceOrderPhaseControl
     * MaintnanceOrderPhaseControl} entity using key fields.
     *
     * @param maintenanceOrder
     *            Order Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param maintenancePhaseControl
     *            Phase Control Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintnanceOrderPhaseControl
     *         MaintnanceOrderPhaseControl} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintnanceOrderPhaseControlByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintnanceOrderPhaseControlByKeyFluentHelper
        getMaintnanceOrderPhaseControlByKey( final String maintenanceOrder, final String maintenancePhaseControl );

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm
     * MaintOrderActlPlndCostItm} entity using key fields.
     *
     * @param ledger
     *            Ledger in General Ledger Accounting
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param companyCode
     *            Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param financialPlanningReqTransSqnc
     *            Financial Planning Request Transaction Sequence Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 23
     *            </p>
     * @param actualPlanJournalEntryItem
     *            Actual Plan Journal Entry Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param financialPlanningDataPacket
     *            Financial Planning Data Packet Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param accountingDocument
     *            Journal Entry
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param p_GLAccountHierarchy
     *            Hierarchy ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 42
     *            </p>
     * @param sourceLedger
     *            Source Ledger
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param fiscalYear
     *            Fiscal Year
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm
     *         MaintOrderActlPlndCostItm} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItmByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintOrderActlPlndCostItmByKeyFluentHelper getMaintOrderActlPlndCostItmByKey(
        final String p_GLAccountHierarchy,
        final String sourceLedger,
        final String ledger,
        final String companyCode,
        final String fiscalYear,
        final String accountingDocument,
        final String financialPlanningReqTransSqnc,
        final String financialPlanningDataPacket,
        final String actualPlanJournalEntryItem );

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm_TypeParameters
     * MaintOrderActlPlndCostItm_TypeParameters} entity using key fields.
     *
     * @param p_GLAccountHierarchy
     *            Hierarchy ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 42
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm_TypeParameters
     *         MaintOrderActlPlndCostItm_TypeParameters} entity using key fields. This fluent helper allows methods
     *         which modify the underlying query to be called before executing the query itself. To perform execution,
     *         call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderActlPlndCostItm_TypeParametersByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintOrderActlPlndCostItm_TypeParametersByKeyFluentHelper
        getMaintOrderActlPlndCostItm_TypeParametersByKey( final String p_GLAccountHierarchy );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderObjectListItem
     * MaintOrderObjectListItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderObjectListItem
     *         MaintOrderObjectListItem} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderObjectListItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintOrderObjectListItemFluentHelper getAllMaintOrderObjectListItem();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderObjectListItem
     * MaintOrderObjectListItem} entity using key fields.
     *
     * @param maintenanceOrder
     *            Order Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param maintenanceOrderObjectList
     *            Object list number
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param maintenanceObjectListItem
     *            Object list counters
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderObjectListItem
     *         MaintOrderObjectListItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderObjectListItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintOrderObjectListItemByKeyFluentHelper getMaintOrderObjectListItemByKey(
        final String maintenanceOrder,
        final Long maintenanceOrderObjectList,
        final Integer maintenanceObjectListItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderObjectListItem
     * MaintOrderObjectListItem} entity and save it to the S/4HANA system.
     *
     * @param maintOrderObjectListItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderObjectListItem
     *            MaintOrderObjectListItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderObjectListItem
     *         MaintOrderObjectListItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderObjectListItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintOrderObjectListItemUpdateFluentHelper
        updateMaintOrderObjectListItem( @Nonnull final MaintOrderObjectListItem maintOrderObjectListItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderObjectListItem
     * MaintOrderObjectListItem} entity in the S/4HANA system.
     *
     * @param maintOrderObjectListItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderObjectListItem
     *            MaintOrderObjectListItem} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderObjectListItem
     *         MaintOrderObjectListItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderObjectListItemDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintOrderObjectListItemDeleteFluentHelper
        deleteMaintOrderObjectListItem( @Nonnull final MaintOrderObjectListItem maintOrderObjectListItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpCompLongText
     * MaintOrderOpCompLongText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpCompLongText
     *         MaintOrderOpCompLongText} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpCompLongTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintOrderOpCompLongTextFluentHelper getAllMaintOrderOpCompLongText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpCompLongText
     * MaintOrderOpCompLongText} entity using key fields.
     *
     * @param maintenanceOrder
     *            Order Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param maintenanceOrderOperation
     *            Maintenance Order Suboperation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param maintenanceOrderSubOperation
     *            Maintenance Order Suboperation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param maintenanceOrderComponent
     *            BOM item number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param textObjectType
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpCompLongText
     *         MaintOrderOpCompLongText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpCompLongTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintOrderOpCompLongTextByKeyFluentHelper getMaintOrderOpCompLongTextByKey(
        final String maintenanceOrder,
        final String maintenanceOrderOperation,
        final String maintenanceOrderSubOperation,
        final String maintenanceOrderComponent,
        final String textObjectType,
        final String language );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpCompLongText
     * MaintOrderOpCompLongText} entity and save it to the S/4HANA system.
     *
     * @param maintOrderOpCompLongText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpCompLongText
     *            MaintOrderOpCompLongText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpCompLongText
     *         MaintOrderOpCompLongText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpCompLongTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintOrderOpCompLongTextUpdateFluentHelper
        updateMaintOrderOpCompLongText( @Nonnull final MaintOrderOpCompLongText maintOrderOpCompLongText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpCompLongText
     * MaintOrderOpCompLongText} entity in the S/4HANA system.
     *
     * @param maintOrderOpCompLongText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpCompLongText
     *            MaintOrderOpCompLongText} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpCompLongText
     *         MaintOrderOpCompLongText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpCompLongTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintOrderOpCompLongTextDeleteFluentHelper
        deleteMaintOrderOpCompLongText( @Nonnull final MaintOrderOpCompLongText maintOrderOpCompLongText );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpComponent
     * MaintOrderOpComponent} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpComponent
     *         MaintOrderOpComponent} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpComponentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintOrderOpComponentFluentHelper getAllMaintOrderOpComponent();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpComponent
     * MaintOrderOpComponent} entity using key fields.
     *
     * @param maintenanceOrder
     *            Order Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param maintenanceOrderOperation
     *            Maintenance Order Operation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param maintenanceOrderSubOperation
     *            Maintenance Order Suboperation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param maintenanceOrderComponent
     *            BOM item number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpComponent
     *         MaintOrderOpComponent} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpComponentByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintOrderOpComponentByKeyFluentHelper getMaintOrderOpComponentByKey(
        final String maintenanceOrder,
        final String maintenanceOrderOperation,
        final String maintenanceOrderSubOperation,
        final String maintenanceOrderComponent );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpComponent
     * MaintOrderOpComponent} entity and save it to the S/4HANA system.
     *
     * @param maintOrderOpComponent
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpComponent
     *            MaintOrderOpComponent} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpComponent
     *         MaintOrderOpComponent} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpComponentCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintOrderOpComponentCreateFluentHelper
        createMaintOrderOpComponent( @Nonnull final MaintOrderOpComponent maintOrderOpComponent );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpComponent
     * MaintOrderOpComponent} entity and save it to the S/4HANA system.
     *
     * @param maintOrderOpComponent
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpComponent
     *            MaintOrderOpComponent} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpComponent
     *         MaintOrderOpComponent} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpComponentUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintOrderOpComponentUpdateFluentHelper
        updateMaintOrderOpComponent( @Nonnull final MaintOrderOpComponent maintOrderOpComponent );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpComponent
     * MaintOrderOpComponent} entity in the S/4HANA system.
     *
     * @param maintOrderOpComponent
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpComponent
     *            MaintOrderOpComponent} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpComponent
     *         MaintOrderOpComponent} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpComponentDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintOrderOpComponentDeleteFluentHelper
        deleteMaintOrderOpComponent( @Nonnull final MaintOrderOpComponent maintOrderOpComponent );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpLongText
     * MaintOrderOpLongText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpLongText
     *         MaintOrderOpLongText} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpLongTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintOrderOpLongTextFluentHelper getAllMaintOrderOpLongText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpLongText
     * MaintOrderOpLongText} entity using key fields.
     *
     * @param maintenanceOrder
     *            Order Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param maintenanceOrderOperation
     *            Maintenance Order Operation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param maintenanceOrderSubOperation
     *            Maintenance Order Suboperation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param textObjectType
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpLongText
     *         MaintOrderOpLongText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpLongTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintOrderOpLongTextByKeyFluentHelper getMaintOrderOpLongTextByKey(
        final String maintenanceOrder,
        final String maintenanceOrderOperation,
        final String maintenanceOrderSubOperation,
        final String textObjectType,
        final String language );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpLongText
     * MaintOrderOpLongText} entity and save it to the S/4HANA system.
     *
     * @param maintOrderOpLongText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpLongText
     *            MaintOrderOpLongText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpLongText
     *         MaintOrderOpLongText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpLongTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintOrderOpLongTextUpdateFluentHelper
        updateMaintOrderOpLongText( @Nonnull final MaintOrderOpLongText maintOrderOpLongText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpLongText
     * MaintOrderOpLongText} entity in the S/4HANA system.
     *
     * @param maintOrderOpLongText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpLongText
     *            MaintOrderOpLongText} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpLongText
     *         MaintOrderOpLongText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpLongTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintOrderOpLongTextDeleteFluentHelper
        deleteMaintOrderOpLongText( @Nonnull final MaintOrderOpLongText maintOrderOpLongText );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpPhaseControl
     * MaintOrderOpPhaseControl} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpPhaseControl
     *         MaintOrderOpPhaseControl} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpPhaseControlFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintOrderOpPhaseControlFluentHelper getAllMaintOrderOpPhaseControl();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpPhaseControl
     * MaintOrderOpPhaseControl} entity using key fields.
     *
     * @param maintenanceOrder
     *            Order Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param maintenanceOrderOperation
     *
     * @param maintenanceOrderSubOperation
     *            Maintenance Order Suboperation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param maintenancePhaseControl
     *            Phase Control Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpPhaseControl
     *         MaintOrderOpPhaseControl} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpPhaseControlByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintOrderOpPhaseControlByKeyFluentHelper getMaintOrderOpPhaseControlByKey(
        final String maintenanceOrder,
        final String maintenanceOrderOperation,
        final String maintenanceOrderSubOperation,
        final String maintenancePhaseControl );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceTool
     * MaintOrderOpProdnRsceTool} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceTool
     *         MaintOrderOpProdnRsceTool} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceToolFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintOrderOpProdnRsceToolFluentHelper getAllMaintOrderOpProdnRsceTool();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceTool
     * MaintOrderOpProdnRsceTool} entity using key fields.
     *
     * @param maintenanceOrder
     *            Order Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param maintenanceOrderOperation
     *            Maintenance Order Operation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param maintenanceOrderSubOperation
     *            Maintenance Order Suboperation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param prodnRsceToolItemNumber
     *            Item Number for Production Resource/Tool
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceTool
     *         MaintOrderOpProdnRsceTool} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceToolByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintOrderOpProdnRsceToolByKeyFluentHelper getMaintOrderOpProdnRsceToolByKey(
        final String maintenanceOrder,
        final String maintenanceOrderOperation,
        final String maintenanceOrderSubOperation,
        final String prodnRsceToolItemNumber );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceTool
     * MaintOrderOpProdnRsceTool} entity and save it to the S/4HANA system.
     *
     * @param maintOrderOpProdnRsceTool
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceTool
     *            MaintOrderOpProdnRsceTool} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceTool
     *         MaintOrderOpProdnRsceTool} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceToolUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintOrderOpProdnRsceToolUpdateFluentHelper
        updateMaintOrderOpProdnRsceTool( @Nonnull final MaintOrderOpProdnRsceTool maintOrderOpProdnRsceTool );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceTool
     * MaintOrderOpProdnRsceTool} entity in the S/4HANA system.
     *
     * @param maintOrderOpProdnRsceTool
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceTool
     *            MaintOrderOpProdnRsceTool} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceTool
     *         MaintOrderOpProdnRsceTool} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpProdnRsceToolDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintOrderOpProdnRsceToolDeleteFluentHelper
        deleteMaintOrderOpProdnRsceTool( @Nonnull final MaintOrderOpProdnRsceTool maintOrderOpProdnRsceTool );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship
     * MaintOrderOpRelationship} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship
     *         MaintOrderOpRelationship} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationshipFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintOrderOpRelationshipFluentHelper getAllMaintOrderOpRelationship();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship
     * MaintOrderOpRelationship} entity using key fields.
     *
     * @param maintenanceOrder
     *            Order Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param maintenanceOrderOperation
     *            Maintenance Order Operation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param relatedMaintOrderOperation
     *            Maintenance Order Operation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param orderOpRelationshipIntType
     *            Type of relationship
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param maintenanceOrderSubOperation
     *            Maintenance Order Suboperation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param relatedMaintenanceOrder
     *            Order Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param maintOrdOperationIsSuccessor
     *            Indicator: Activity is successor to selected activity
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship
     *         MaintOrderOpRelationship} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationshipByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintOrderOpRelationshipByKeyFluentHelper getMaintOrderOpRelationshipByKey(
        final String maintenanceOrder,
        final String maintenanceOrderOperation,
        final String maintenanceOrderSubOperation,
        final Boolean maintOrdOperationIsSuccessor,
        final String relatedMaintenanceOrder,
        final String relatedMaintOrderOperation,
        final String orderOpRelationshipIntType );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship
     * MaintOrderOpRelationship} entity and save it to the S/4HANA system.
     *
     * @param maintOrderOpRelationship
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship
     *            MaintOrderOpRelationship} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship
     *         MaintOrderOpRelationship} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationshipUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintOrderOpRelationshipUpdateFluentHelper
        updateMaintOrderOpRelationship( @Nonnull final MaintOrderOpRelationship maintOrderOpRelationship );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship
     * MaintOrderOpRelationship} entity in the S/4HANA system.
     *
     * @param maintOrderOpRelationship
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship
     *            MaintOrderOpRelationship} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationship
     *         MaintOrderOpRelationship} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderOpRelationshipDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintOrderOpRelationshipDeleteFluentHelper
        deleteMaintOrderOpRelationship( @Nonnull final MaintOrderOpRelationship maintOrderOpRelationship );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderSettlmtDistrRule
     * MaintOrderSettlmtDistrRule} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderSettlmtDistrRule
     *         MaintOrderSettlmtDistrRule} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderSettlmtDistrRuleFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintOrderSettlmtDistrRuleFluentHelper getAllMaintOrderSettlmtDistrRule();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderSettlmtDistrRule
     * MaintOrderSettlmtDistrRule} entity using key fields.
     *
     * @param maintenanceOrder
     *            Order Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param settlmtDistrRuleSequence
     *            Sequence Number of Distribution Rule
     *            <p>
     *            Constraints: Not nullable, Maximum length: 7
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderSettlmtDistrRule
     *         MaintOrderSettlmtDistrRule} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderSettlmtDistrRuleByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintOrderSettlmtDistrRuleByKeyFluentHelper
        getMaintOrderSettlmtDistrRuleByKey( final String maintenanceOrder, final String settlmtDistrRuleSequence );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderSettlmtDistrRule
     * MaintOrderSettlmtDistrRule} entity and save it to the S/4HANA system.
     *
     * @param maintOrderSettlmtDistrRule
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderSettlmtDistrRule
     *            MaintOrderSettlmtDistrRule} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderSettlmtDistrRule
     *         MaintOrderSettlmtDistrRule} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderSettlmtDistrRuleUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintOrderSettlmtDistrRuleUpdateFluentHelper
        updateMaintOrderSettlmtDistrRule( @Nonnull final MaintOrderSettlmtDistrRule maintOrderSettlmtDistrRule );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderSettlmtDistrRule
     * MaintOrderSettlmtDistrRule} entity in the S/4HANA system.
     *
     * @param maintOrderSettlmtDistrRule
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderSettlmtDistrRule
     *            MaintOrderSettlmtDistrRule} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderSettlmtDistrRule
     *         MaintOrderSettlmtDistrRule} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrderSettlmtDistrRuleDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintOrderSettlmtDistrRuleDeleteFluentHelper
        deleteMaintOrderSettlmtDistrRule( @Nonnull final MaintOrderSettlmtDistrRule maintOrderSettlmtDistrRule );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHist
     * MaintOrdSettlmtDistrRuleHist} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHist
     *         MaintOrdSettlmtDistrRuleHist} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHistFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintOrdSettlmtDistrRuleHistFluentHelper getAllMaintOrdSettlmtDistrRuleHist();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHist
     * MaintOrdSettlmtDistrRuleHist} entity using key fields.
     *
     * @param maintenanceOrder
     *            Order Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param ledger
     *            Ledger in General Ledger Accounting
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param settlmtDistrRuleSequence
     *            Sequence Number of Distribution Rule
     *            <p>
     *            Constraints: Not nullable, Maximum length: 7
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHist
     *         MaintOrdSettlmtDistrRuleHist} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintOrdSettlmtDistrRuleHistByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintOrdSettlmtDistrRuleHistByKeyFluentHelper getMaintOrdSettlmtDistrRuleHistByKey(
        final String maintenanceOrder,
        final String settlmtDistrRuleSequence,
        final String ledger );

    /**
     * <p>
     * Creates a fluent helper for the <b>ApproveMaintenanceOrder</b> OData function import.
     * </p>
     *
     * @param maintenanceOrder
     *            Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ApproveMaintenanceOrder</b> OData function import with
     *         the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.ApproveMaintenanceOrderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ApproveMaintenanceOrderFluentHelper approveMaintenanceOrder( @Nonnull final String maintenanceOrder );

    /**
     * <p>
     * Creates a fluent helper for the <b>AssignMaintNotificationToOrder</b> OData function import.
     * </p>
     *
     * @param maintenanceOrder
     *            Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceOrder</b>
     *            </p>
     * @param maintenanceNotification
     *            Notification
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceNotification</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>AssignMaintNotificationToOrder</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.AssignMaintNotificationToOrderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AssignMaintNotificationToOrderFluentHelper assignMaintNotificationToOrder(
        @Nonnull final String maintenanceOrder,
        @Nullable final String maintenanceNotification );

    /**
     * <p>
     * Creates a fluent helper for the <b>AssignMaintNotificationToOrder</b> OData function import.
     * </p>
     *
     * @param maintenanceOrder
     *            Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceOrder</b>
     *            </p>
     * @param maintenanceNotification
     *            Notification
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceNotification</b>
     *            </p>
     * @param notificationIsHeaderNotif
     *            Header Notif.
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>NotificationIsHeaderNotif</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>AssignMaintNotificationToOrder</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.AssignMaintNotificationToOrderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AssignMaintNotificationToOrderFluentHelper assignMaintNotificationToOrder(
        @Nonnull final String maintenanceOrder,
        @Nullable final String maintenanceNotification,
        @Nullable final Boolean notificationIsHeaderNotif );

    /**
     * <p>
     * Creates a fluent helper for the <b>RejectMaintenanceOrder</b> OData function import.
     * </p>
     *
     * @param maintenanceOrder
     *            Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>RejectMaintenanceOrder</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.RejectMaintenanceOrderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RejectMaintenanceOrderFluentHelper rejectMaintenanceOrder( @Nonnull final String maintenanceOrder );

    /**
     * <p>
     * Creates a fluent helper for the <b>ReleaseMaintenanceOrder</b> OData function import.
     * </p>
     *
     * @param maintenanceOrder
     *            Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ReleaseMaintenanceOrder</b> OData function import with
     *         the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.ReleaseMaintenanceOrderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ReleaseMaintenanceOrderFluentHelper releaseMaintenanceOrder( @Nonnull final String maintenanceOrder );

    /**
     * <p>
     * Creates a fluent helper for the <b>ResetMaintOrderStatusClosed</b> OData function import.
     * </p>
     *
     * @param maintenanceOrder
     *            Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ResetMaintOrderStatusClosed</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.ResetMaintOrderStatusClosedFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ResetMaintOrderStatusClosedFluentHelper resetMaintOrderStatusClosed( @Nonnull final String maintenanceOrder );

    /**
     * <p>
     * Creates a fluent helper for the <b>ResetMaintOrderStsRdyForSchedg</b> OData function import.
     * </p>
     *
     * @param maintenanceOrder
     *            Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ResetMaintOrderStsRdyForSchedg</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.ResetMaintOrderStsRdyForSchedgFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ResetMaintOrderStsRdyForSchedgFluentHelper resetMaintOrderStsRdyForSchedg( @Nonnull final String maintenanceOrder );

    /**
     * <p>
     * Creates a fluent helper for the <b>ResetMaintOrdOpsStsDispatched</b> OData function import.
     * </p>
     *
     * @param maintenanceOrder
     *            Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ResetMaintOrdOpsStsDispatched</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.ResetMaintOrdOpsStsDispatchedFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ResetMaintOrdOpsStsDispatchedFluentHelper resetMaintOrdOpsStsDispatched( @Nonnull final String maintenanceOrder );

    /**
     * <p>
     * Creates a fluent helper for the <b>ResetMaintOrdStsMainWorkCmplt</b> OData function import.
     * </p>
     *
     * @param maintenanceOrder
     *            Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ResetMaintOrdStsMainWorkCmplt</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.ResetMaintOrdStsMainWorkCmpltFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ResetMaintOrdStsMainWorkCmpltFluentHelper resetMaintOrdStsMainWorkCmplt( @Nonnull final String maintenanceOrder );

    /**
     * <p>
     * Creates a fluent helper for the <b>ResetMaintOrdStsMrkdForDeltn</b> OData function import.
     * </p>
     *
     * @param maintenanceOrder
     *            Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceOrder</b>
     *            </p>
     * @param assgdMaintNotifIsToBeResetDel
     *            Also reset the deletion flag for the assigned notifications
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>AssgdMaintNotifIsToBeResetDel</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ResetMaintOrdStsMrkdForDeltn</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.ResetMaintOrdStsMrkdForDeltnFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ResetMaintOrdStsMrkdForDeltnFluentHelper resetMaintOrdStsMrkdForDeltn(
        @Nonnull final String maintenanceOrder,
        @Nullable final Boolean assgdMaintNotifIsToBeResetDel );

    /**
     * <p>
     * Creates a fluent helper for the <b>ResetMaintOrdStsTechCompleted</b> OData function import.
     * </p>
     *
     * @param maintenanceOrder
     *            Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceOrder</b>
     *            </p>
     * @param assgdMaintNotifIsToBePutInProc
     *            Put Assigned Notifications In Process Again
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>AssgdMaintNotifIsToBePutInProc</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ResetMaintOrdStsTechCompleted</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.ResetMaintOrdStsTechCompletedFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ResetMaintOrdStsTechCompletedFluentHelper resetMaintOrdStsTechCompleted(
        @Nonnull final String maintenanceOrder,
        @Nullable final Boolean assgdMaintNotifIsToBePutInProc );

    /**
     * <p>
     * Creates a fluent helper for the <b>ScheduleMaintenanceOrder</b> OData function import.
     * </p>
     *
     * @param maintenanceOrder
     *            Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ScheduleMaintenanceOrder</b> OData function import with
     *         the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.ScheduleMaintenanceOrderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ScheduleMaintenanceOrderFluentHelper scheduleMaintenanceOrder( @Nonnull final String maintenanceOrder );

    /**
     * <p>
     * Creates a fluent helper for the <b>SetMaintOrderOpsToDispatched</b> OData function import.
     * </p>
     *
     * @param maintenanceOrder
     *            Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>SetMaintOrderOpsToDispatched</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.SetMaintOrderOpsToDispatchedFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SetMaintOrderOpsToDispatchedFluentHelper setMaintOrderOpsToDispatched( @Nonnull final String maintenanceOrder );

    /**
     * <p>
     * Creates a fluent helper for the <b>SetMaintOrderStatusToClosed</b> OData function import.
     * </p>
     *
     * @param maintenanceOrder
     *            Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceOrder</b>
     *            </p>
     * @param assignedMaintNotifIsToBeClosed
     *            Complete Assigned Notifications
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>AssignedMaintNotifIsToBeClosed</b>
     *            </p>
     * @param maintOrderReferenceDateTime
     *            Completion Date/Time
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintOrderReferenceDateTime</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>SetMaintOrderStatusToClosed</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.SetMaintOrderStatusToClosedFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SetMaintOrderStatusToClosedFluentHelper setMaintOrderStatusToClosed(
        @Nonnull final String maintenanceOrder,
        @Nullable final ZonedDateTime maintOrderReferenceDateTime,
        @Nullable final Boolean assignedMaintNotifIsToBeClosed );

    /**
     * <p>
     * Creates a fluent helper for the <b>SetMaintOrderStatusToLocked</b> OData function import.
     * </p>
     *
     * @param maintenanceOrder
     *            Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>SetMaintOrderStatusToLocked</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.SetMaintOrderStatusToLockedFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SetMaintOrderStatusToLockedFluentHelper setMaintOrderStatusToLocked( @Nonnull final String maintenanceOrder );

    /**
     * <p>
     * Creates a fluent helper for the <b>SetMaintOrderStatusToUnlocked</b> OData function import.
     * </p>
     *
     * @param maintenanceOrder
     *            Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>SetMaintOrderStatusToUnlocked</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.SetMaintOrderStatusToUnlockedFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SetMaintOrderStatusToUnlockedFluentHelper setMaintOrderStatusToUnlocked( @Nonnull final String maintenanceOrder );

    /**
     * <p>
     * Creates a fluent helper for the <b>SetMaintOrderToDoNotExecute</b> OData function import.
     * </p>
     *
     * @param maintenanceOrder
     *            Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceOrder</b>
     *            </p>
     * @param assignedMaintNotifIsToBeClosed
     *            Complete All Assigned Notifications
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>AssignedMaintNotifIsToBeClosed</b>
     *            </p>
     * @param assgdMaintNotifIsToBeRsetAlloc
     *            Complete Header Notification and Unassign Others
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>AssgdMaintNotifIsToBeRsetAlloc</b>
     *            </p>
     * @param maintOrderReferenceDateTime
     *            Reference Date/Time
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintOrderReferenceDateTime</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>SetMaintOrderToDoNotExecute</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.SetMaintOrderToDoNotExecuteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SetMaintOrderToDoNotExecuteFluentHelper setMaintOrderToDoNotExecute(
        @Nonnull final String maintenanceOrder,
        @Nullable final ZonedDateTime maintOrderReferenceDateTime,
        @Nullable final Boolean assignedMaintNotifIsToBeClosed,
        @Nullable final Boolean assgdMaintNotifIsToBeRsetAlloc );

    /**
     * <p>
     * Creates a fluent helper for the <b>SetMaintOrderToDoNotExecute</b> OData function import.
     * </p>
     *
     * @param maintenanceOrder
     *            Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceOrder</b>
     *            </p>
     * @param assignedMaintNotifIsToBeClosed
     *            Complete All Assigned Notifications
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>AssignedMaintNotifIsToBeClosed</b>
     *            </p>
     * @param maintOrdCancellationAction
     *            What should happen to assigned notifications
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintOrdCancellationAction</b>
     *            </p>
     * @param assgdMaintNotifIsToBeRsetAlloc
     *            Complete Header Notification and Unassign Others
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>AssgdMaintNotifIsToBeRsetAlloc</b>
     *            </p>
     * @param maintOrderReferenceDateTime
     *            Reference Date/Time
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintOrderReferenceDateTime</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>SetMaintOrderToDoNotExecute</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.SetMaintOrderToDoNotExecuteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SetMaintOrderToDoNotExecuteFluentHelper setMaintOrderToDoNotExecute(
        @Nonnull final String maintenanceOrder,
        @Nullable final ZonedDateTime maintOrderReferenceDateTime,
        @Nullable final Boolean assignedMaintNotifIsToBeClosed,
        @Nullable final Boolean assgdMaintNotifIsToBeRsetAlloc,
        @Nullable final String maintOrdCancellationAction );

    /**
     * <p>
     * Creates a fluent helper for the <b>SetMaintOrderToReadyForSchedg</b> OData function import.
     * </p>
     *
     * @param maintenanceOrder
     *            Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>SetMaintOrderToReadyForSchedg</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.SetMaintOrderToReadyForSchedgFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SetMaintOrderToReadyForSchedgFluentHelper setMaintOrderToReadyForSchedg( @Nonnull final String maintenanceOrder );

    /**
     * <p>
     * Creates a fluent helper for the <b>SetMaintOrdStsToMrkdForDeltn</b> OData function import.
     * </p>
     *
     * @param maintenanceOrder
     *            Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceOrder</b>
     *            </p>
     * @param assgdMaintNotifIsToBeSetDel
     *            Also set the deletion flag for the assigned notifications
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>AssgdMaintNotifIsToBeSetDel</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>SetMaintOrdStsToMrkdForDeltn</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.SetMaintOrdStsToMrkdForDeltnFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SetMaintOrdStsToMrkdForDeltnFluentHelper setMaintOrdStsToMrkdForDeltn(
        @Nonnull final String maintenanceOrder,
        @Nullable final Boolean assgdMaintNotifIsToBeSetDel );

    /**
     * <p>
     * Creates a fluent helper for the <b>SetMaintOrdToMainWorkComplete</b> OData function import.
     * </p>
     *
     * @param maintenanceOrder
     *            Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>SetMaintOrdToMainWorkComplete</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.SetMaintOrdToMainWorkCompleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SetMaintOrdToMainWorkCompleteFluentHelper setMaintOrdToMainWorkComplete( @Nonnull final String maintenanceOrder );

    /**
     * <p>
     * Creates a fluent helper for the <b>SetMaintOrdToMainWorkComplete</b> OData function import.
     * </p>
     *
     * @param maintenanceOrder
     *            Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceOrder</b>
     *            </p>
     * @param mainWrkCmpltdDateTimeIsUsed
     *            Set as Reference Date and Time
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MainWrkCmpltdDateTimeIsUsed</b>
     *            </p>
     * @param mainWorkCompletedDateTime
     *            Main Work Completion Date and Time
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MainWorkCompletedDateTime</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>SetMaintOrdToMainWorkComplete</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.SetMaintOrdToMainWorkCompleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SetMaintOrdToMainWorkCompleteFluentHelper setMaintOrdToMainWorkComplete(
        @Nonnull final String maintenanceOrder,
        @Nullable final ZonedDateTime mainWorkCompletedDateTime,
        @Nullable final Boolean mainWrkCmpltdDateTimeIsUsed );

    /**
     * <p>
     * Creates a fluent helper for the <b>SetMaintOrdToTechCompleted</b> OData function import.
     * </p>
     *
     * @param maintenanceOrder
     *            Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceOrder</b>
     *            </p>
     * @param assignedMaintNotifIsToBeClosed
     *            Complete Assigned Notifications
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>AssignedMaintNotifIsToBeClosed</b>
     *            </p>
     * @param maintOrderReferenceDateTime
     *            Completion Date/Time
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintOrderReferenceDateTime</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>SetMaintOrdToTechCompleted</b> OData function import with
     *         the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.SetMaintOrdToTechCompletedFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SetMaintOrdToTechCompletedFluentHelper setMaintOrdToTechCompleted(
        @Nonnull final String maintenanceOrder,
        @Nullable final ZonedDateTime maintOrderReferenceDateTime,
        @Nullable final Boolean assignedMaintNotifIsToBeClosed );

    /**
     * <p>
     * Creates a fluent helper for the <b>SetMaintOrdToTechCompleted</b> OData function import.
     * </p>
     *
     * @param maintenanceOrder
     *            Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceOrder</b>
     *            </p>
     * @param assignedMaintNotifIsToBeClosed
     *            Complete Assigned Notifications
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>AssignedMaintNotifIsToBeClosed</b>
     *            </p>
     * @param mainWrkCmpltdDateTimeIsUsed
     *            Use Main Work Completed Date and Time
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MainWrkCmpltdDateTimeIsUsed</b>
     *            </p>
     * @param maintOrderReferenceDateTime
     *            Completion Date/Time
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintOrderReferenceDateTime</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>SetMaintOrdToTechCompleted</b> OData function import with
     *         the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.SetMaintOrdToTechCompletedFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SetMaintOrdToTechCompletedFluentHelper setMaintOrdToTechCompleted(
        @Nonnull final String maintenanceOrder,
        @Nullable final ZonedDateTime maintOrderReferenceDateTime,
        @Nullable final Boolean assignedMaintNotifIsToBeClosed,
        @Nullable final Boolean mainWrkCmpltdDateTimeIsUsed );

    /**
     * <p>
     * Creates a fluent helper for the <b>SubmitMaintOrderForApproval</b> OData function import.
     * </p>
     *
     * @param maintenanceOrder
     *            Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>SubmitMaintOrderForApproval</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.SubmitMaintOrderForApprovalFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SubmitMaintOrderForApprovalFluentHelper submitMaintOrderForApproval( @Nonnull final String maintenanceOrder );

    /**
     * <p>
     * Creates a fluent helper for the <b>ResetMaintOrderOpStsDispatched</b> OData function import.
     * </p>
     *
     * @param maintenanceOrder
     *            Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceOrder</b>
     *            </p>
     * @param maintenanceOrderOperation
     *            Operation
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceOrderOperation</b>
     *            </p>
     * @param maintenanceOrderSubOperation
     *            Suboperation
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceOrderSubOperation</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ResetMaintOrderOpStsDispatched</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.ResetMaintOrderOpStsDispatchedFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ResetMaintOrderOpStsDispatchedFluentHelper resetMaintOrderOpStsDispatched(
        @Nonnull final String maintenanceOrder,
        @Nonnull final String maintenanceOrderOperation,
        @Nonnull final String maintenanceOrderSubOperation );

    /**
     * <p>
     * Creates a fluent helper for the <b>SetMaintOrderOpToDispatched</b> OData function import.
     * </p>
     *
     * @param maintenanceOrder
     *            Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceOrder</b>
     *            </p>
     * @param maintenanceOrderOperation
     *            Operation
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceOrderOperation</b>
     *            </p>
     * @param maintenanceOrderSubOperation
     *            Suboperation
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceOrderSubOperation</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>SetMaintOrderOpToDispatched</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.SetMaintOrderOpToDispatchedFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SetMaintOrderOpToDispatchedFluentHelper setMaintOrderOpToDispatched(
        @Nonnull final String maintenanceOrder,
        @Nonnull final String maintenanceOrderOperation,
        @Nonnull final String maintenanceOrderSubOperation );

    /**
     * <p>
     * Creates a fluent helper for the <b>ActvtMaintOrderPhaseControl</b> OData function import.
     * </p>
     *
     * @param maintenanceOrder
     *            Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceOrder</b>
     *            </p>
     * @param maintenancePhaseControl
     *            Phase Control
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenancePhaseControl</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ActvtMaintOrderPhaseControl</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.ActvtMaintOrderPhaseControlFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ActvtMaintOrderPhaseControlFluentHelper actvtMaintOrderPhaseControl(
        @Nonnull final String maintenanceOrder,
        @Nonnull final String maintenancePhaseControl );

    /**
     * <p>
     * Creates a fluent helper for the <b>DactvtMaintOrderPhaseControl</b> OData function import.
     * </p>
     *
     * @param maintenanceOrder
     *            Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceOrder</b>
     *            </p>
     * @param maintenancePhaseControl
     *            Phase Control
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenancePhaseControl</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>DactvtMaintOrderPhaseControl</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.DactvtMaintOrderPhaseControlFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DactvtMaintOrderPhaseControlFluentHelper dactvtMaintOrderPhaseControl(
        @Nonnull final String maintenanceOrder,
        @Nonnull final String maintenancePhaseControl );

    /**
     * <p>
     * Creates a fluent helper for the <b>ActvtMaintOrderOpPhaseControl</b> OData function import.
     * </p>
     *
     * @param maintenanceOrder
     *            Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceOrder</b>
     *            </p>
     * @param maintenanceOrderOperation
     *            Constraints: Not nullable, Maximum length: 4
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceOrderOperation</b>
     *            </p>
     * @param maintenanceOrderSubOperation
     *            Suboperation
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceOrderSubOperation</b>
     *            </p>
     * @param maintenancePhaseControl
     *            Phase Control
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenancePhaseControl</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ActvtMaintOrderOpPhaseControl</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.ActvtMaintOrderOpPhaseControlFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ActvtMaintOrderOpPhaseControlFluentHelper actvtMaintOrderOpPhaseControl(
        @Nonnull final String maintenanceOrder,
        @Nonnull final String maintenanceOrderOperation,
        @Nonnull final String maintenanceOrderSubOperation,
        @Nonnull final String maintenancePhaseControl );

    /**
     * <p>
     * Creates a fluent helper for the <b>DactvtMaintOrderOpPhaseControl</b> OData function import.
     * </p>
     *
     * @param maintenanceOrder
     *            Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceOrder</b>
     *            </p>
     * @param maintenanceOrderOperation
     *            Constraints: Not nullable, Maximum length: 4
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceOrderOperation</b>
     *            </p>
     * @param maintenanceOrderSubOperation
     *            Suboperation
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceOrderSubOperation</b>
     *            </p>
     * @param maintenancePhaseControl
     *            Phase Control
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenancePhaseControl</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>DactvtMaintOrderOpPhaseControl</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.DactvtMaintOrderOpPhaseControlFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DactvtMaintOrderOpPhaseControlFluentHelper dactvtMaintOrderOpPhaseControl(
        @Nonnull final String maintenanceOrder,
        @Nonnull final String maintenanceOrderOperation,
        @Nonnull final String maintenanceOrderSubOperation,
        @Nonnull final String maintenancePhaseControl );

}
