/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;
import java.time.LocalTime;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.AssignMaintItemToMaintPlanFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintItemObjectListItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintItemObjectListItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintItemObjectListItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintItemObjectListItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintItemObjectListItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnCharValueByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnCharValueFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnClassByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnClassCharByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnClassCharFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnClassFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCause;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReason;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCallObjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCallObjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCycle;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCycleByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCycleFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCycleUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanScheduleByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanScheduleFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanStrategyCycleByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanStrategyCycleFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.ResetMaintPlanStsMrkdForDeltnFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.RestartMaintPlnScheduleFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.SetMainPlanStsToMrkdForDeltnFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.SetMaintPlanStatusToActiveFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.SetMaintPlanStatusToInactiveFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.StartMaintPlnScheduleFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.StartScheduleInCycleFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.batch.MaintenancePlanServiceBatch;

/**
 * <p>
 *
 * This API allows you to read, create, and update maintenance plans. It contains maintenance plans, schedules,
 * maintenance items, maintenance cycles and classification details. 
 *
 * The request contains all the information that is necessary to read, create, and update maintenance plans. If the
 * input in the request is not as expected, the system displays appropriate error or warning messages in the response. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/b5/f4fb481598452bb72c8169c2eedb03/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_MAINTENANCEPLAN?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_MAINTENANCEPLAN</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.3.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Maintenance Planning Integration(SAP_COM_0396)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3D2'>Service Order Management and Monitoring(3D2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4HH'>Reactive Maintenance(4HH)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4HI'>Proactive Maintenance(4HI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4VT'>Improvement Maintenance(4VT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4WM'>Operational and Overhead Maintenance(4WM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BH1'>Corrective Maintenance(BH1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BH2'>Emergency Maintenance(BH2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BJ2'>Preventive Maintenance(BJ2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OHH'>Reactive Maintenance(OHH)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OHI'>Proactive Maintenance(OHI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OJ2'>PSM: Preventive Maintenance(OJ2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OVT'>Improvement Maintenance(OVT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OWM'>Operational and Overhead Maintenance(OWM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4X5'>Recurring Services(4X5)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Maintenance Plan</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface MaintenancePlanService extends BatchService<MaintenancePlanServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_MAINTENANCEPLAN";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    MaintenancePlanService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItem
     * MaintenanceItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItem
     *         MaintenanceItem} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemFluentHelper getAllMaintenanceItem();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItem
     * MaintenanceItem} entity using key fields.
     *
     * @param maintenanceItem
     *            Maintenance Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 16
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItem
     *         MaintenanceItem} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemByKeyFluentHelper getMaintenanceItemByKey( final String maintenanceItem );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItem
     * MaintenanceItem} entity and save it to the S/4HANA system.
     *
     * @param maintenanceItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItem
     *            MaintenanceItem} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItem
     *         MaintenanceItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemCreateFluentHelper createMaintenanceItem( @Nonnull final MaintenanceItem maintenanceItem );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItem
     * MaintenanceItem} entity and save it to the S/4HANA system.
     *
     * @param maintenanceItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItem
     *            MaintenanceItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItem
     *         MaintenanceItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemUpdateFluentHelper updateMaintenanceItem( @Nonnull final MaintenanceItem maintenanceItem );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCause
     * MaintenanceItemCause} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCause
     *         MaintenanceItemCause} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemCauseFluentHelper getAllMaintenanceItemCause();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCause
     * MaintenanceItemCause} entity using key fields.
     *
     * @param nmbrOfMaintComplianceItems
     *            Sequential Number for Compliance
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param maintenanceItem
     *            Maintenance Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 16
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCause
     *         MaintenanceItemCause} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemCauseByKeyFluentHelper
        getMaintenanceItemCauseByKey( final String maintenanceItem, final String nmbrOfMaintComplianceItems );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCause
     * MaintenanceItemCause} entity and save it to the S/4HANA system.
     *
     * @param maintenanceItemCause
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCause
     *            MaintenanceItemCause} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCause
     *         MaintenanceItemCause} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemCauseCreateFluentHelper
        createMaintenanceItemCause( @Nonnull final MaintenanceItemCause maintenanceItemCause );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCause
     * MaintenanceItemCause} entity and save it to the S/4HANA system.
     *
     * @param maintenanceItemCause
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCause
     *            MaintenanceItemCause} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCause
     *         MaintenanceItemCause} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemCauseUpdateFluentHelper
        updateMaintenanceItemCause( @Nonnull final MaintenanceItemCause maintenanceItemCause );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCause
     * MaintenanceItemCause} entity in the S/4HANA system.
     *
     * @param maintenanceItemCause
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCause
     *            MaintenanceItemCause} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCause
     *         MaintenanceItemCause} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemCauseDeleteFluentHelper
        deleteMaintenanceItemCause( @Nonnull final MaintenanceItemCause maintenanceItemCause );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseText
     * MaintenanceItemCauseText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseText
     *         MaintenanceItemCauseText} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemCauseTextFluentHelper getAllMaintenanceItemCauseText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseText
     * MaintenanceItemCauseText} entity using key fields.
     *
     * @param nmbrOfMaintComplianceItems
     *            Sequential Number for Compliance
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param maintenanceItem
     *            Maintenance Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 16
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseText
     *         MaintenanceItemCauseText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemCauseTextByKeyFluentHelper getMaintenanceItemCauseTextByKey(
        final String maintenanceItem,
        final String nmbrOfMaintComplianceItems,
        final String language );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseText
     * MaintenanceItemCauseText} entity and save it to the S/4HANA system.
     *
     * @param maintenanceItemCauseText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseText
     *            MaintenanceItemCauseText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseText
     *         MaintenanceItemCauseText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemCauseTextUpdateFluentHelper
        updateMaintenanceItemCauseText( @Nonnull final MaintenanceItemCauseText maintenanceItemCauseText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseText
     * MaintenanceItemCauseText} entity in the S/4HANA system.
     *
     * @param maintenanceItemCauseText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseText
     *            MaintenanceItemCauseText} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseText
     *         MaintenanceItemCauseText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemCauseTextDeleteFluentHelper
        deleteMaintenanceItemCauseText( @Nonnull final MaintenanceItemCauseText maintenanceItemCauseText );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReason
     * MaintenanceItemReason} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReason
     *         MaintenanceItemReason} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemReasonFluentHelper getAllMaintenanceItemReason();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReason
     * MaintenanceItemReason} entity using key fields.
     *
     * @param nmbrOfMaintComplianceItems
     *            Sequential Number for Compliance
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param maintenanceItem
     *            Maintenance Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 16
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReason
     *         MaintenanceItemReason} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemReasonByKeyFluentHelper
        getMaintenanceItemReasonByKey( final String maintenanceItem, final String nmbrOfMaintComplianceItems );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReason
     * MaintenanceItemReason} entity and save it to the S/4HANA system.
     *
     * @param maintenanceItemReason
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReason
     *            MaintenanceItemReason} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReason
     *         MaintenanceItemReason} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemReasonCreateFluentHelper
        createMaintenanceItemReason( @Nonnull final MaintenanceItemReason maintenanceItemReason );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReason
     * MaintenanceItemReason} entity and save it to the S/4HANA system.
     *
     * @param maintenanceItemReason
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReason
     *            MaintenanceItemReason} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReason
     *         MaintenanceItemReason} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemReasonUpdateFluentHelper
        updateMaintenanceItemReason( @Nonnull final MaintenanceItemReason maintenanceItemReason );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReason
     * MaintenanceItemReason} entity in the S/4HANA system.
     *
     * @param maintenanceItemReason
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReason
     *            MaintenanceItemReason} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReason
     *         MaintenanceItemReason} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemReasonDeleteFluentHelper
        deleteMaintenanceItemReason( @Nonnull final MaintenanceItemReason maintenanceItemReason );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonText
     * MaintenanceItemReasonText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonText
     *         MaintenanceItemReasonText} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemReasonTextFluentHelper getAllMaintenanceItemReasonText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonText
     * MaintenanceItemReasonText} entity using key fields.
     *
     * @param nmbrOfMaintComplianceItems
     *            Sequential Number for Compliance
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param maintenanceItem
     *            Maintenance Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 16
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonText
     *         MaintenanceItemReasonText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemReasonTextByKeyFluentHelper getMaintenanceItemReasonTextByKey(
        final String maintenanceItem,
        final String nmbrOfMaintComplianceItems,
        final String language );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonText
     * MaintenanceItemReasonText} entity and save it to the S/4HANA system.
     *
     * @param maintenanceItemReasonText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonText
     *            MaintenanceItemReasonText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonText
     *         MaintenanceItemReasonText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemReasonTextUpdateFluentHelper
        updateMaintenanceItemReasonText( @Nonnull final MaintenanceItemReasonText maintenanceItemReasonText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonText
     * MaintenanceItemReasonText} entity in the S/4HANA system.
     *
     * @param maintenanceItemReasonText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonText
     *            MaintenanceItemReasonText} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonText
     *         MaintenanceItemReasonText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemReasonTextDeleteFluentHelper
        deleteMaintenanceItemReasonText( @Nonnull final MaintenanceItemReasonText maintenanceItemReasonText );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemText
     * MaintenanceItemText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemText
     *         MaintenanceItemText} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemTextFluentHelper getAllMaintenanceItemText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemText
     * MaintenanceItemText} entity using key fields.
     *
     * @param maintenanceItem
     *            Maintenance Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 16
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemText
     *         MaintenanceItemText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemTextByKeyFluentHelper
        getMaintenanceItemTextByKey( final String maintenanceItem, final String language );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemText
     * MaintenanceItemText} entity and save it to the S/4HANA system.
     *
     * @param maintenanceItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemText
     *            MaintenanceItemText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemText
     *         MaintenanceItemText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenanceItemTextUpdateFluentHelper
        updateMaintenanceItemText( @Nonnull final MaintenanceItemText maintenanceItemText );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan
     * MaintenancePlan} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan
     *         MaintenancePlan} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenancePlanFluentHelper getAllMaintenancePlan();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan
     * MaintenancePlan} entity using key fields.
     *
     * @param maintenancePlan
     *            Maintenance Plan
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan
     *         MaintenancePlan} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenancePlanByKeyFluentHelper getMaintenancePlanByKey( final String maintenancePlan );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan
     * MaintenancePlan} entity and save it to the S/4HANA system.
     *
     * @param maintenancePlan
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan
     *            MaintenancePlan} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan
     *         MaintenancePlan} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenancePlanCreateFluentHelper createMaintenancePlan( @Nonnull final MaintenancePlan maintenancePlan );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan
     * MaintenancePlan} entity and save it to the S/4HANA system.
     *
     * @param maintenancePlan
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan
     *            MaintenancePlan} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan
     *         MaintenancePlan} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenancePlanUpdateFluentHelper updateMaintenancePlan( @Nonnull final MaintenancePlan maintenancePlan );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCycle
     * MaintenancePlanCycle} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCycle
     *         MaintenancePlanCycle} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCycleFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenancePlanCycleFluentHelper getAllMaintenancePlanCycle();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCycle
     * MaintenancePlanCycle} entity using key fields.
     *
     * @param maintenancePlan
     *            Maintenance Plan
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param maintenancePlanCycle
     *            Counter in Control Tables
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCycle
     *         MaintenancePlanCycle} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCycleByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenancePlanCycleByKeyFluentHelper
        getMaintenancePlanCycleByKey( final String maintenancePlan, final String maintenancePlanCycle );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCycle
     * MaintenancePlanCycle} entity and save it to the S/4HANA system.
     *
     * @param maintenancePlanCycle
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCycle
     *            MaintenancePlanCycle} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCycle
     *         MaintenancePlanCycle} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCycleUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenancePlanCycleUpdateFluentHelper
        updateMaintenancePlanCycle( @Nonnull final MaintenancePlanCycle maintenancePlanCycle );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanSchedule
     * MaintenancePlanSchedule} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanSchedule
     *         MaintenancePlanSchedule} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanScheduleFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenancePlanScheduleFluentHelper getAllMaintenancePlanSchedule();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanSchedule
     * MaintenancePlanSchedule} entity using key fields.
     *
     * @param maintenancePlanCallNumber
     *            Maintenance Plan Call Number
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param maintenancePlan
     *            Maintenance Plan
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param maintenancePackage
     *            Maintenance Package Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanSchedule
     *         MaintenancePlanSchedule} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanScheduleByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenancePlanScheduleByKeyFluentHelper getMaintenancePlanScheduleByKey(
        final String maintenancePlan,
        final Integer maintenancePlanCallNumber,
        final String maintenancePackage );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanText
     * MaintenancePlanText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanText
     *         MaintenancePlanText} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenancePlanTextFluentHelper getAllMaintenancePlanText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanText
     * MaintenancePlanText} entity using key fields.
     *
     * @param maintenancePlan
     *            Maintenance Plan
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanText
     *         MaintenancePlanText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenancePlanTextByKeyFluentHelper
        getMaintenancePlanTextByKey( final String maintenancePlan, final String language );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanText
     * MaintenancePlanText} entity and save it to the S/4HANA system.
     *
     * @param maintenancePlanText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanText
     *            MaintenancePlanText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanText
     *         MaintenancePlanText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenancePlanTextUpdateFluentHelper
        updateMaintenancePlanText( @Nonnull final MaintenancePlanText maintenancePlanText );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintItemObjectListItem
     * MaintItemObjectListItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintItemObjectListItem
     *         MaintItemObjectListItem} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintItemObjectListItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintItemObjectListItemFluentHelper getAllMaintItemObjectListItem();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintItemObjectListItem
     * MaintItemObjectListItem} entity using key fields.
     *
     * @param maintenanceItemObjectList
     *            Object list number
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param maintenanceItem
     *            Maintenance Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 16
     *            </p>
     * @param maintenanceObjectListItem
     *            Object list counters
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintItemObjectListItem
     *         MaintItemObjectListItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintItemObjectListItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintItemObjectListItemByKeyFluentHelper getMaintItemObjectListItemByKey(
        final String maintenanceItem,
        final Long maintenanceItemObjectList,
        final Integer maintenanceObjectListItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintItemObjectListItem
     * MaintItemObjectListItem} entity and save it to the S/4HANA system.
     *
     * @param maintItemObjectListItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintItemObjectListItem
     *            MaintItemObjectListItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintItemObjectListItem
     *         MaintItemObjectListItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintItemObjectListItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintItemObjectListItemUpdateFluentHelper
        updateMaintItemObjectListItem( @Nonnull final MaintItemObjectListItem maintItemObjectListItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintItemObjectListItem
     * MaintItemObjectListItem} entity in the S/4HANA system.
     *
     * @param maintItemObjectListItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintItemObjectListItem
     *            MaintItemObjectListItem} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintItemObjectListItem
     *         MaintItemObjectListItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintItemObjectListItemDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintItemObjectListItemDeleteFluentHelper
        deleteMaintItemObjectListItem( @Nonnull final MaintItemObjectListItem maintItemObjectListItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCallObject
     * MaintenancePlanCallObject} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCallObject
     *         MaintenancePlanCallObject} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCallObjectFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenancePlanCallObjectFluentHelper getAllMaintenancePlanCallObject();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCallObject
     * MaintenancePlanCallObject} entity using key fields.
     *
     * @param maintenancePlanCallNumber
     *            Maintenance Plan Call Number
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param maintenancePlan
     *            Maintenance Plan
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param maintenanceItem
     *            Maintenance Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 16
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCallObject
     *         MaintenancePlanCallObject} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCallObjectByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenancePlanCallObjectByKeyFluentHelper getMaintenancePlanCallObjectByKey(
        final String maintenancePlan,
        final Integer maintenancePlanCallNumber,
        final String maintenanceItem );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnCharValue
     * MaintPlanClfnCharValue} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnCharValue
     *         MaintPlanClfnCharValue} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnCharValueFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintPlanClfnCharValueFluentHelper getAllMaintPlanClfnCharValue();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnCharValue
     * MaintPlanClfnCharValue} entity using key fields.
     *
     * @param clfnCharcValuePositionNumber
     *            Characteristic value counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param maintenancePlan
     *            Maintenance Plan
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param charcInternalID
     *            Characteristic Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param classType
     *            Class Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnCharValue
     *         MaintPlanClfnCharValue} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnCharValueByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintPlanClfnCharValueByKeyFluentHelper getMaintPlanClfnCharValueByKey(
        final String maintenancePlan,
        final String classType,
        final String clfnCharcValuePositionNumber,
        final String charcInternalID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnClass
     * MaintPlanClfnClass} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnClass
     *         MaintPlanClfnClass} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnClassFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintPlanClfnClassFluentHelper getAllMaintPlanClfnClass();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnClass
     * MaintPlanClfnClass} entity using key fields.
     *
     * @param maintenancePlan
     *            Maintenance Plan
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param classInternalID
     *            Internal Class Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param classType
     *            Class Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnClass
     *         MaintPlanClfnClass} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnClassByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintPlanClfnClassByKeyFluentHelper getMaintPlanClfnClassByKey(
        final String maintenancePlan,
        final String classInternalID,
        final String classType );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnClassChar
     * MaintPlanClfnClassChar} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnClassChar
     *         MaintPlanClfnClassChar} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnClassCharFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintPlanClfnClassCharFluentHelper getAllMaintPlanClfnClassChar();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnClassChar
     * MaintPlanClfnClassChar} entity using key fields.
     *
     * @param maintenancePlan
     *            Maintenance Plan
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param charcInternalID
     *            Characteristic Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param classInternalID
     *            Internal Class Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnClassChar
     *         MaintPlanClfnClassChar} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnClassCharByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintPlanClfnClassCharByKeyFluentHelper getMaintPlanClfnClassCharByKey(
        final String maintenancePlan,
        final String classInternalID,
        final String charcInternalID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanStrategyCycle
     * MaintenancePlanStrategyCycle} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanStrategyCycle
     *         MaintenancePlanStrategyCycle} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanStrategyCycleFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenancePlanStrategyCycleFluentHelper getAllMaintenancePlanStrategyCycle();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanStrategyCycle
     * MaintenancePlanStrategyCycle} entity using key fields.
     *
     * @param maintenancePlan
     *            Maintenance Plan
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param maintenancePlanCycle
     *            Counter in Control Tables
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanStrategyCycle
     *         MaintenancePlanStrategyCycle} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanStrategyCycleByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaintenancePlanStrategyCycleByKeyFluentHelper
        getMaintenancePlanStrategyCycleByKey( final String maintenancePlan, final String maintenancePlanCycle );

    /**
     * <p>
     * Creates a fluent helper for the <b>AssignMaintItemToMaintPlan</b> OData function import.
     * </p>
     *
     * @param maintenancePlan
     *            Maintenance Plan
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenancePlan</b>
     *            </p>
     * @param maintenanceitem
     *            Maintenance Item
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 16
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Maintenanceitem</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>AssignMaintItemToMaintPlan</b> OData function import with
     *         the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.AssignMaintItemToMaintPlanFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AssignMaintItemToMaintPlanFluentHelper
        assignMaintItemToMaintPlan( @Nonnull final String maintenancePlan, @Nonnull final String maintenanceitem );

    /**
     * <p>
     * Creates a fluent helper for the <b>ResetMaintPlanStsMrkdForDeltn</b> OData function import.
     * </p>
     *
     * @param maintenancePlan
     *            Maintenance Plan
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenancePlan</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ResetMaintPlanStsMrkdForDeltn</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.ResetMaintPlanStsMrkdForDeltnFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ResetMaintPlanStsMrkdForDeltnFluentHelper resetMaintPlanStsMrkdForDeltn( @Nonnull final String maintenancePlan );

    /**
     * <p>
     * Creates a fluent helper for the <b>RestartMaintPlnSchedule</b> OData function import.
     * </p>
     *
     * @param maintPlanSchedFutrCallsAreKept
     *            Boolean Variable (X = True, - = False, Space = Unknown)
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintPlanSchedFutrCallsAreKept</b>
     *            </p>
     * @param maintenancePlan
     *            Maintenance Plan
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenancePlan</b>
     *            </p>
     * @param schedulingStartDate
     *            Start of cycle
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SchedulingStartDate</b>
     *            </p>
     * @param schedulingStartTime
     *            Start Time
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SchedulingStartTime</b>
     *            </p>
     * @param maintPlanStartCntrReadingValue
     *            StartCounterReading
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 22
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintPlanStartCntrReadingValue</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>RestartMaintPlnSchedule</b> OData function import with
     *         the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.RestartMaintPlnScheduleFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RestartMaintPlnScheduleFluentHelper restartMaintPlnSchedule(
        @Nonnull final String maintenancePlan,
        @Nullable final LocalDateTime schedulingStartDate,
        @Nullable final LocalTime schedulingStartTime,
        @Nullable final String maintPlanStartCntrReadingValue,
        @Nullable final Boolean maintPlanSchedFutrCallsAreKept );

    /**
     * <p>
     * Creates a fluent helper for the <b>SetMainPlanStsToMrkdForDeltn</b> OData function import.
     * </p>
     *
     * @param maintenancePlan
     *            Maintenance Plan
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenancePlan</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>SetMainPlanStsToMrkdForDeltn</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.SetMainPlanStsToMrkdForDeltnFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SetMainPlanStsToMrkdForDeltnFluentHelper setMainPlanStsToMrkdForDeltn( @Nonnull final String maintenancePlan );

    /**
     * <p>
     * Creates a fluent helper for the <b>SetMaintPlanStatusToActive</b> OData function import.
     * </p>
     *
     * @param maintenancePlan
     *            Maintenance Plan
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenancePlan</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>SetMaintPlanStatusToActive</b> OData function import with
     *         the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.SetMaintPlanStatusToActiveFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SetMaintPlanStatusToActiveFluentHelper setMaintPlanStatusToActive( @Nonnull final String maintenancePlan );

    /**
     * <p>
     * Creates a fluent helper for the <b>SetMaintPlanStatusToInactive</b> OData function import.
     * </p>
     *
     * @param maintenancePlan
     *            Maintenance Plan
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenancePlan</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>SetMaintPlanStatusToInactive</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.SetMaintPlanStatusToInactiveFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SetMaintPlanStatusToInactiveFluentHelper setMaintPlanStatusToInactive( @Nonnull final String maintenancePlan );

    /**
     * <p>
     * Creates a fluent helper for the <b>StartMaintPlnSchedule</b> OData function import.
     * </p>
     *
     * @param maintenancePlan
     *            Maintenance Plan
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenancePlan</b>
     *            </p>
     * @param schedulingStartDate
     *            Start of cycle
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SchedulingStartDate</b>
     *            </p>
     * @param schedulingStartTime
     *            Start Time
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SchedulingStartTime</b>
     *            </p>
     * @param maintPlanStartCntrReadingValue
     *            StartCounterReading
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 22
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintPlanStartCntrReadingValue</b>
     *            </p>
     * @param maintPlnSchedgCallObjUpToDte
     *            Current Date
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintPlnSchedgCallObjUpToDte</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>StartMaintPlnSchedule</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.StartMaintPlnScheduleFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    StartMaintPlnScheduleFluentHelper startMaintPlnSchedule(
        @Nonnull final String maintenancePlan,
        @Nullable final LocalDateTime schedulingStartDate,
        @Nullable final LocalTime schedulingStartTime,
        @Nullable final String maintPlanStartCntrReadingValue,
        @Nullable final LocalDateTime maintPlnSchedgCallObjUpToDte );

    /**
     * <p>
     * Creates a fluent helper for the <b>StartScheduleInCycle</b> OData function import.
     * </p>
     *
     * @param completionTime
     *            Time
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CompletionTime</b>
     *            </p>
     * @param maintPlnCallCompltnCntrRdngVal
     *            Compl.CountRead.
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 22
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintPlnCallCompltnCntrRdngVal</b>
     *            </p>
     * @param maintPlanSchedFutrCallsAreKept
     *            Boolean Variable (X = True, - = False, Space = Unknown)
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintPlanSchedFutrCallsAreKept</b>
     *            </p>
     * @param maintenancePlan
     *            Maintenance Plan
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenancePlan</b>
     *            </p>
     * @param maintPlanCycleOffsetValue
     *            Offset
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintPlanCycleOffsetValue</b>
     *            </p>
     * @param completionDate
     *            Completion date
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CompletionDate</b>
     *            </p>
     * @param maintenanceTaskPerformanceUnit
     *            Unit
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceTaskPerformanceUnit</b>
     *            </p>
     * @param maintenancePackage
     *            Package
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenancePackage</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>StartScheduleInCycle</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.StartScheduleInCycleFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    StartScheduleInCycleFluentHelper startScheduleInCycle(
        @Nonnull final String maintenancePlan,
        @Nullable final String maintenancePackage,
        @Nullable final Integer maintPlanCycleOffsetValue,
        @Nullable final String maintenanceTaskPerformanceUnit,
        @Nullable final Boolean maintPlanSchedFutrCallsAreKept,
        @Nullable final LocalDateTime completionDate,
        @Nullable final LocalTime completionTime,
        @Nullable final String maintPlnCallCompltnCntrRdngVal );

}
