/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecificationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecificationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecificationTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecificationTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.batch.MasterInspectionCharacteristicServiceBatch;

/**
 * <p>
 *
 * A master inspection characteristic is a master data record that describes the quality inspection criteria for
 * materials. This service enables you to retrieve, for example, the settings and the control indicators defined for a
 * master inspection characteristic..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/71/644958b4ae9144e10000000a4450e5/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_MASTERINSPCHARACTERISTIC_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_MASTERINSPCHARACTERISTIC_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>2.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Inspection Master Data Integration(SAP_COM_0110)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1E1'>Quality Management in Discrete Manufacturing(1E1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1FM'>Quality Management in Procurement(1FM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1MP'>Quality Management in Sales(1MP)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1MR'>Quality Management in Stock Handling(1MR)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2QN'>Nonconformance Management(2QN)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Inspection Specification</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface MasterInspectionCharacteristicService extends BatchService<MasterInspectionCharacteristicServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_MASTERINSPCHARACTERISTIC_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    MasterInspectionCharacteristicService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification
     * InspectionSpecification} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification
     *         InspectionSpecification} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecificationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspectionSpecificationFluentHelper getAllInspectionSpecification();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification
     * InspectionSpecification} entity using key fields.
     *
     * @param inspectionSpecificationPlant
     *            Plant for Master Inspection Characteristic
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param inspectionSpecification
     *            Master Inspection Characteristic
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param inspectionSpecificationVersion
     *            Version Number of Master Inspection Characteristic
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecification
     *         InspectionSpecification} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecificationByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspectionSpecificationByKeyFluentHelper getInspectionSpecificationByKey(
        final String inspectionSpecification,
        final String inspectionSpecificationVersion,
        final String inspectionSpecificationPlant );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecificationText
     * InspectionSpecificationText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecificationText
     *         InspectionSpecificationText} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecificationTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspectionSpecificationTextFluentHelper getAllInspectionSpecificationText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecificationText
     * InspectionSpecificationText} entity using key fields.
     *
     * @param inspectionSpecificationPlant
     *            Plant for Master Inspection Characteristic
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param inspectionSpecification
     *            Master Inspection Characteristic
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param inspectionSpecificationVersion
     *            Version Number of Inspection Method
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecificationText
     *         InspectionSpecificationText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.InspectionSpecificationTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspectionSpecificationTextByKeyFluentHelper getInspectionSpecificationTextByKey(
        final String inspectionSpecification,
        final String inspectionSpecificationVersion,
        final String inspectionSpecificationPlant,
        final String language );

}
