/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeHeaderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeHeaderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeHeaderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeHeaderUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeMatlAssgmtByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeMatlAssgmtFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOpCompAllocByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOpCompAllocFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOpSecdryRsce;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOpSecdryRsceByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOpSecdryRsceCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOpSecdryRsceFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOpSecdryRsceUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOperation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOperationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOperationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOperationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOperationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhaseByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhaseCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhaseFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhaseUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAlloc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAllocByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAllocCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAllocFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAllocUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseRelshp;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseRelshpByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseRelshpCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseRelshpFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseRelshpUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseSecdryRsce;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseSecdryRsceByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseSecdryRsceCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseSecdryRsceFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseSecdryRsceUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.batch.MasterRecipeServiceBatch;

/**
 * <p>
 *
 * Master recipes are used for planning the manufacture of products. It is used as a reference for process orders and in
 * calculating the costs of products.
 *
 * Master recipe is a description of the operations or phases (steps in a process) that must be carried out in a certain
 * order to manufacture a product. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/4d/9ed891a8c547c493e70dbfdcbea7bb/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference:
 * <a href='https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_MASTER_RECIPE?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_MASTER_RECIPE</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.2</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Production Planning Master Data Integration(SAP_COM_0519)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3W3'>Third-Party Shop Floor Execution - Process Industry(3W3)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3W4'>Third-Party Shop Floor Execution - Discrete
 * Industry(3W4)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Master Recipe</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface MasterRecipeService extends BatchService<MasterRecipeServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_MASTER_RECIPE";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    MasterRecipeService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeHeader
     * MasterRecipeHeader} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeHeader
     *         MasterRecipeHeader} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeHeaderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MasterRecipeHeaderFluentHelper getAllMasterRecipeHeader();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeHeader
     * MasterRecipeHeader} entity using key fields.
     *
     * @param masterRecipe
     *            Group Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param masterRecipeGroup
     *            Key for Task List Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param masterRecipeInternalVersion
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeHeader
     *         MasterRecipeHeader} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeHeaderByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MasterRecipeHeaderByKeyFluentHelper getMasterRecipeHeaderByKey(
        final String masterRecipeGroup,
        final String masterRecipe,
        final String masterRecipeInternalVersion );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeHeader
     * MasterRecipeHeader} entity and save it to the S/4HANA system.
     *
     * @param masterRecipeHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeHeader
     *            MasterRecipeHeader} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeHeader
     *         MasterRecipeHeader} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeHeaderCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MasterRecipeHeaderCreateFluentHelper
        createMasterRecipeHeader( @Nonnull final MasterRecipeHeader masterRecipeHeader );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeHeader
     * MasterRecipeHeader} entity and save it to the S/4HANA system.
     *
     * @param masterRecipeHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeHeader
     *            MasterRecipeHeader} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeHeader
     *         MasterRecipeHeader} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeHeaderUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MasterRecipeHeaderUpdateFluentHelper
        updateMasterRecipeHeader( @Nonnull final MasterRecipeHeader masterRecipeHeader );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeMatlAssgmt
     * MasterRecipeMatlAssgmt} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeMatlAssgmt
     *         MasterRecipeMatlAssgmt} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeMatlAssgmtFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MasterRecipeMatlAssgmtFluentHelper getAllMasterRecipeMatlAssgmt();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeMatlAssgmt
     * MasterRecipeMatlAssgmt} entity using key fields.
     *
     * @param product
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param masterRecipe
     *            Group Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param mstrRcpMatlAssgmtIntVersion
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param masterRecipeGroup
     *            Key for Task List Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param masterRecipeMaterialAssignment
     *            Counter for additional criteria
     *            <p>
     *            Constraints: Not nullable, Maximum length: 7
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeMatlAssgmt
     *         MasterRecipeMatlAssgmt} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeMatlAssgmtByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MasterRecipeMatlAssgmtByKeyFluentHelper getMasterRecipeMatlAssgmtByKey(
        final String product,
        final String plant,
        final String masterRecipeGroup,
        final String masterRecipe,
        final String masterRecipeMaterialAssignment,
        final String mstrRcpMatlAssgmtIntVersion );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOpCompAlloc
     * MasterRecipeOpCompAlloc} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOpCompAlloc
     *         MasterRecipeOpCompAlloc} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOpCompAllocFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MasterRecipeOpCompAllocFluentHelper getAllMasterRecipeOpCompAlloc();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOpCompAlloc
     * MasterRecipeOpCompAlloc} entity using key fields.
     *
     * @param masterRecipe
     *            Group Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param mstrRcpOpBOMItemIntVersion
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param masterRecipeGroup
     *            Key for Task List Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param mstrRcpOpBOMItemInternalID
     *            No. for material comp. allocation to task list
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param masterRecipeOperationIntID
     *            Task list node number for operation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOpCompAlloc
     *         MasterRecipeOpCompAlloc} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOpCompAllocByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MasterRecipeOpCompAllocByKeyFluentHelper getMasterRecipeOpCompAllocByKey(
        final String masterRecipeGroup,
        final String masterRecipe,
        final String masterRecipeOperationIntID,
        final String mstrRcpOpBOMItemInternalID,
        final String mstrRcpOpBOMItemIntVersion );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOperation
     * MasterRecipeOperation} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOperation
     *         MasterRecipeOperation} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOperationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MasterRecipeOperationFluentHelper getAllMasterRecipeOperation();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOperation
     * MasterRecipeOperation} entity using key fields.
     *
     * @param masterRecipe
     *            Group Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param masterRecipeGroup
     *            Key for Task List Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param masterRecipeOperationIntID
     *            Number of the Task List Node
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param mstrRcpOperationIntVersion
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOperation
     *         MasterRecipeOperation} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOperationByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MasterRecipeOperationByKeyFluentHelper getMasterRecipeOperationByKey(
        final String masterRecipeGroup,
        final String masterRecipe,
        final String masterRecipeOperationIntID,
        final String mstrRcpOperationIntVersion );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOperation
     * MasterRecipeOperation} entity and save it to the S/4HANA system.
     *
     * @param masterRecipeOperation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOperation
     *            MasterRecipeOperation} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOperation
     *         MasterRecipeOperation} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOperationCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MasterRecipeOperationCreateFluentHelper
        createMasterRecipeOperation( @Nonnull final MasterRecipeOperation masterRecipeOperation );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOperation
     * MasterRecipeOperation} entity and save it to the S/4HANA system.
     *
     * @param masterRecipeOperation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOperation
     *            MasterRecipeOperation} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOperation
     *         MasterRecipeOperation} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOperationUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MasterRecipeOperationUpdateFluentHelper
        updateMasterRecipeOperation( @Nonnull final MasterRecipeOperation masterRecipeOperation );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOpSecdryRsce
     * MasterRecipeOpSecdryRsce} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOpSecdryRsce
     *         MasterRecipeOpSecdryRsce} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOpSecdryRsceFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MasterRecipeOpSecdryRsceFluentHelper getAllMasterRecipeOpSecdryRsce();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOpSecdryRsce
     * MasterRecipeOpSecdryRsce} entity using key fields.
     *
     * @param masterRecipe
     *            Group Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param masterRecipeGroup
     *            Key for Task List Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param masterRecipeOperationIntID
     *            Number of the Task List Node
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param mstrRcpOperationIntVersion
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOpSecdryRsce
     *         MasterRecipeOpSecdryRsce} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOpSecdryRsceByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MasterRecipeOpSecdryRsceByKeyFluentHelper getMasterRecipeOpSecdryRsceByKey(
        final String masterRecipeGroup,
        final String masterRecipe,
        final String masterRecipeOperationIntID,
        final String mstrRcpOperationIntVersion );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOpSecdryRsce
     * MasterRecipeOpSecdryRsce} entity and save it to the S/4HANA system.
     *
     * @param masterRecipeOpSecdryRsce
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOpSecdryRsce
     *            MasterRecipeOpSecdryRsce} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOpSecdryRsce
     *         MasterRecipeOpSecdryRsce} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOpSecdryRsceCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MasterRecipeOpSecdryRsceCreateFluentHelper
        createMasterRecipeOpSecdryRsce( @Nonnull final MasterRecipeOpSecdryRsce masterRecipeOpSecdryRsce );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOpSecdryRsce
     * MasterRecipeOpSecdryRsce} entity and save it to the S/4HANA system.
     *
     * @param masterRecipeOpSecdryRsce
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOpSecdryRsce
     *            MasterRecipeOpSecdryRsce} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOpSecdryRsce
     *         MasterRecipeOpSecdryRsce} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipeOpSecdryRsceUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MasterRecipeOpSecdryRsceUpdateFluentHelper
        updateMasterRecipeOpSecdryRsce( @Nonnull final MasterRecipeOpSecdryRsce masterRecipeOpSecdryRsce );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase
     * MasterRecipePhase} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase
     *         MasterRecipePhase} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhaseFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MasterRecipePhaseFluentHelper getAllMasterRecipePhase();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase
     * MasterRecipePhase} entity using key fields.
     *
     * @param masterRecipe
     *            Group Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param mstrRcpSuperiorOpIntVersion
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param masterRecipeGroup
     *            Key for Task List Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param masterRecipeOperationIntID
     *            Number of the Task List Node
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param mstrRcpOperationIntVersion
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase
     *         MasterRecipePhase} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhaseByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MasterRecipePhaseByKeyFluentHelper getMasterRecipePhaseByKey(
        final String masterRecipeGroup,
        final String masterRecipe,
        final String masterRecipeOperationIntID,
        final String mstrRcpSuperiorOpIntVersion,
        final String mstrRcpOperationIntVersion );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase
     * MasterRecipePhase} entity and save it to the S/4HANA system.
     *
     * @param masterRecipePhase
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase
     *            MasterRecipePhase} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase
     *         MasterRecipePhase} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhaseCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MasterRecipePhaseCreateFluentHelper createMasterRecipePhase( @Nonnull final MasterRecipePhase masterRecipePhase );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase
     * MasterRecipePhase} entity and save it to the S/4HANA system.
     *
     * @param masterRecipePhase
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase
     *            MasterRecipePhase} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhase
     *         MasterRecipePhase} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhaseUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MasterRecipePhaseUpdateFluentHelper updateMasterRecipePhase( @Nonnull final MasterRecipePhase masterRecipePhase );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAlloc
     * MasterRecipePhseCompAlloc} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAlloc
     *         MasterRecipePhseCompAlloc} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAllocFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MasterRecipePhseCompAllocFluentHelper getAllMasterRecipePhseCompAlloc();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAlloc
     * MasterRecipePhseCompAlloc} entity using key fields.
     *
     * @param masterRecipe
     *            Group Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param mstrRcpOpBOMItemIntVersion
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param masterRecipeGroup
     *            Key for Task List Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param mstrRcpOpBOMItemInternalID
     *            No. for material comp. allocation to task list
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param masterRecipeOperationIntID
     *            Task list node number for operation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAlloc
     *         MasterRecipePhseCompAlloc} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAllocByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MasterRecipePhseCompAllocByKeyFluentHelper getMasterRecipePhseCompAllocByKey(
        final String masterRecipeGroup,
        final String masterRecipe,
        final String masterRecipeOperationIntID,
        final String mstrRcpOpBOMItemInternalID,
        final String mstrRcpOpBOMItemIntVersion );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAlloc
     * MasterRecipePhseCompAlloc} entity and save it to the S/4HANA system.
     *
     * @param masterRecipePhseCompAlloc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAlloc
     *            MasterRecipePhseCompAlloc} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAlloc
     *         MasterRecipePhseCompAlloc} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAllocCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MasterRecipePhseCompAllocCreateFluentHelper
        createMasterRecipePhseCompAlloc( @Nonnull final MasterRecipePhseCompAlloc masterRecipePhseCompAlloc );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAlloc
     * MasterRecipePhseCompAlloc} entity and save it to the S/4HANA system.
     *
     * @param masterRecipePhseCompAlloc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAlloc
     *            MasterRecipePhseCompAlloc} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAlloc
     *         MasterRecipePhseCompAlloc} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseCompAllocUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MasterRecipePhseCompAllocUpdateFluentHelper
        updateMasterRecipePhseCompAlloc( @Nonnull final MasterRecipePhseCompAlloc masterRecipePhseCompAlloc );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseSecdryRsce
     * MasterRecipePhseSecdryRsce} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseSecdryRsce
     *         MasterRecipePhseSecdryRsce} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseSecdryRsceFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MasterRecipePhseSecdryRsceFluentHelper getAllMasterRecipePhseSecdryRsce();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseSecdryRsce
     * MasterRecipePhseSecdryRsce} entity using key fields.
     *
     * @param masterRecipe
     *            Group Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param masterRecipeGroup
     *            Key for Task List Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param masterRecipeOperationIntID
     *            Number of the Task List Node
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param mstrRcpOperationIntVersion
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseSecdryRsce
     *         MasterRecipePhseSecdryRsce} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseSecdryRsceByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MasterRecipePhseSecdryRsceByKeyFluentHelper getMasterRecipePhseSecdryRsceByKey(
        final String masterRecipeGroup,
        final String masterRecipe,
        final String masterRecipeOperationIntID,
        final String mstrRcpOperationIntVersion );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseSecdryRsce
     * MasterRecipePhseSecdryRsce} entity and save it to the S/4HANA system.
     *
     * @param masterRecipePhseSecdryRsce
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseSecdryRsce
     *            MasterRecipePhseSecdryRsce} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseSecdryRsce
     *         MasterRecipePhseSecdryRsce} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseSecdryRsceCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MasterRecipePhseSecdryRsceCreateFluentHelper
        createMasterRecipePhseSecdryRsce( @Nonnull final MasterRecipePhseSecdryRsce masterRecipePhseSecdryRsce );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseSecdryRsce
     * MasterRecipePhseSecdryRsce} entity and save it to the S/4HANA system.
     *
     * @param masterRecipePhseSecdryRsce
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseSecdryRsce
     *            MasterRecipePhseSecdryRsce} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseSecdryRsce
     *         MasterRecipePhseSecdryRsce} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseSecdryRsceUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MasterRecipePhseSecdryRsceUpdateFluentHelper
        updateMasterRecipePhseSecdryRsce( @Nonnull final MasterRecipePhseSecdryRsce masterRecipePhseSecdryRsce );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseRelshp
     * MasterRecipePhseRelshp} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseRelshp
     *         MasterRecipePhseRelshp} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseRelshpFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MasterRecipePhseRelshpFluentHelper getAllMasterRecipePhseRelshp();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseRelshp
     * MasterRecipePhseRelshp} entity using key fields.
     *
     * @param succssrMstrRcpOpInternalID
     *            Number of the Task List Node
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param masterRecipeRelationshipType
     *            Type of relationship
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param succssrMasterRecipeGroup
     *            Number of the Standard Network
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param mstrRcpRelationshipIntVersion
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param prdcssrMstrRcpOpInternalID
     *            Number of the Task List Node
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param succssrMasterRecipe
     *            Group Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param prdcssrMasterRecipeGroup
     *            Number of the Standard Network
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param maxTimeIntvlIsUsedForSchedg
     *            Indicates whether maximum time interval will be considered
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param prdcssrMasterRecipe
     *            Group Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseRelshp
     *         MasterRecipePhseRelshp} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseRelshpByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MasterRecipePhseRelshpByKeyFluentHelper getMasterRecipePhseRelshpByKey(
        final String prdcssrMasterRecipeGroup,
        final String prdcssrMasterRecipe,
        final String prdcssrMstrRcpOpInternalID,
        final String succssrMasterRecipeGroup,
        final String succssrMasterRecipe,
        final String succssrMstrRcpOpInternalID,
        final String masterRecipeRelationshipType,
        final Boolean maxTimeIntvlIsUsedForSchedg,
        final String mstrRcpRelationshipIntVersion );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseRelshp
     * MasterRecipePhseRelshp} entity and save it to the S/4HANA system.
     *
     * @param masterRecipePhseRelshp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseRelshp
     *            MasterRecipePhseRelshp} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseRelshp
     *         MasterRecipePhseRelshp} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseRelshpCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MasterRecipePhseRelshpCreateFluentHelper
        createMasterRecipePhseRelshp( @Nonnull final MasterRecipePhseRelshp masterRecipePhseRelshp );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseRelshp
     * MasterRecipePhseRelshp} entity and save it to the S/4HANA system.
     *
     * @param masterRecipePhseRelshp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseRelshp
     *            MasterRecipePhseRelshp} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseRelshp
     *         MasterRecipePhseRelshp} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterrecipe.MasterRecipePhseRelshpUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MasterRecipePhseRelshpUpdateFluentHelper
        updateMasterRecipePhseRelshp( @Nonnull final MasterRecipePhseRelshp masterRecipePhseRelshp );

}
