/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.CancelFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.CancelItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentHeaderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentHeaderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentHeaderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.SerialNumberMaterialDocumentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.SerialNumberMaterialDocumentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.batch.MaterialDocumentServiceBatch;

/**
 * <p>
 *
 * This service enables you to retrieve and create material documents, for example, to post a goods receipt for a
 * purchase order or to document the transfer of materials between two storage locations. Additionally, the service
 * allows you to cancel existing material documents or single items. It can be consumed by external systems and user
 * interfaces..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/d4/c919581bc30a02e10000000a44147b/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_MATERIAL_DOCUMENT_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_MATERIAL_DOCUMENT_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.2.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Material Document Integration(SAP_COM_0108)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BMC'>Core Inventory Management(BMC)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OMC'>Core Inventory Management(OMC)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Material Document</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface MaterialDocumentService extends BatchService<MaterialDocumentServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_MATERIAL_DOCUMENT_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    MaterialDocumentService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentHeader
     * MaterialDocumentHeader} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentHeader
     *         MaterialDocumentHeader} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentHeaderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaterialDocumentHeaderFluentHelper getAllMaterialDocumentHeader();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentHeader
     * MaterialDocumentHeader} entity using key fields.
     *
     * @param materialDocument
     *            Number of Material Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param materialDocumentYear
     *            Material Document Year
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentHeader
     *         MaterialDocumentHeader} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentHeaderByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaterialDocumentHeaderByKeyFluentHelper
        getMaterialDocumentHeaderByKey( final String materialDocumentYear, final String materialDocument );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentHeader
     * MaterialDocumentHeader} entity and save it to the S/4HANA system.
     *
     * @param materialDocumentHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentHeader
     *            MaterialDocumentHeader} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentHeader
     *         MaterialDocumentHeader} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentHeaderCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaterialDocumentHeaderCreateFluentHelper
        createMaterialDocumentHeader( @Nonnull final MaterialDocumentHeader materialDocumentHeader );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem
     * MaterialDocumentItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem
     *         MaterialDocumentItem} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaterialDocumentItemFluentHelper getAllMaterialDocumentItem();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem
     * MaterialDocumentItem} entity using key fields.
     *
     * @param materialDocument
     *            Number of Material Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param materialDocumentItem
     *            Material Document Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param materialDocumentYear
     *            Material Document Year
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem
     *         MaterialDocumentItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaterialDocumentItemByKeyFluentHelper getMaterialDocumentItemByKey(
        final String materialDocumentYear,
        final String materialDocument,
        final String materialDocumentItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.SerialNumberMaterialDocument
     * SerialNumberMaterialDocument} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.SerialNumberMaterialDocument
     *         SerialNumberMaterialDocument} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.SerialNumberMaterialDocumentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SerialNumberMaterialDocumentFluentHelper getAllSerialNumberMaterialDocument();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.SerialNumberMaterialDocument
     * SerialNumberMaterialDocument} entity using key fields.
     *
     * @param materialDocument
     *            Number of Material Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param serialNumber
     *            Serial Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param material
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param materialDocumentItem
     *            Material Document Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param materialDocumentYear
     *            Material Document Year
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.SerialNumberMaterialDocument
     *         SerialNumberMaterialDocument} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.SerialNumberMaterialDocumentByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SerialNumberMaterialDocumentByKeyFluentHelper getSerialNumberMaterialDocumentByKey(
        final String material,
        final String serialNumber,
        final String materialDocument,
        final String materialDocumentItem,
        final String materialDocumentYear );

    /**
     * <p>
     * Creates a fluent helper for the <b>Cancel</b> OData function import.
     * </p>
     *
     * @param materialDocument
     *            Material Document
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaterialDocument</b>
     *            </p>
     * @param materialDocumentYear
     *            Material Doc. Year
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaterialDocumentYear</b>
     *            </p>
     * @param postingDate
     *            Posting Date
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PostingDate</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>Cancel</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.CancelFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CancelFluentHelper cancel(
        @Nonnull final String materialDocumentYear,
        @Nonnull final String materialDocument,
        @Nullable final LocalDateTime postingDate );

    /**
     * <p>
     * Creates a fluent helper for the <b>CancelItem</b> OData function import.
     * </p>
     *
     * @param materialDocument
     *            Material Document
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaterialDocument</b>
     *            </p>
     * @param materialDocumentItem
     *            Material Doc.Item
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaterialDocumentItem</b>
     *            </p>
     * @param materialDocumentYear
     *            Material Doc. Year
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaterialDocumentYear</b>
     *            </p>
     * @param postingDate
     *            Posting Date
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PostingDate</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>CancelItem</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.CancelItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CancelItemFluentHelper cancelItem(
        @Nonnull final String materialDocumentYear,
        @Nonnull final String materialDocument,
        @Nonnull final String materialDocumentItem,
        @Nullable final LocalDateTime postingDate );

}
