/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterialByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterialFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MaterialCoverageByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MaterialCoverageFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.batch.MaterialPlanningDataServiceBatch;

/**
 * <p>
 * The service contains entities for material master data, supply and demand information, and information about the
 * coverage of materials. You can read master data for one or more materials. You can read supply and demand information
 * over a certain time period, or you can aggregate the quantities on category group level. You can read material
 * coverage information.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/ca/111d6ed0004ac088b68f1360cf24fc/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_MRP_MATERIALS_SRV_01?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_MRP_MATERIALS_SRV_01</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Production Planning Integration(SAP_COM_0104)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BJ5'> Make-to-Stock Production - Discrete Manufacturing(BJ5)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BJ8'>Make-to-Stock - Process Manufacturing Based on Process
 * Order(BJ8)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/J44'>Material Requirements Planning(J44)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O44'>Material Requirements Planning(O44)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Material Supply And Demand View</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface MaterialPlanningDataService extends BatchService<MaterialPlanningDataServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_MRP_MATERIALS_SRV_01";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    MaterialPlanningDataService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MaterialCoverage
     * MaterialCoverage} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MaterialCoverage
     *         MaterialCoverage} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MaterialCoverageFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaterialCoverageFluentHelper getAllMaterialCoverage();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MaterialCoverage
     * MaterialCoverage} entity using key fields.
     *
     * @param mRPArea
     *
     * @param material
     *
     * @param mRPPlanningSegmentType
     *
     * @param mRPPlant
     *
     * @param materialShortageProfile
     *
     * @param materialShortageProfileCount
     *
     * @param mRPPlanningSegmentNumber
     *
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MaterialCoverage
     *         MaterialCoverage} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MaterialCoverageByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaterialCoverageByKeyFluentHelper getMaterialCoverageByKey(
        final String material,
        final String materialShortageProfile,
        final String materialShortageProfileCount,
        final String mRPArea,
        final String mRPPlanningSegmentNumber,
        final String mRPPlanningSegmentType,
        final String mRPPlant );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem
     * SupplyDemandItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItem
     *         SupplyDemandItem} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.SupplyDemandItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplyDemandItemFluentHelper getAllSupplyDemandItem();

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial
     * MRPMaterial} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial MRPMaterial}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterialFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MRPMaterialFluentHelper getAllMRPMaterial();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial
     * MRPMaterial} entity using key fields.
     *
     * @param mRPArea
     *            MRP Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param material
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param mRPPlant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterial MRPMaterial}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialplanningdata.MRPMaterialByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MRPMaterialByKeyFluentHelper
        getMRPMaterialByKey( final String material, final String mRPPlant, final String mRPArea );

}
