/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.math.BigDecimal;
import java.time.LocalDateTime;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialprice.InventoryPriceChangeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialprice.batch.MaterialPriceServiceBatch;

/**
 * <p>
 * This service enables you to change the existing prices of your materials by importing new prices into the material
 * master. If stock exists for the material, a revaluation posting is generated. The revaluation posting indicates the
 * material ledger document number and year.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/93/18a0fe2606406dbaa49246c3d93bde/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_MATERIAL_VALUATION_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_MATERIAL_VALUATION_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Material Price Changes and Inventory Values Integration(SAP_COM_0147)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1ZT'>Managing Material Price Changes and Inventory
 * Values(1ZT)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/OZT'>Managing Material Price Changes and Inventory
 * Values(OZT)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Product</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface MaterialPriceService extends BatchService<MaterialPriceServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_MATERIAL_VALUATION_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    MaterialPriceService withServicePath( @Nonnull final String servicePath );

    /**
     * <p>
     * Creates a fluent helper for the <b>InventoryPriceChange</b> OData function import.
     * </p>
     *
     * @param valuationArea
     *            Valuation Area
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ValuationArea</b>
     *            </p>
     * @param material
     *            Material
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Material</b>
     *            </p>
     * @param materialPriceUnitQty
     *            Price unit
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Precision: 5, Scale: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaterialPriceUnitQty</b>
     *            </p>
     * @param inventoryValuationType
     *            Valuation Type
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>InventoryValuationType</b>
     *            </p>
     * @param currency
     *            Currency
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Currency</b>
     *            </p>
     * @param postingDate
     *            Posting Date
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PostingDate</b>
     *            </p>
     * @param currencyRole
     *            Crcy type/val.
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CurrencyRole</b>
     *            </p>
     * @param inventoryPrice
     *            Price
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Precision: 4, Scale: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>InventoryPrice</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>InventoryPriceChange</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialprice.InventoryPriceChangeFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InventoryPriceChangeFluentHelper inventoryPriceChange(
        @Nonnull final String currency,
        @Nonnull final String currencyRole,
        @Nonnull final String material,
        @Nonnull final BigDecimal inventoryPrice,
        @Nonnull final LocalDateTime postingDate,
        @Nonnull final BigDecimal materialPriceUnitQty,
        @Nonnull final String valuationArea,
        @Nonnull final String inventoryValuationType );

}
