/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.MaterialStockByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.MaterialStockFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.MatlStkInAcctModByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.MatlStkInAcctModFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.batch.MaterialStockDisplayServiceBatch;

/**
 * <p>
 *
 * This service enables you to retrieve material stock information using the OData protocol with filter data provided in
 * the payload. It can be consumed by external warehouse applications..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/f6/8f51a4dc2e46779877a10a301d9138/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_MATERIAL_STOCK_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_MATERIAL_STOCK_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Material Stock Integration(SAP_COM_0164)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BMC'>Core Inventory Management(BMC)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OMC'>Core Inventory Management(OMC)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Material Stock</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface MaterialStockDisplayService extends BatchService<MaterialStockDisplayServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_MATERIAL_STOCK_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    MaterialStockDisplayService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.MaterialStock
     * MaterialStock} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.MaterialStock
     *         MaterialStock} entities. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.MaterialStockFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaterialStockFluentHelper getAllMaterialStock();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.MaterialStock
     * MaterialStock} entity using key fields.
     *
     * @param material
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.MaterialStock
     *         MaterialStock} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.MaterialStockByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaterialStockByKeyFluentHelper getMaterialStockByKey( final String material );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.MatlStkInAcctMod
     * MatlStkInAcctMod} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.MatlStkInAcctMod
     *         MatlStkInAcctMod} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.MatlStkInAcctModFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MatlStkInAcctModFluentHelper getAllMatlStkInAcctMod();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.MatlStkInAcctMod
     * MatlStkInAcctMod} entity using key fields.
     *
     * @param material
     *            Material in Respect of Which Stock is Managed
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param wBSElementInternalID
     *            Valuated Sales Order Stock WBS Element
     *            <p>
     *            Constraints: Not nullable, Maximum length: 24
     *            </p>
     * @param inventorySpecialStockType
     *            Special Stock Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param supplier
     *            Supplier for Special Stock
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param batch
     *            Batch Number (Stock Identifier)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param storageLocation
     *            Storage Location
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param sDDocumentItem
     *            Sales Order Item of Valuated Sales Order Stock
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param inventoryStockType
     *            Stock Type of Goods Movement (Stock Identifier)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param sDDocument
     *            Sales order number of valuated sales order stock
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param customer
     *            Customer for Special Stock
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.MatlStkInAcctMod
     *         MatlStkInAcctMod} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialstockdisplay.MatlStkInAcctModByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MatlStkInAcctModByKeyFluentHelper getMatlStkInAcctModByKey(
        final String material,
        final String plant,
        final String storageLocation,
        final String batch,
        final String supplier,
        final String customer,
        final String wBSElementInternalID,
        final String sDDocument,
        final String sDDocumentItem,
        final String inventorySpecialStockType,
        final String inventoryStockType );

}
