/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.BOMItemCategoryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.BOMItemCategoryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.BOMItemCategoryTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.BOMItemCategoryTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.DeleteBOMHdrWithChangeNumberFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.DeleteBOMItemWithChangeNumberFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.batch.OrderBillOfMaterialServiceBatch;

/**
 * <p>
 *
 * The service contains either no header, one header, or multiple headers for the specified order bill of material and
 * zero or more items for each header.
 *
 * The required information is sent in the request as a payload to create, update, or delete order bill of material and
 * items, make appropriate checks for restricted values. If there are any issues when the order bill of material is
 * created, updated, or deleted, the system displays error messages in the response..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/02/d11a1c68bd451d91182e1e6ee5fb25/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_ORDER_BILL_OF_MATERIAL_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_ORDER_BILL_OF_MATERIAL_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.1.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Product Lifecycle Management - Master Data Integration(SAP_COM_0105)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BJE'>Make-to-Order Production - Finished Goods Sales and Final
 * Assembly(BJE)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/1NR'>Engineering Bill of Material - Versions
 * Management(1NR)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/1R3'>Engineering Bill of Material - Change Master
 * Management(1R3)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/3LO'>Change Manufacturing Bill of Material for
 * Production(3LO)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/3LP'>Mass Change Manufacturing Bill of Material
 * for Production(3LP)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Sales Bill Of Material</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface OrderBillOfMaterialService extends BatchService<OrderBillOfMaterialServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_ORDER_BILL_OF_MATERIAL_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    OrderBillOfMaterialService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.BOMItemCategory
     * BOMItemCategory} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.BOMItemCategory
     *         BOMItemCategory} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.BOMItemCategoryFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BOMItemCategoryFluentHelper getAllBOMItemCategory();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.BOMItemCategory
     * BOMItemCategory} entity using key fields.
     *
     * @param billOfMaterialItemCategory
     *            Item category (bill of material)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.BOMItemCategory
     *         BOMItemCategory} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.BOMItemCategoryByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BOMItemCategoryByKeyFluentHelper getBOMItemCategoryByKey( final String billOfMaterialItemCategory );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.BOMItemCategoryText
     * BOMItemCategoryText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.BOMItemCategoryText
     *         BOMItemCategoryText} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.BOMItemCategoryTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BOMItemCategoryTextFluentHelper getAllBOMItemCategoryText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.BOMItemCategoryText
     * BOMItemCategoryText} entity using key fields.
     *
     * @param billOfMaterialItemCategory
     *            Item category (bill of material)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.BOMItemCategoryText
     *         BOMItemCategoryText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.BOMItemCategoryTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BOMItemCategoryTextByKeyFluentHelper
        getBOMItemCategoryTextByKey( final String language, final String billOfMaterialItemCategory );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem
     * SalesOrderBOMItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem
     *         SalesOrderBOMItem} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderBOMItemFluentHelper getAllSalesOrderBOMItem();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem
     * SalesOrderBOMItem} entity using key fields.
     *
     * @param headerChangeDocument
     *            Change Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param material
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param billOfMaterialCategory
     *            BOM category
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param billOfMaterial
     *            Bill of Material
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param billOfMaterialVariant
     *            Alternative BOM
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param billOfMaterialItemNodeNumber
     *            BOM item node number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem
     *         SalesOrderBOMItem} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderBOMItemByKeyFluentHelper getSalesOrderBOMItemByKey(
        final String billOfMaterial,
        final String billOfMaterialCategory,
        final String billOfMaterialVariant,
        final String billOfMaterialItemNodeNumber,
        final String headerChangeDocument,
        final String material,
        final String plant );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem
     * SalesOrderBOMItem} entity and save it to the S/4HANA system.
     *
     * @param salesOrderBOMItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem
     *            SalesOrderBOMItem} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem
     *         SalesOrderBOMItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItemCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderBOMItemCreateFluentHelper createSalesOrderBOMItem( @Nonnull final SalesOrderBOMItem salesOrderBOMItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem
     * SalesOrderBOMItem} entity and save it to the S/4HANA system.
     *
     * @param salesOrderBOMItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem
     *            SalesOrderBOMItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem
     *         SalesOrderBOMItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderBOMItemUpdateFluentHelper updateSalesOrderBOMItem( @Nonnull final SalesOrderBOMItem salesOrderBOMItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem
     * SalesOrderBOMItem} entity in the S/4HANA system.
     *
     * @param salesOrderBOMItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem
     *            SalesOrderBOMItem} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem
     *         SalesOrderBOMItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItemDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderBOMItemDeleteFluentHelper deleteSalesOrderBOMItem( @Nonnull final SalesOrderBOMItem salesOrderBOMItem );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM
     * SalesOrderBOM} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM
     *         SalesOrderBOM} entities. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderBOMFluentHelper getAllSalesOrderBOM();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM
     * SalesOrderBOM} entity using key fields.
     *
     * @param material
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param billOfMaterialCategory
     *            BOM category
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param engineeringChangeDocument
     *            Change Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param billOfMaterial
     *            Bill of Material
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param billOfMaterialVariant
     *            Alternative BOM
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM
     *         SalesOrderBOM} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderBOMByKeyFluentHelper getSalesOrderBOMByKey(
        final String billOfMaterialCategory,
        final String billOfMaterial,
        final String billOfMaterialVariant,
        final String engineeringChangeDocument,
        final String material,
        final String plant );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM
     * SalesOrderBOM} entity and save it to the S/4HANA system.
     *
     * @param salesOrderBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM
     *            SalesOrderBOM} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM
     *         SalesOrderBOM} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderBOMCreateFluentHelper createSalesOrderBOM( @Nonnull final SalesOrderBOM salesOrderBOM );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM
     * SalesOrderBOM} entity and save it to the S/4HANA system.
     *
     * @param salesOrderBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM
     *            SalesOrderBOM} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM
     *         SalesOrderBOM} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderBOMUpdateFluentHelper updateSalesOrderBOM( @Nonnull final SalesOrderBOM salesOrderBOM );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM
     * SalesOrderBOM} entity in the S/4HANA system.
     *
     * @param salesOrderBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM
     *            SalesOrderBOM} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM
     *         SalesOrderBOM} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderBOMDeleteFluentHelper deleteSalesOrderBOM( @Nonnull final SalesOrderBOM salesOrderBOM );

    /**
     * <p>
     * Creates a fluent helper for the <b>DeleteBOMItemWithChangeNumber</b> OData function import.
     * </p>
     *
     * @param headerChangeDocument
     *            Change Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>HeaderChangeDocument</b>
     *            </p>
     * @param material
     *            Material
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Material</b>
     *            </p>
     * @param billOfMaterialCategory
     *            BOM category
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialCategory</b>
     *            </p>
     * @param engineeringChangeDocForEdit
     *            Change Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>EngineeringChangeDocForEdit</b>
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Plant</b>
     *            </p>
     * @param billOfMaterial
     *            Bill of Material
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterial</b>
     *            </p>
     * @param billOfMaterialVariant
     *            Alternative BOM
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialVariant</b>
     *            </p>
     * @param billOfMaterialItemNodeNumber
     *            Item node
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialItemNodeNumber</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>DeleteBOMItemWithChangeNumber</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.DeleteBOMItemWithChangeNumberFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DeleteBOMItemWithChangeNumberFluentHelper deleteBOMItemWithChangeNumber(
        @Nonnull final String billOfMaterial,
        @Nonnull final String billOfMaterialCategory,
        @Nonnull final String billOfMaterialVariant,
        @Nonnull final String billOfMaterialItemNodeNumber,
        @Nonnull final String headerChangeDocument,
        @Nonnull final String material,
        @Nonnull final String plant,
        @Nullable final String engineeringChangeDocForEdit );

    /**
     * <p>
     * Creates a fluent helper for the <b>DeleteBOMHdrWithChangeNumber</b> OData function import.
     * </p>
     *
     * @param material
     *            Material
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Material</b>
     *            </p>
     * @param billOfMaterialCategory
     *            BOM category
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialCategory</b>
     *            </p>
     * @param engineeringChangeDocForEdit
     *            Change Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>EngineeringChangeDocForEdit</b>
     *            </p>
     * @param engineeringChangeDocument
     *            Change Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>EngineeringChangeDocument</b>
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Plant</b>
     *            </p>
     * @param billOfMaterial
     *            Bill of Material
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterial</b>
     *            </p>
     * @param billOfMaterialVariant
     *            Alternative BOM
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialVariant</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>DeleteBOMHdrWithChangeNumber</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.DeleteBOMHdrWithChangeNumberFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DeleteBOMHdrWithChangeNumberFluentHelper deleteBOMHdrWithChangeNumber(
        @Nonnull final String billOfMaterialCategory,
        @Nonnull final String billOfMaterial,
        @Nonnull final String billOfMaterialVariant,
        @Nonnull final String engineeringChangeDocument,
        @Nonnull final String material,
        @Nonnull final String plant,
        @Nullable final String engineeringChangeDocForEdit );

}
