/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionComponentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionComponentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeaderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeaderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeaderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.batch.PackingInstructionServiceBatch;

/**
 * <p>
 * Packing instructions serve as templates for the creation of handling units.
 *
 * With this API, you can carry out the following operations: - Create a packing instruction comprising packaging
 * material and material to be packed. - Create a packing instruction including packaging material and reference
 * material. The reference material enables you to reuse one packing instruction for several materials. - Create a
 * packing instruction including subordinated packing instructions (multi-level packing instructions). - Retrieve header
 * information for a packing instruction. You can use filter criteria to retrieve information based on other selection
 * criteria, for example, material numbers. - Retrieve component information for a packing instruction, which contains
 * information about the packaging material and the material to be packed in the handling unit. - Retrieve texts in
 * different languages for a packing instruction.
 *
 * Note
 *
 * The following operations are available on the ***API Reference*** tab but are not supported by the API: -
 * &lt;TT&gt;POST
 * /PackingInstructionHeader(guid&#39;{PackingInstructionSystemUUID}&#39;)/to_PackingInstructionComponent&lt;/TT&gt; -
 * &lt;TT&gt;POST
 * /PackingInstructionHeader(guid&#39;{PackingInstructionSystemUUID}&#39;)/to_PackingInstructionText&lt;/TT&gt; .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/8c/64ea338f6a4c68b40f8dbcafde8954/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PACKINGINSTRUCTION?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PACKINGINSTRUCTION</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.1.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Packing Instruction Integration(SAP_COM_0399)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/4MM'>Handling Unit Management(4MM)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Packing Instruction</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface PackingInstructionService extends BatchService<PackingInstructionServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_PACKINGINSTRUCTION";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    PackingInstructionService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionComponent
     * PackingInstructionComponent} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionComponent
     *         PackingInstructionComponent} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionComponentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PackingInstructionComponentFluentHelper getAllPackingInstructionComponent();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionComponent
     * PackingInstructionComponent} entity using key fields.
     *
     * @param packingInstructionItemSystUUID
     *            Packing Instruction Component
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionComponent
     *         PackingInstructionComponent} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionComponentByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PackingInstructionComponentByKeyFluentHelper
        getPackingInstructionComponentByKey( final UUID packingInstructionItemSystUUID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader
     * PackingInstructionHeader} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader
     *         PackingInstructionHeader} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeaderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PackingInstructionHeaderFluentHelper getAllPackingInstructionHeader();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader
     * PackingInstructionHeader} entity using key fields.
     *
     * @param packingInstructionSystemUUID
     *            Unique internal packing object number
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader
     *         PackingInstructionHeader} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeaderByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PackingInstructionHeaderByKeyFluentHelper
        getPackingInstructionHeaderByKey( final UUID packingInstructionSystemUUID );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader
     * PackingInstructionHeader} entity and save it to the S/4HANA system.
     *
     * @param packingInstructionHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader
     *            PackingInstructionHeader} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader
     *         PackingInstructionHeader} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeaderCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PackingInstructionHeaderCreateFluentHelper
        createPackingInstructionHeader( @Nonnull final PackingInstructionHeader packingInstructionHeader );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionText
     * PackingInstructionText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionText
     *         PackingInstructionText} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PackingInstructionTextFluentHelper getAllPackingInstructionText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionText
     * PackingInstructionText} entity using key fields.
     *
     * @param packingInstructionSystemUUID
     *            Packing Instruction Number
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionText
     *         PackingInstructionText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PackingInstructionTextByKeyFluentHelper
        getPackingInstructionTextByKey( final String language, final UUID packingInstructionSystemUUID );

}
