/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.batch.PaymentAdviceServiceBatch;

/**
 * <p>
 *
 * You can use this inbound synchronous service to create, read, update, and delete payment advices related to a
 * customer or a supplier. It is based on the OData protocol and can be consumed in SAP Fiori apps and other user
 * interfaces. The service can be used with payment advices of any supported type..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/f8/f29bb9d08a418d936ce5de8a78b33f/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PAYMENT_ADVICE_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PAYMENT_ADVICE_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Finance - Payment Advice Integration(SAP_COM_0331)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/J59'>Accounts Receivable(J59)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O59'>Accounts Receivable(O59)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Payment Advice</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface PaymentAdviceService extends BatchService<PaymentAdviceServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_PAYMENT_ADVICE_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    PaymentAdviceService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice
     * PaymentAdvice} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice PaymentAdvice}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PaymentAdviceFluentHelper getAllPaymentAdvice();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice
     * PaymentAdvice} entity using key fields.
     *
     * @param companyCode
     *            Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param paymentAdviceAccountType
     *            Payment Advice Account Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param paymentAdvice
     *            Payment Advice Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 16
     *            </p>
     * @param paymentAdviceAccount
     *            Account Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice PaymentAdvice}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PaymentAdviceByKeyFluentHelper getPaymentAdviceByKey(
        final String companyCode,
        final String paymentAdviceAccountType,
        final String paymentAdviceAccount,
        final String paymentAdvice );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice
     * PaymentAdvice} entity and save it to the S/4HANA system.
     *
     * @param paymentAdvice
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice PaymentAdvice}
     *            entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice PaymentAdvice}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PaymentAdviceCreateFluentHelper createPaymentAdvice( @Nonnull final PaymentAdvice paymentAdvice );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice
     * PaymentAdvice} entity and save it to the S/4HANA system.
     *
     * @param paymentAdvice
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice PaymentAdvice}
     *            entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice PaymentAdvice}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PaymentAdviceUpdateFluentHelper updatePaymentAdvice( @Nonnull final PaymentAdvice paymentAdvice );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice
     * PaymentAdvice} entity in the S/4HANA system.
     *
     * @param paymentAdvice
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice PaymentAdvice}
     *            entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice PaymentAdvice}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PaymentAdviceDeleteFluentHelper deletePaymentAdvice( @Nonnull final PaymentAdvice paymentAdvice );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem
     * PaymentAdviceItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem
     *         PaymentAdviceItem} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PaymentAdviceItemFluentHelper getAllPaymentAdviceItem();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem
     * PaymentAdviceItem} entity using key fields.
     *
     * @param companyCode
     *            Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param paymentAdviceAccountType
     *            Payment Advice Account Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param paymentAdvice
     *            Payment Advice Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 16
     *            </p>
     * @param paymentAdviceAccount
     *            Account Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param paymentAdviceItem
     *            Payment Advice Line Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem
     *         PaymentAdviceItem} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PaymentAdviceItemByKeyFluentHelper getPaymentAdviceItemByKey(
        final String companyCode,
        final String paymentAdviceAccountType,
        final String paymentAdviceAccount,
        final String paymentAdvice,
        final String paymentAdviceItem );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem
     * PaymentAdviceItem} entity and save it to the S/4HANA system.
     *
     * @param paymentAdviceItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem
     *            PaymentAdviceItem} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem
     *         PaymentAdviceItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItemCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PaymentAdviceItemCreateFluentHelper createPaymentAdviceItem( @Nonnull final PaymentAdviceItem paymentAdviceItem );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem
     * PaymentAdviceItem} entity and save it to the S/4HANA system.
     *
     * @param paymentAdviceItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem
     *            PaymentAdviceItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem
     *         PaymentAdviceItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PaymentAdviceItemUpdateFluentHelper updatePaymentAdviceItem( @Nonnull final PaymentAdviceItem paymentAdviceItem );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem
     * PaymentAdviceItem} entity in the S/4HANA system.
     *
     * @param paymentAdviceItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem
     *            PaymentAdviceItem} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem
     *         PaymentAdviceItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItemDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PaymentAdviceItemDeleteFluentHelper deletePaymentAdviceItem( @Nonnull final PaymentAdviceItem paymentAdviceItem );

}
