/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentmethodvalidation.batch.PaymentMethodValidationServiceBatch;

/**
 * <p>
 *
 * This service makes the following checks: First, whether the payment method used in SAP SuccessFactors Employee
 * Central has been mapped with that used in SAP S/4HANA Cloud. The mapping is defined in the configuration step Map
 * Payment Methods Used in SAP SuccessFactors Employee Central under Finance -&amp;gt; Accounts Payable -&amp;gt;
 * Automatic Payments in Configure Your Solution, which is part of the Manage Your Solution app. Second, whether values
 * for the following fields exist when requested: IBAN, SWIFT code, Bank account number, Bank key. Whether any of these
 * fields are requested is defined in the configuration step Set Up Payment Methods per Country for Payment Transactions
 * under Finance -&amp;gt; Accounts Payable -&amp;gt; Automatic Payments in Configure Your Solution. Third, whether the
 * country for the employee or the country for the bank of the employee in SAP SuccessFactors Employee Central can be
 * foreign. This setting is defined in the configuration step Set Up Payment Methods per Company Code for Payment
 * Transactions under Finance -&amp;gt; Accounts Payable -&amp;gt; Automatic Payments in Configure Your Solution. If
 * there are any issues during the validation, the system displays warning messages in the response..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/01/8da580c6a74756956dee413ed9939d/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PAYMENT_METHOD_VALIDATION_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PAYMENT_METHOD_VALIDATION_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>SuccessFactors Payment Options Check Integration(SAP_COM_0700)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/J60'>Accounts Payable(J60)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O60'>Accounts Payable(O60)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4AJ'>Financial Master Data for SAP SuccessFactors Employee
 * Central(4AJ)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Payment Medium</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface PaymentMethodValidationService extends BatchService<PaymentMethodValidationServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_PAYMENT_METHOD_VALIDATION_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    PaymentMethodValidationService withServicePath( @Nonnull final String servicePath );

}
