/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersCompnElmntCostAssgmtByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersCompnElmntCostAssgmtFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersonnelCompensationElementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersonnelCompensationElementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.batch.PersonnelSettlementDocumentServiceBatch;

/**
 * <p>
 *
 * The service enables you to read the transactional data of personnel settlement documents.
 *
 * It is based on the OData protocol and it is intended for consumption in background by remote interfaces for
 * application integration scenarios.
 *
 * In every API call, you can make use of the following operations: - You can retrieve an individual personnel
 * settlement document by document number - You can retrieve multiple documents by filtering on the available properties
 * - You can request additional information on the assignment of settled amounts to cost centers - You can retrieve
 * delta information by filtering on date and time to only get documents which have been created after that point in
 * time.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/f1/96aa7b945547b99f58896ee3d3f8d4/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PERS_SETTLMT_DOC?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PERS_SETTLMT_DOC</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.1</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Logistics - Employee Central Personnel Settlement Document Integration(SAP_COM_0469)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3TD'>Internal Commissions Settlement with SAP Sales
 * Cloud(3TD)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Personnel Settlement Document</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface PersonnelSettlementDocumentService extends BatchService<PersonnelSettlementDocumentServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_PERS_SETTLMT_DOC";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    PersonnelSettlementDocumentService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersCompnElmntCostAssgmt
     * PersCompnElmntCostAssgmt} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersCompnElmntCostAssgmt
     *         PersCompnElmntCostAssgmt} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersCompnElmntCostAssgmtFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PersCompnElmntCostAssgmtFluentHelper getAllPersCompnElmntCostAssgmt();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersCompnElmntCostAssgmt
     * PersCompnElmntCostAssgmt} entity using key fields.
     *
     * @param personnelSettlementDocument
     *            Personnel Settlement Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param costCenter
     *            Cost Center
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param controllingArea
     *            Controlling Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersCompnElmntCostAssgmt
     *         PersCompnElmntCostAssgmt} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersCompnElmntCostAssgmtByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PersCompnElmntCostAssgmtByKeyFluentHelper getPersCompnElmntCostAssgmtByKey(
        final String personnelSettlementDocument,
        final String controllingArea,
        final String costCenter );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersonnelCompensationElement
     * PersonnelCompensationElement} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersonnelCompensationElement
     *         PersonnelCompensationElement} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersonnelCompensationElementFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PersonnelCompensationElementFluentHelper getAllPersonnelCompensationElement();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersonnelCompensationElement
     * PersonnelCompensationElement} entity using key fields.
     *
     * @param personnelSettlementDocument
     *            Personnel Settlement Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersonnelCompensationElement
     *         PersonnelCompensationElement} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersonnelCompensationElementByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PersonnelCompensationElementByKeyFluentHelper
        getPersonnelCompensationElementByKey( final String personnelSettlementDocument );

}
