/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype.PhaseRelationshipTypeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype.PhaseRelationshipTypeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype.PhaseRelationshipTypeTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype.PhaseRelationshipTypeTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype.batch.PhaseRelationshipTypeServiceBatch;

/**
 * <p>
 *
 * Relationships link the start or end of a preceding phase with the start or end of a succeeding phase. The
 * relationship type specifies how the phase dates are linked with each other. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/3e/f14e1f076343a4ae9af4692d2633fa/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_MSTRRCPPHSE_RELSHPTYPE?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_MSTRRCPPHSE_RELSHPTYPE</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.1</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Production Planning Master Data Integration(SAP_COM_0519)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3W3'>Third-Party Shop Floor Execution - Process Industry(3W3)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3W4'>Third-Party Shop Floor Execution - Discrete
 * Industry(3W4)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Master Recipe</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface PhaseRelationshipTypeService extends BatchService<PhaseRelationshipTypeServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_MSTRRCPPHSE_RELSHPTYPE";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    PhaseRelationshipTypeService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype.PhaseRelationshipType
     * PhaseRelationshipType} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype.PhaseRelationshipType
     *         PhaseRelationshipType} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype.PhaseRelationshipTypeFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PhaseRelationshipTypeFluentHelper getAllPhaseRelationshipType();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype.PhaseRelationshipType
     * PhaseRelationshipType} entity using key fields.
     *
     * @param phaseRelationshipTypeKey
     *
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype.PhaseRelationshipType
     *         PhaseRelationshipType} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype.PhaseRelationshipTypeByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PhaseRelationshipTypeByKeyFluentHelper getPhaseRelationshipTypeByKey( final String phaseRelationshipTypeKey );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype.PhaseRelationshipTypeText
     * PhaseRelationshipTypeText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype.PhaseRelationshipTypeText
     *         PhaseRelationshipTypeText} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype.PhaseRelationshipTypeTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PhaseRelationshipTypeTextFluentHelper getAllPhaseRelationshipTypeText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype.PhaseRelationshipTypeText
     * PhaseRelationshipTypeText} entity using key fields.
     *
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param phaseRelationshipTypeKey
     *
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype.PhaseRelationshipTypeText
     *         PhaseRelationshipTypeText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype.PhaseRelationshipTypeTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PhaseRelationshipTypeTextByKeyFluentHelper
        getPhaseRelationshipTypeTextByKey( final String language, final String phaseRelationshipTypeKey );

}
