/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.math.BigDecimal;
import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.InitiateRecountFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.InitiateRecountOnItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeaderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeaderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeaderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PostDifferencesFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PostDifferencesOnItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.SerialNumberPhysInventoryDoc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.SerialNumberPhysInventoryDocByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.SerialNumberPhysInventoryDocFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.SerialNumberPhysInventoryDocUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.batch.PhysicalInventoryDocumentServiceBatch;

/**
 * <p>
 *
 * You can count items and post differences on both document and item level. The service can be consumed by external
 * systems..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/58/361658745b1f60e10000000a44147b/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PHYSICAL_INVENTORY_DOC_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PHYSICAL_INVENTORY_DOC_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Physical Inventory Document Integration(SAP_COM_0107)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BML'>Physical Inventory - Inventory Count and Adjustment(BML)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OML'>Physical Inventory - Inventory Count and Adjustment(OML)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Physical Inventory Document</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface PhysicalInventoryDocumentService extends BatchService<PhysicalInventoryDocumentServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_PHYSICAL_INVENTORY_DOC_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    PhysicalInventoryDocumentService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeader
     * PhysInventoryDocHeader} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeader
     *         PhysInventoryDocHeader} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeaderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PhysInventoryDocHeaderFluentHelper getAllPhysInventoryDocHeader();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeader
     * PhysInventoryDocHeader} entity using key fields.
     *
     * @param fiscalYear
     *            Fiscal Year
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param physicalInventoryDocument
     *            Physical Inventory Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeader
     *         PhysInventoryDocHeader} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeaderByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PhysInventoryDocHeaderByKeyFluentHelper
        getPhysInventoryDocHeaderByKey( final String fiscalYear, final String physicalInventoryDocument );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeader
     * PhysInventoryDocHeader} entity and save it to the S/4HANA system.
     *
     * @param physInventoryDocHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeader
     *            PhysInventoryDocHeader} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeader
     *         PhysInventoryDocHeader} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeaderCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PhysInventoryDocHeaderCreateFluentHelper
        createPhysInventoryDocHeader( @Nonnull final PhysInventoryDocHeader physInventoryDocHeader );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem
     * PhysInventoryDocItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem
     *         PhysInventoryDocItem} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PhysInventoryDocItemFluentHelper getAllPhysInventoryDocItem();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem
     * PhysInventoryDocItem} entity using key fields.
     *
     * @param physicalInventoryDocumentItem
     *            Physical Inventory Item Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param fiscalYear
     *            Fiscal Year
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param physicalInventoryDocument
     *            Physical Inventory Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem
     *         PhysInventoryDocItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PhysInventoryDocItemByKeyFluentHelper getPhysInventoryDocItemByKey(
        final String fiscalYear,
        final String physicalInventoryDocument,
        final String physicalInventoryDocumentItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem
     * PhysInventoryDocItem} entity and save it to the S/4HANA system.
     *
     * @param physInventoryDocItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem
     *            PhysInventoryDocItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem
     *         PhysInventoryDocItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PhysInventoryDocItemUpdateFluentHelper
        updatePhysInventoryDocItem( @Nonnull final PhysInventoryDocItem physInventoryDocItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.SerialNumberPhysInventoryDoc
     * SerialNumberPhysInventoryDoc} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.SerialNumberPhysInventoryDoc
     *         SerialNumberPhysInventoryDoc} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.SerialNumberPhysInventoryDocFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SerialNumberPhysInventoryDocFluentHelper getAllSerialNumberPhysInventoryDoc();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.SerialNumberPhysInventoryDoc
     * SerialNumberPhysInventoryDoc} entity using key fields.
     *
     * @param physicalInventoryDocumentItem
     *            Line Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param serialNumberPhysicalInvtryType
     *            Serial Number Physical Inventory Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param equipment
     *            Equipment Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param fiscalYear
     *            Fiscal Year
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param physicalInventoryDocument
     *            Physical Inventory Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.SerialNumberPhysInventoryDoc
     *         SerialNumberPhysInventoryDoc} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.SerialNumberPhysInventoryDocByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SerialNumberPhysInventoryDocByKeyFluentHelper getSerialNumberPhysInventoryDocByKey(
        final String equipment,
        final String fiscalYear,
        final String physicalInventoryDocument,
        final String physicalInventoryDocumentItem,
        final String serialNumberPhysicalInvtryType );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.SerialNumberPhysInventoryDoc
     * SerialNumberPhysInventoryDoc} entity and save it to the S/4HANA system.
     *
     * @param serialNumberPhysInventoryDoc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.SerialNumberPhysInventoryDoc
     *            SerialNumberPhysInventoryDoc} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.SerialNumberPhysInventoryDoc
     *         SerialNumberPhysInventoryDoc} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.SerialNumberPhysInventoryDocUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SerialNumberPhysInventoryDocUpdateFluentHelper
        updateSerialNumberPhysInventoryDoc( @Nonnull final SerialNumberPhysInventoryDoc serialNumberPhysInventoryDoc );

    /**
     * <p>
     * Creates a fluent helper for the <b>PostDifferences</b> OData function import.
     * </p>
     *
     * @param postingThresholdValue
     *            Threshold Value
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 14, Scale: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PostingThresholdValue</b>
     *            </p>
     * @param postingDate
     *            Posting Date
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PostingDate</b>
     *            </p>
     * @param fiscalYear
     *            Fiscal Year
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>FiscalYear</b>
     *            </p>
     * @param physicalInventoryDocument
     *            Phys. Inventory Doc.
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PhysicalInventoryDocument</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>PostDifferences</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PostDifferencesFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PostDifferencesFluentHelper postDifferences(
        @Nullable final BigDecimal postingThresholdValue,
        @Nullable final LocalDateTime postingDate,
        @Nonnull final String physicalInventoryDocument,
        @Nonnull final String fiscalYear );

    /**
     * <p>
     * Creates a fluent helper for the <b>PostDifferencesOnItem</b> OData function import.
     * </p>
     *
     * @param physicalInventoryDocumentItem
     *            Item
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PhysicalInventoryDocumentItem</b>
     *            </p>
     * @param material
     *            Material
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Material</b>
     *            </p>
     * @param reasonForPhysInvtryDifference
     *            Reason f. Diff.
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ReasonForPhysInvtryDifference</b>
     *            </p>
     * @param batch
     *            Batch
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Batch</b>
     *            </p>
     * @param postingDate
     *            Posting Date
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PostingDate</b>
     *            </p>
     * @param fiscalYear
     *            Fiscal Year
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>FiscalYear</b>
     *            </p>
     * @param physicalInventoryDocument
     *            Phys. Inventory Doc.
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PhysicalInventoryDocument</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>PostDifferencesOnItem</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PostDifferencesOnItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PostDifferencesOnItemFluentHelper postDifferencesOnItem(
        @Nonnull final String physicalInventoryDocumentItem,
        @Nonnull final String material,
        @Nonnull final String physicalInventoryDocument,
        @Nonnull final String fiscalYear,
        @Nullable final String batch,
        @Nullable final String reasonForPhysInvtryDifference,
        @Nullable final LocalDateTime postingDate );

    /**
     * <p>
     * Creates a fluent helper for the <b>InitiateRecount</b> OData function import.
     * </p>
     *
     * @param documentDate
     *            Document Date
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DocumentDate</b>
     *            </p>
     * @param physInvtryDocHasQtySnapshot
     *            Freeze Book Invtry
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PhysInvtryDocHasQtySnapshot</b>
     *            </p>
     * @param postingThresholdValue
     *            Threshold Value
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 14, Scale: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PostingThresholdValue</b>
     *            </p>
     * @param physInventoryPlannedCountDate
     *            Planned Count Date
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PhysInventoryPlannedCountDate</b>
     *            </p>
     * @param postingIsBlockedForPhysInvtry
     *            Phys. Inv. Block
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PostingIsBlockedForPhysInvtry</b>
     *            </p>
     * @param fiscalYear
     *            Fiscal Year
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>FiscalYear</b>
     *            </p>
     * @param physicalInventoryNumber
     *            Phys. inventory no.
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 16
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PhysicalInventoryNumber</b>
     *            </p>
     * @param physicalInventoryDocument
     *            Phys. Inventory Doc.
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PhysicalInventoryDocument</b>
     *            </p>
     * @param physInventoryReferenceNumber
     *            Phys. inventory ref.
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 16
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PhysInventoryReferenceNumber</b>
     *            </p>
     * @param physicalInventoryDocumentDesc
     *            Description
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PhysicalInventoryDocumentDesc</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>InitiateRecount</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.InitiateRecountFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InitiateRecountFluentHelper initiateRecount(
        @Nonnull final String physicalInventoryDocument,
        @Nonnull final String fiscalYear,
        @Nullable final LocalDateTime physInventoryPlannedCountDate,
        @Nullable final LocalDateTime documentDate,
        @Nullable final String physicalInventoryNumber,
        @Nullable final String physInventoryReferenceNumber,
        @Nullable final String physicalInventoryDocumentDesc,
        @Nullable final BigDecimal postingThresholdValue,
        @Nullable final Boolean physInvtryDocHasQtySnapshot,
        @Nullable final Boolean postingIsBlockedForPhysInvtry );

    /**
     * <p>
     * Creates a fluent helper for the <b>InitiateRecountOnItem</b> OData function import.
     * </p>
     *
     * @param documentDate
     *            Document Date
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DocumentDate</b>
     *            </p>
     * @param physicalInventoryDocumentItem
     *            Item
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PhysicalInventoryDocumentItem</b>
     *            </p>
     * @param physInvtryDocHasQtySnapshot
     *            Freeze Book Invtry
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PhysInvtryDocHasQtySnapshot</b>
     *            </p>
     * @param physInventoryPlannedCountDate
     *            Planned Count Date
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PhysInventoryPlannedCountDate</b>
     *            </p>
     * @param postingIsBlockedForPhysInvtry
     *            Phys. Inv. Block
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PostingIsBlockedForPhysInvtry</b>
     *            </p>
     * @param fiscalYear
     *            Fiscal Year
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>FiscalYear</b>
     *            </p>
     * @param physicalInventoryNumber
     *            Phys. inventory no.
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 16
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PhysicalInventoryNumber</b>
     *            </p>
     * @param physicalInventoryDocument
     *            Phys. Inventory Doc.
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PhysicalInventoryDocument</b>
     *            </p>
     * @param physInventoryReferenceNumber
     *            Phys. inventory ref.
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 16
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PhysInventoryReferenceNumber</b>
     *            </p>
     * @param physicalInventoryDocumentDesc
     *            Description
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PhysicalInventoryDocumentDesc</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>InitiateRecountOnItem</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.InitiateRecountOnItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InitiateRecountOnItemFluentHelper initiateRecountOnItem(
        @Nonnull final String physicalInventoryDocument,
        @Nonnull final String fiscalYear,
        @Nonnull final String physicalInventoryDocumentItem,
        @Nullable final LocalDateTime physInventoryPlannedCountDate,
        @Nullable final LocalDateTime documentDate,
        @Nullable final String physicalInventoryNumber,
        @Nullable final String physInventoryReferenceNumber,
        @Nullable final String physicalInventoryDocumentDesc,
        @Nullable final Boolean physInvtryDocHasQtySnapshot,
        @Nullable final Boolean postingIsBlockedForPhysInvtry );

}
