/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;
import java.time.LocalTime;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacityByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacityFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponentCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponentDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponentUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderScheduleFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.SchedulePlannedOrderOperationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.batch.PlannedOrderServiceBatch;

/**
 * <p>
 *
 * The service contains planned order header, planned order capacity and planned order components. The information is
 * sent in the request as a payload. You can read, create, change and delete components of orders and also use this
 * service to schedule planned order operations. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/43/ae2e5876b4a107e10000000a441470/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PLANNED_ORDERS?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PLANNED_ORDERS</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Production Planning Integration(SAP_COM_0104)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BJ5'> Make-to-Stock Production - Discrete Manufacturing(BJ5)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BJ8'>Make-to-Stock - Process Manufacturing Based on Process
 * Order(BJ8)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/J44'>Material Requirements Planning(J44)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O44'>Material Requirements Planning(O44)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Planned Order</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface PlannedOrderService extends BatchService<PlannedOrderServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_PLANNED_ORDERS";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    PlannedOrderService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder PlannedOrder}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder PlannedOrder}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PlannedOrderFluentHelper getAllPlannedOrder();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder PlannedOrder}
     * entity using key fields.
     *
     * @param plannedOrder
     *            Planned Order
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder PlannedOrder} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PlannedOrderByKeyFluentHelper getPlannedOrderByKey( final String plannedOrder );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder PlannedOrder}
     * entity and save it to the S/4HANA system.
     *
     * @param plannedOrder
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder PlannedOrder}
     *            entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder PlannedOrder}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PlannedOrderCreateFluentHelper createPlannedOrder( @Nonnull final PlannedOrder plannedOrder );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder
     * PlannedOrder} entity and save it to the S/4HANA system.
     *
     * @param plannedOrder
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder PlannedOrder}
     *            entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder PlannedOrder}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PlannedOrderUpdateFluentHelper updatePlannedOrder( @Nonnull final PlannedOrder plannedOrder );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder
     * PlannedOrder} entity in the S/4HANA system.
     *
     * @param plannedOrder
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder PlannedOrder}
     *            entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder PlannedOrder}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PlannedOrderDeleteFluentHelper deletePlannedOrder( @Nonnull final PlannedOrder plannedOrder );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacity
     * PlannedOrderCapacity} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacity
     *         PlannedOrderCapacity} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacityFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PlannedOrderCapacityFluentHelper getAllPlannedOrderCapacity();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacity
     * PlannedOrderCapacity} entity using key fields.
     *
     * @param capacityRequirementItem
     *            Capacity Requirement Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param capacityRequirement
     *            ID of the Capacity Requirements Record
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param capacityRqmtItemCapacity
     *            Individual Capacity of a Capacity Requirement Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacity
     *         PlannedOrderCapacity} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacityByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PlannedOrderCapacityByKeyFluentHelper getPlannedOrderCapacityByKey(
        final String capacityRequirement,
        final String capacityRequirementItem,
        final String capacityRqmtItemCapacity );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent
     * PlannedOrderComponent} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent
     *         PlannedOrderComponent} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PlannedOrderComponentFluentHelper getAllPlannedOrderComponent();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent
     * PlannedOrderComponent} entity using key fields.
     *
     * @param reservationItem
     *            Reservation Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param reservation
     *            Number of reservation/dependent requirements
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent
     *         PlannedOrderComponent} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponentByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PlannedOrderComponentByKeyFluentHelper
        getPlannedOrderComponentByKey( final String reservation, final String reservationItem );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent
     * PlannedOrderComponent} entity and save it to the S/4HANA system.
     *
     * @param plannedOrderComponent
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent
     *            PlannedOrderComponent} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent
     *         PlannedOrderComponent} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponentCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PlannedOrderComponentCreateFluentHelper
        createPlannedOrderComponent( @Nonnull final PlannedOrderComponent plannedOrderComponent );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent
     * PlannedOrderComponent} entity and save it to the S/4HANA system.
     *
     * @param plannedOrderComponent
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent
     *            PlannedOrderComponent} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent
     *         PlannedOrderComponent} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponentUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PlannedOrderComponentUpdateFluentHelper
        updatePlannedOrderComponent( @Nonnull final PlannedOrderComponent plannedOrderComponent );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent
     * PlannedOrderComponent} entity in the S/4HANA system.
     *
     * @param plannedOrderComponent
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent
     *            PlannedOrderComponent} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent
     *         PlannedOrderComponent} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponentDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PlannedOrderComponentDeleteFluentHelper
        deletePlannedOrderComponent( @Nonnull final PlannedOrderComponent plannedOrderComponent );

    /**
     * <p>
     * Creates a fluent helper for the <b>PlannedOrderSchedule</b> OData function import.
     * </p>
     *
     * @param plannedOrder
     *            Planned Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PlannedOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>PlannedOrderSchedule</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderScheduleFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PlannedOrderScheduleFluentHelper plannedOrderSchedule( @Nonnull final String plannedOrder );

    /**
     * <p>
     * Creates a fluent helper for the <b>SchedulePlannedOrderOperation</b> OData function import.
     * </p>
     *
     * @param capacityRequirementItem
     *            Counter
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CapacityRequirementItem</b>
     *            </p>
     * @param opSchedldStartDate
     *            Latest Start Date
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OpSchedldStartDate</b>
     *            </p>
     * @param capacityRequirement
     *            Capacity Requirement
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CapacityRequirement</b>
     *            </p>
     * @param plannedOrder
     *            Planned Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PlannedOrder</b>
     *            </p>
     * @param capacityRqmtItemCapacity
     *            Counter
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CapacityRqmtItemCapacity</b>
     *            </p>
     * @param opSchedulingStrategy
     *            Component of the Version Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OpSchedulingStrategy</b>
     *            </p>
     * @param opSchedulingStatus
     *            Status
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OpSchedulingStatus</b>
     *            </p>
     * @param opSchedulingMode
     *            Scheduling type
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OpSchedulingMode</b>
     *            </p>
     * @param opSchedldStartTime
     *            Latest Start Time
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OpSchedldStartTime</b>
     *            </p>
     * @param opSchedldEndDate
     *            Latest End Date
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OpSchedldEndDate</b>
     *            </p>
     * @param opSchedldEndTime
     *            Latest End Time
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OpSchedldEndTime</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>SchedulePlannedOrderOperation</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.SchedulePlannedOrderOperationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SchedulePlannedOrderOperationFluentHelper schedulePlannedOrderOperation(
        @Nonnull final String plannedOrder,
        @Nonnull final String capacityRequirement,
        @Nonnull final String capacityRequirementItem,
        @Nonnull final String capacityRqmtItemCapacity,
        @Nullable final LocalDateTime opSchedldStartDate,
        @Nullable final LocalTime opSchedldStartTime,
        @Nullable final LocalDateTime opSchedldEndDate,
        @Nullable final LocalTime opSchedldEndTime,
        @Nonnull final String opSchedulingMode,
        @Nullable final String opSchedulingStatus,
        @Nonnull final String opSchedulingStrategy );

}
