/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatch;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxClearingByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxClearingFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.batch.PostLockboxServiceBatch;

/**
 * <p>
 *
 * This service creates lockbox batches, lockbox batch items and clearing information. The lockbox batch root entity and
 * associated entities are sent in the POST request as a payload. After the lockbox batches are created, they are posted
 * immediately and can be processed further using the Manage Lockbox Batches app..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/4b/61ff6992fa4567a9c29766c157ee24/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_LOCKBOXPOST_IN?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_LOCKBOXPOST_IN</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Finance - Accounts Receivable Lockbox Integration(SAP_COM_0759)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1JT'>Lockbox(1JT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OJT'>Lockbox(OJT)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Accounts Receivable Lockbox</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface PostLockboxService extends BatchService<PostLockboxServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_LOCKBOXPOST_IN";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    PostLockboxService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatch LockboxBatch}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatch LockboxBatch}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LockboxBatchFluentHelper getAllLockboxBatch();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatch LockboxBatch}
     * entity using key fields.
     *
     * @param lockboxBatch
     *            Batch number (bundle number)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param lockboxBatchInternalKey
     *            Short Key for Bank Statement (Surrogate Key)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatch LockboxBatch} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LockboxBatchByKeyFluentHelper
        getLockboxBatchByKey( final String lockboxBatchInternalKey, final String lockboxBatch );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatch LockboxBatch}
     * entity and save it to the S/4HANA system.
     *
     * @param lockboxBatch
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatch LockboxBatch}
     *            entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatch LockboxBatch} entity.
     *         To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LockboxBatchCreateFluentHelper createLockboxBatch( @Nonnull final LockboxBatch lockboxBatch );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItem
     * LockboxBatchItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItem LockboxBatchItem}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LockboxBatchItemFluentHelper getAllLockboxBatchItem();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItem
     * LockboxBatchItem} entity using key fields.
     *
     * @param lockboxBatch
     *            Batch number (bundle number)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param lockboxBatchInternalKey
     *            Short Key for Bank Statement (Surrogate Key)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param lockboxBatchItem
     *            Memo Record Number (Line Item Number in Bank Statement)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItem LockboxBatchItem}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LockboxBatchItemByKeyFluentHelper getLockboxBatchItemByKey(
        final String lockboxBatchInternalKey,
        final String lockboxBatchItem,
        final String lockboxBatch );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItem
     * LockboxBatchItem} entity and save it to the S/4HANA system.
     *
     * @param lockboxBatchItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItem
     *            LockboxBatchItem} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItem LockboxBatchItem}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItemCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LockboxBatchItemCreateFluentHelper createLockboxBatchItem( @Nonnull final LockboxBatchItem lockboxBatchItem );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxClearing
     * LockboxClearing} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxClearing LockboxClearing}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxClearingFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LockboxClearingFluentHelper getAllLockboxClearing();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxClearing
     * LockboxClearing} entity using key fields.
     *
     * @param companyCode
     *            Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param paymentAdviceAccountType
     *            Payment Advice Account Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param paymentAdvice
     *            Payment Advice Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 16
     *            </p>
     * @param paymentAdviceAccount
     *            Account Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param paymentAdviceItem
     *            Payment Advice Line Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxClearing LockboxClearing}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxClearingByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LockboxClearingByKeyFluentHelper getLockboxClearingByKey(
        final String paymentAdvice,
        final String paymentAdviceItem,
        final String paymentAdviceAccount,
        final String paymentAdviceAccountType,
        final String companyCode );

}
