/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.Get_IcmCacheFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.Get_PrintOptionsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.Get_PrintQueuesOfUserFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.Get_QItem_DocumentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.RetrieveNextQueueItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.Set_PrintParameterFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.Set_QItem_StatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.batch.PrintQueueItemServiceBatch;

/**
 * <p>
 * This service enables you to retrieve print queue items of all print queues of a specified user. The status of the
 * print queue items can be modified according to the performed processing in the external application.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com/viewer/e8c6621864654025997c9daea001a778/latest/en-US/26bbee4468f34f06958417e7b70f088b.html'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_CLOUD_PRINT_PULL_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_CLOUD_PRINT_PULL_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Printing - Pull Integration (SAP_COM_0466)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1LQ'>Output Management (‏1LQ‏)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>Basic</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface PrintQueueItemService extends BatchService<PrintQueueItemServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_CLOUD_PRINT_PULL_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    PrintQueueItemService withServicePath( @Nonnull final String servicePath );

    /**
     * <p>
     * Creates a fluent helper for the <b>RetrieveNextQueueItem</b> OData function import.
     * </p>
     *
     * @param qname
     *            Constraints: Not nullable, Maximum length: 32
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Qname</b>
     *            </p>
     * @param language
     *            Constraints: Not nullable, Maximum length: 40
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Language</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>RetrieveNextQueueItem</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.RetrieveNextQueueItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RetrieveNextQueueItemFluentHelper
        retrieveNextQueueItem( @Nonnull final String qname, @Nonnull final String language );

    /**
     * <p>
     * Creates a fluent helper for the <b>Get_IcmCache</b> OData function import.
     * </p>
     *
     * @return A fluent helper object that will execute the <b>Get_IcmCache</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.Get_IcmCacheFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    Get_IcmCacheFluentHelper get_IcmCache();

    /**
     * <p>
     * Creates a fluent helper for the <b>Get_PrintQueuesOfUser</b> OData function import.
     * </p>
     *
     * @return A fluent helper object that will execute the <b>Get_PrintQueuesOfUser</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.Get_PrintQueuesOfUserFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    Get_PrintQueuesOfUserFluentHelper get_PrintQueuesOfUser();

    /**
     * <p>
     * Creates a fluent helper for the <b>Set_QItem_Status</b> OData function import.
     * </p>
     *
     * @param status_desc
     *            Constraints: Not nullable, Maximum length: 80
     *            <p>
     *            Original parameter name from the Odata EDM: <b>status_desc</b>
     *            </p>
     * @param item_id
     *            Constraints: Not nullable, Maximum length: 64
     *            <p>
     *            Original parameter name from the Odata EDM: <b>item_id</b>
     *            </p>
     * @param qname
     *            Constraints: Not nullable, Maximum length: 64
     *            <p>
     *            Original parameter name from the Odata EDM: <b>qname</b>
     *            </p>
     * @param item_status
     *            Constraints: Not nullable, Maximum length: 10
     *            <p>
     *            Original parameter name from the Odata EDM: <b>item_status</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>Set_QItem_Status</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.Set_QItem_StatusFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    Set_QItem_StatusFluentHelper set_QItem_Status(
        @Nonnull final String qname,
        @Nonnull final String item_id,
        @Nonnull final String item_status,
        @Nonnull final String status_desc );

    /**
     * <p>
     * Creates a fluent helper for the <b>Get_QItem_Document</b> OData function import.
     * </p>
     *
     * @param attachments
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>attachments</b>
     *            </p>
     * @param item_id
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>item_id</b>
     *            </p>
     * @param main_doc
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>main_doc</b>
     *            </p>
     * @param qname
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>qname</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>Get_QItem_Document</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.Get_QItem_DocumentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    Get_QItem_DocumentFluentHelper get_QItem_Document(
        @Nonnull final String item_id,
        @Nonnull final Boolean main_doc,
        @Nonnull final Boolean attachments,
        @Nonnull final String qname );

    /**
     * <p>
     * Creates a fluent helper for the <b>Get_PrintOptions</b> OData function import.
     * </p>
     *
     * @param item_id
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>item_id</b>
     *            </p>
     * @param qname
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>qname</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>Get_PrintOptions</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.Get_PrintOptionsFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    Get_PrintOptionsFluentHelper get_PrintOptions( @Nonnull final String qname, @Nonnull final String item_id );

    /**
     * <p>
     * Creates a fluent helper for the <b>Set_PrintParameter</b> OData function import.
     * </p>
     *
     * @param qname
     *            Constraints: Not nullable, Maximum length: 32
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Qname</b>
     *            </p>
     * @param printParams
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PrintParams</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>Set_PrintParameter</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.Set_PrintParameterFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    Set_PrintParameterFluentHelper set_PrintParameter( @Nonnull final String printParams, @Nonnull final String qname );

}
