/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.CancelProcOrdConfFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.GetConfProposalFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.GetGdsMvtProposalFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2CreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConfMatlDocItm;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConfMatlDocItmByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConfMatlDocItmCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConfMatlDocItmFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrderConfBatchCharcByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrderConfBatchCharcFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.batch.ProcessOrderConfirmationV2ServiceBatch;

/**
 * <p>
 * You can create time ticket and time event confirmations as well as confirmations on order level, read them, and
 * cancel the confirmations on time ticket, time event, or order level. Before creating a confirmation, you can fetch
 * the proposed data for quantities, work activities, dates and times, personnel data, and goods movements depending on
 * the type of confirmation.
 *
 * Note
 *
 * The following operations are available on the API Reference tab but are not supported by this API: - POST
 * /ProcOrdConf2(ConfirmationGroup=&#39;{ConfirmationGroup}&#39;,ConfirmationCount=&#39;{ConfirmationCount}&#39;,/to_ProcOrdConfMatlDocItm
 * - POST
 * /ProcOrdConfMatlDocItm(ConfirmationGroup=&#39;{ConfirmationGroup}&#39;,ConfirmationCount=&#39;{ConfirmationCount}&#39;,MaterialDocument=&#39;{MaterialDocument}&#39;,MaterialDocumentItem=&#39;{MaterialDocumentItem}&#39;,MaterialDocumentYear=&#39;{MaterialDocumentYear}&#39;,/to_ProcOrderConfBatchCharc
 * .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/fc/8dbf5e46004f1c9069b6ac4301c384/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PROC_ORDER_CONFIRMATION_2_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PROC_ORDER_CONFIRMATION_2_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.2.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Production Planning Integration(SAP_COM_0104), Manufacturing Execution - Order and Confirmation
 * Integration(SAP_COM_0522)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BJ5'> Make-to-Stock Production - Discrete Manufacturing(BJ5)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BJ8'>Make-to-Stock - Process Manufacturing Based on Process
 * Order(BJ8)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/J44'>Material Requirements Planning(J44)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O44'>Material Requirements Planning(O44)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3W3'>Third-Party Shop Floor Execution - Process Industry(3W3)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3W4'>Third-Party Shop Floor Execution - Discrete
 * Industry(3W4)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Process Order Confirmation</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface ProcessOrderConfirmationV2Service extends BatchService<ProcessOrderConfirmationV2ServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_PROC_ORDER_CONFIRMATION_2_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    ProcessOrderConfirmationV2Service withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2
     * ProcOrdConf2} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2
     *         ProcOrdConf2} entities. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2FluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProcOrdConf2FluentHelper getAllProcOrdConf2();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2
     * ProcOrdConf2} entity using key fields.
     *
     * @param confirmationCount
     *            Identifier of Single Order Confirmation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param confirmationGroup
     *            Collective ID of Order Confirmations
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2
     *         ProcOrdConf2} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2ByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProcOrdConf2ByKeyFluentHelper
        getProcOrdConf2ByKey( final String confirmationGroup, final String confirmationCount );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2
     * ProcOrdConf2} entity and save it to the S/4HANA system.
     *
     * @param procOrdConf2
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2
     *            ProcOrdConf2} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2
     *         ProcOrdConf2} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2CreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProcOrdConf2CreateFluentHelper createProcOrdConf2( @Nonnull final ProcOrdConf2 procOrdConf2 );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConfMatlDocItm
     * ProcOrdConfMatlDocItm} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConfMatlDocItm
     *         ProcOrdConfMatlDocItm} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConfMatlDocItmFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProcOrdConfMatlDocItmFluentHelper getAllProcOrdConfMatlDocItm();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConfMatlDocItm
     * ProcOrdConfMatlDocItm} entity using key fields.
     *
     * @param materialDocument
     *            Number of Material Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param confirmationCount
     *            Identifier of Single Order Confirmation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param materialDocumentItem
     *            Material Document Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param materialDocumentYear
     *            Material Document Year
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param confirmationGroup
     *            Collective ID of Order Confirmations
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConfMatlDocItm
     *         ProcOrdConfMatlDocItm} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConfMatlDocItmByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProcOrdConfMatlDocItmByKeyFluentHelper getProcOrdConfMatlDocItmByKey(
        final String confirmationGroup,
        final String confirmationCount,
        final String materialDocument,
        final String materialDocumentItem,
        final String materialDocumentYear );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConfMatlDocItm
     * ProcOrdConfMatlDocItm} entity and save it to the S/4HANA system.
     *
     * @param procOrdConfMatlDocItm
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConfMatlDocItm
     *            ProcOrdConfMatlDocItm} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConfMatlDocItm
     *         ProcOrdConfMatlDocItm} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConfMatlDocItmCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProcOrdConfMatlDocItmCreateFluentHelper
        createProcOrdConfMatlDocItm( @Nonnull final ProcOrdConfMatlDocItm procOrdConfMatlDocItm );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrderConfBatchCharc
     * ProcOrderConfBatchCharc} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrderConfBatchCharc
     *         ProcOrderConfBatchCharc} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrderConfBatchCharcFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProcOrderConfBatchCharcFluentHelper getAllProcOrderConfBatchCharc();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrderConfBatchCharc
     * ProcOrderConfBatchCharc} entity using key fields.
     *
     * @param materialDocument
     *            Number of Material Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param confirmationCount
     *            Identifier of Single Order Confirmation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param material
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param charcInternalID
     *            Characteristic Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param materialDocumentItem
     *            Material Document Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param plant
     *            Plant of a Batch
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param materialDocumentYear
     *            Material Document Year
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param batch
     *            Batch Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param confirmationGroup
     *            Collective ID of Order Confirmations
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrderConfBatchCharc
     *         ProcOrderConfBatchCharc} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrderConfBatchCharcByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProcOrderConfBatchCharcByKeyFluentHelper getProcOrderConfBatchCharcByKey(
        final String confirmationGroup,
        final String confirmationCount,
        final String materialDocument,
        final String materialDocumentItem,
        final String materialDocumentYear,
        final String plant,
        final String material,
        final String batch,
        final String charcInternalID );

    /**
     * <p>
     * Creates a fluent helper for the <b>CancelProcOrdConf</b> OData function import.
     * </p>
     *
     * @param externalSystemConfirmation
     *            External Key
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ExternalSystemConfirmation</b>
     *            </p>
     * @param confirmationCount
     *            Order Confirmation
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ConfirmationCount</b>
     *            </p>
     * @param confirmationText
     *            Confirmation Text
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ConfirmationText</b>
     *            </p>
     * @param postingDate
     *            Posting Date
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PostingDate</b>
     *            </p>
     * @param confirmationGroup
     *            Confirmation Group
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ConfirmationGroup</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>CancelProcOrdConf</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.CancelProcOrdConfFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CancelProcOrdConfFluentHelper cancelProcOrdConf(
        @Nonnull final String confirmationGroup,
        @Nonnull final String confirmationCount,
        @Nullable final LocalDateTime postingDate,
        @Nullable final String confirmationText,
        @Nullable final UUID externalSystemConfirmation );

    /**
     * <p>
     * Creates a fluent helper for the <b>GetConfProposal</b> OData function import.
     * </p>
     *
     * @param dateAndTimeIsToBeProposed
     *            Propose Dates
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DateAndTimeIsToBeProposed</b>
     *            </p>
     * @param orderID
     *            Manufacturing Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OrderID</b>
     *            </p>
     * @param confirmationUnitISOCode
     *            ISO Code
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ConfirmationUnitISOCode</b>
     *            </p>
     * @param confirmationGroup
     *            Confirmation Group
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ConfirmationGroup</b>
     *            </p>
     * @param confirmationYieldQuantity
     *            Yield Quantity
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 13, Scale: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ConfirmationYieldQuantity</b>
     *            </p>
     * @param quantityIsToBeProposed
     *            Propose Quantities
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>QuantityIsToBeProposed</b>
     *            </p>
     * @param orderConfirmationRecordType
     *            Record Type
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OrderConfirmationRecordType</b>
     *            </p>
     * @param confirmationUnit
     *            Display Unit/Measure
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ConfirmationUnit</b>
     *            </p>
     * @param orderSuboperation
     *            Suboperation
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OrderSuboperation</b>
     *            </p>
     * @param personnelIsToBeProposed
     *            Propose Personnel
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PersonnelIsToBeProposed</b>
     *            </p>
     * @param activityIsToBeProposed
     *            Propose Activities
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ActivityIsToBeProposed</b>
     *            </p>
     * @param orderOperation
     *            Operation
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OrderOperation</b>
     *            </p>
     * @param confirmationScrapQuantity
     *            Scrap Quantity
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 13, Scale: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ConfirmationScrapQuantity</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>GetConfProposal</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.GetConfProposalFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GetConfProposalFluentHelper getConfProposal(
        @Nullable final String confirmationGroup,
        @Nullable final String orderID,
        @Nullable final String orderOperation,
        @Nullable final String orderSuboperation,
        @Nullable final String orderConfirmationRecordType,
        @Nullable final String confirmationUnit,
        @Nullable final String confirmationUnitISOCode,
        @Nullable final BigDecimal confirmationYieldQuantity,
        @Nullable final BigDecimal confirmationScrapQuantity,
        @Nullable final Boolean quantityIsToBeProposed,
        @Nullable final Boolean activityIsToBeProposed,
        @Nullable final Boolean dateAndTimeIsToBeProposed,
        @Nullable final Boolean personnelIsToBeProposed );

    /**
     * <p>
     * Creates a fluent helper for the <b>GetConfProposal</b> OData function import.
     * </p>
     *
     * @param dateAndTimeIsToBeProposed
     *            Propose Dates
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DateAndTimeIsToBeProposed</b>
     *            </p>
     * @param orderID
     *            Manufacturing Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OrderID</b>
     *            </p>
     * @param confirmationUnitISOCode
     *            ISO Code
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ConfirmationUnitISOCode</b>
     *            </p>
     * @param confirmationGroup
     *            Confirmation Group
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ConfirmationGroup</b>
     *            </p>
     * @param confirmationYieldQuantity
     *            Yield Quantity
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 13, Scale: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ConfirmationYieldQuantity</b>
     *            </p>
     * @param quantityIsToBeProposed
     *            Propose Quantities
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>QuantityIsToBeProposed</b>
     *            </p>
     * @param orderConfirmationRecordType
     *            Record Type
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OrderConfirmationRecordType</b>
     *            </p>
     * @param confirmationUnit
     *            Display Unit/Measure
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ConfirmationUnit</b>
     *            </p>
     * @param orderSuboperation
     *            Suboperation
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OrderSuboperation</b>
     *            </p>
     * @param personnelIsToBeProposed
     *            Propose Personnel
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PersonnelIsToBeProposed</b>
     *            </p>
     * @param activityIsToBeProposed
     *            Propose Activities
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ActivityIsToBeProposed</b>
     *            </p>
     * @param orderOperation
     *            Operation
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OrderOperation</b>
     *            </p>
     * @param confirmationScrapQuantity
     *            Scrap Quantity
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 13, Scale: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ConfirmationScrapQuantity</b>
     *            </p>
     * @param confirmationUnitSAPCode
     *            Internal SAP Code
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ConfirmationUnitSAPCode</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>GetConfProposal</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.GetConfProposalFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GetConfProposalFluentHelper getConfProposal(
        @Nullable final String confirmationGroup,
        @Nullable final String orderID,
        @Nullable final String orderOperation,
        @Nullable final String orderSuboperation,
        @Nullable final String orderConfirmationRecordType,
        @Nullable final String confirmationUnit,
        @Nullable final String confirmationUnitISOCode,
        @Nullable final BigDecimal confirmationYieldQuantity,
        @Nullable final BigDecimal confirmationScrapQuantity,
        @Nullable final Boolean quantityIsToBeProposed,
        @Nullable final Boolean activityIsToBeProposed,
        @Nullable final Boolean dateAndTimeIsToBeProposed,
        @Nullable final Boolean personnelIsToBeProposed,
        @Nullable final String confirmationUnitSAPCode );

    /**
     * <p>
     * Creates a fluent helper for the <b>GetGdsMvtProposal</b> OData function import.
     * </p>
     *
     * @param dateAndTimeIsToBeProposed
     *            Propose Dates
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DateAndTimeIsToBeProposed</b>
     *            </p>
     * @param orderID
     *            Manufacturing Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OrderID</b>
     *            </p>
     * @param confirmationUnitISOCode
     *            ISO Code
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ConfirmationUnitISOCode</b>
     *            </p>
     * @param confirmationGroup
     *            Confirmation Group
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ConfirmationGroup</b>
     *            </p>
     * @param confirmationYieldQuantity
     *            Yield Quantity
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 13, Scale: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ConfirmationYieldQuantity</b>
     *            </p>
     * @param quantityIsToBeProposed
     *            Propose Quantities
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>QuantityIsToBeProposed</b>
     *            </p>
     * @param orderConfirmationRecordType
     *            Record Type
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OrderConfirmationRecordType</b>
     *            </p>
     * @param confirmationUnit
     *            Display Unit/Measure
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ConfirmationUnit</b>
     *            </p>
     * @param orderSuboperation
     *            Suboperation
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OrderSuboperation</b>
     *            </p>
     * @param personnelIsToBeProposed
     *            Propose Personnel
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PersonnelIsToBeProposed</b>
     *            </p>
     * @param activityIsToBeProposed
     *            Propose Activities
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ActivityIsToBeProposed</b>
     *            </p>
     * @param orderOperation
     *            Operation
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OrderOperation</b>
     *            </p>
     * @param confirmationScrapQuantity
     *            Scrap Quantity
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 13, Scale: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ConfirmationScrapQuantity</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>GetGdsMvtProposal</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.GetGdsMvtProposalFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GetGdsMvtProposalFluentHelper getGdsMvtProposal(
        @Nullable final String confirmationGroup,
        @Nullable final String orderID,
        @Nullable final String orderOperation,
        @Nullable final String orderSuboperation,
        @Nullable final String orderConfirmationRecordType,
        @Nullable final String confirmationUnit,
        @Nullable final String confirmationUnitISOCode,
        @Nullable final BigDecimal confirmationYieldQuantity,
        @Nullable final BigDecimal confirmationScrapQuantity,
        @Nullable final Boolean quantityIsToBeProposed,
        @Nullable final Boolean activityIsToBeProposed,
        @Nullable final Boolean dateAndTimeIsToBeProposed,
        @Nullable final Boolean personnelIsToBeProposed );

    /**
     * <p>
     * Creates a fluent helper for the <b>GetGdsMvtProposal</b> OData function import.
     * </p>
     *
     * @param dateAndTimeIsToBeProposed
     *            Propose Dates
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DateAndTimeIsToBeProposed</b>
     *            </p>
     * @param orderID
     *            Manufacturing Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OrderID</b>
     *            </p>
     * @param confirmationUnitISOCode
     *            ISO Code
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ConfirmationUnitISOCode</b>
     *            </p>
     * @param confirmationGroup
     *            Confirmation Group
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ConfirmationGroup</b>
     *            </p>
     * @param confirmationYieldQuantity
     *            Yield Quantity
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 13, Scale: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ConfirmationYieldQuantity</b>
     *            </p>
     * @param quantityIsToBeProposed
     *            Propose Quantities
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>QuantityIsToBeProposed</b>
     *            </p>
     * @param orderConfirmationRecordType
     *            Record Type
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OrderConfirmationRecordType</b>
     *            </p>
     * @param confirmationUnit
     *            Display Unit/Measure
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ConfirmationUnit</b>
     *            </p>
     * @param orderSuboperation
     *            Suboperation
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OrderSuboperation</b>
     *            </p>
     * @param personnelIsToBeProposed
     *            Propose Personnel
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PersonnelIsToBeProposed</b>
     *            </p>
     * @param activityIsToBeProposed
     *            Propose Activities
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ActivityIsToBeProposed</b>
     *            </p>
     * @param orderOperation
     *            Operation
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OrderOperation</b>
     *            </p>
     * @param confirmationScrapQuantity
     *            Scrap Quantity
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 13, Scale: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ConfirmationScrapQuantity</b>
     *            </p>
     * @param confirmationUnitSAPCode
     *            Internal SAP Code
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ConfirmationUnitSAPCode</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>GetGdsMvtProposal</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.GetGdsMvtProposalFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GetGdsMvtProposalFluentHelper getGdsMvtProposal(
        @Nullable final String confirmationGroup,
        @Nullable final String orderID,
        @Nullable final String orderOperation,
        @Nullable final String orderSuboperation,
        @Nullable final String orderConfirmationRecordType,
        @Nullable final String confirmationUnit,
        @Nullable final String confirmationUnitISOCode,
        @Nullable final BigDecimal confirmationYieldQuantity,
        @Nullable final BigDecimal confirmationScrapQuantity,
        @Nullable final Boolean quantityIsToBeProposed,
        @Nullable final Boolean activityIsToBeProposed,
        @Nullable final Boolean dateAndTimeIsToBeProposed,
        @Nullable final Boolean personnelIsToBeProposed,
        @Nullable final String confirmationUnitSAPCode );

}
