/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;
import java.time.LocalTime;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.CloseOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ConvertPlndOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.DeletionFlagOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.DeletionIndOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.DiscardOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.FunctionMessage;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.FunctionMessageByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.FunctionMessageCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.FunctionMessageDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.FunctionMessageFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.FunctionMessageUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrder;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderOperationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderOperationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderStatusByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderStatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ReleaseOperationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ReleaseOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ScheduleProcessOrderOperationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.TechlyCmpltOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.batch.ProcessOrderServiceBatch;

/**
 * <p>
 * In addition to create, read, and update, you can also release process orders and operations. This service also
 * enables you to schedule process order operations, technically complete and close process orders as well as set the
 * deletion flag and deletion indicator.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2208.latest/EN/10/e72f5883fa9244e10000000a4450e5/frameset.htm?profile=20020833'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PROCESS_ORDERS?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PROCESS_ORDERS</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2208</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Production Planning Integration(SAP_COM_0104), Manufacturing Execution - Order and Confirmation
 * Integration(SAP_COM_0522)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BJ5'> Make-to-Stock Production - Discrete Manufacturing(BJ5)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BJ8'>Make-to-Stock - Process Manufacturing Based on Process
 * Order(BJ8)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/J44'>Material Requirements Planning(J44)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O44'>Material Requirements Planning(O44)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3W3'>Third-Party Shop Floor Execution - Process Industry(3W3)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3W4'>Third-Party Shop Floor Execution - Discrete
 * Industry(3W4)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Process Order</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated as of release 2008 (Aug 2020). Please use the
 *             odata generator to generate the VDM.
 */
@Deprecated
public interface ProcessOrderService extends BatchService<ProcessOrderServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_PROCESS_ORDERS";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    ProcessOrderService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.FunctionMessage
     * FunctionMessage} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.FunctionMessage FunctionMessage}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.FunctionMessageFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FunctionMessageFluentHelper getAllFunctionMessage();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.FunctionMessage
     * FunctionMessage} entity using key fields.
     *
     * @param message
     *            Message text
     *            <p>
     *            Constraints: Not nullable, Maximum length: 220
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.FunctionMessage FunctionMessage}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.FunctionMessageByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FunctionMessageByKeyFluentHelper getFunctionMessageByKey( final String message );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.FunctionMessage
     * FunctionMessage} entity and save it to the S/4HANA system.
     *
     * @param functionMessage
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.FunctionMessage
     *            FunctionMessage} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.FunctionMessage FunctionMessage}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.FunctionMessageCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FunctionMessageCreateFluentHelper createFunctionMessage( @Nonnull final FunctionMessage functionMessage );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.FunctionMessage
     * FunctionMessage} entity and save it to the S/4HANA system.
     *
     * @param functionMessage
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.FunctionMessage
     *            FunctionMessage} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.FunctionMessage FunctionMessage}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.FunctionMessageUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FunctionMessageUpdateFluentHelper updateFunctionMessage( @Nonnull final FunctionMessage functionMessage );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.FunctionMessage
     * FunctionMessage} entity in the S/4HANA system.
     *
     * @param functionMessage
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.FunctionMessage
     *            FunctionMessage} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.FunctionMessage FunctionMessage}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.FunctionMessageDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FunctionMessageDeleteFluentHelper deleteFunctionMessage( @Nonnull final FunctionMessage functionMessage );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrder ProcessOrder}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrder ProcessOrder}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProcessOrderFluentHelper getAllProcessOrder();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrder ProcessOrder}
     * entity using key fields.
     *
     * @param processOrder
     *            Manufacturing Order ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrder ProcessOrder} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProcessOrderByKeyFluentHelper getProcessOrderByKey( final String processOrder );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrder ProcessOrder}
     * entity and save it to the S/4HANA system.
     *
     * @param processOrder
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrder ProcessOrder}
     *            entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrder ProcessOrder}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProcessOrderCreateFluentHelper createProcessOrder( @Nonnull final ProcessOrder processOrder );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrder
     * ProcessOrder} entity and save it to the S/4HANA system.
     *
     * @param processOrder
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrder ProcessOrder}
     *            entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrder ProcessOrder}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProcessOrderUpdateFluentHelper updateProcessOrder( @Nonnull final ProcessOrder processOrder );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent
     * ProcessOrderComponent} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent
     *         ProcessOrderComponent} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProcessOrderComponentFluentHelper getAllProcessOrderComponent();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent
     * ProcessOrderComponent} entity using key fields.
     *
     * @param reservationItem
     *            Reservation Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param reservation
     *            Number of reservation/dependent requirements
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent
     *         ProcessOrderComponent} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponentByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProcessOrderComponentByKeyFluentHelper
        getProcessOrderComponentByKey( final String reservation, final String reservationItem );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderItem
     * ProcessOrderItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderItem
     *         ProcessOrderItem} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProcessOrderItemFluentHelper getAllProcessOrderItem();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderItem
     * ProcessOrderItem} entity using key fields.
     *
     * @param manufacturingOrderItem
     *            Manufacturing Order Item ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param manufacturingOrder
     *            Manufacturing Order ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderItem
     *         ProcessOrderItem} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProcessOrderItemByKeyFluentHelper
        getProcessOrderItemByKey( final String manufacturingOrder, final String manufacturingOrderItem );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderOperation
     * ProcessOrderOperation} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderOperation
     *         ProcessOrderOperation} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderOperationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProcessOrderOperationFluentHelper getAllProcessOrderOperation();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderOperation
     * ProcessOrderOperation} entity using key fields.
     *
     * @param orderIntBillOfOperationsItem
     *            Internal Identifier of an Operation or Activity
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param orderInternalBillOfOperations
     *            Order Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderOperation
     *         ProcessOrderOperation} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderOperationByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProcessOrderOperationByKeyFluentHelper getProcessOrderOperationByKey(
        final String orderInternalBillOfOperations,
        final String orderIntBillOfOperationsItem );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderStatus
     * ProcessOrderStatus} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderStatus
     *         ProcessOrderStatus} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderStatusFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProcessOrderStatusFluentHelper getAllProcessOrderStatus();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderStatus
     * ProcessOrderStatus} entity using key fields.
     *
     * @param manufacturingOrder
     *            Order Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param statusCode
     *            Object status
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderStatus
     *         ProcessOrderStatus} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderStatusByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProcessOrderStatusByKeyFluentHelper
        getProcessOrderStatusByKey( final String manufacturingOrder, final String statusCode );

    /**
     * <p>
     * Creates a fluent helper for the <b>ReleaseOrder</b> OData function import.
     * </p>
     *
     * @param manufacturingOrder
     *            Constraints: Not nullable, Maximum length: 12
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ManufacturingOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ReleaseOrder</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ReleaseOrderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ReleaseOrderFluentHelper releaseOrder( @Nonnull final String manufacturingOrder );

    /**
     * <p>
     * Creates a fluent helper for the <b>ReleaseOperation</b> OData function import.
     * </p>
     *
     * @param manufacturingOrderOperation
     *            Constraints: Not nullable, Maximum length: 4
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ManufacturingOrderOperation</b>
     *            </p>
     * @param manufacturingOrder
     *            Constraints: Not nullable, Maximum length: 12
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ManufacturingOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ReleaseOperation</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ReleaseOperationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ReleaseOperationFluentHelper
        releaseOperation( @Nonnull final String manufacturingOrder, @Nonnull final String manufacturingOrderOperation );

    /**
     * <p>
     * Creates a fluent helper for the <b>TechlyCmpltOrder</b> OData function import.
     * </p>
     *
     * @param manufacturingOrder
     *            Constraints: Not nullable, Maximum length: 12
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ManufacturingOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>TechlyCmpltOrder</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.TechlyCmpltOrderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    TechlyCmpltOrderFluentHelper techlyCmpltOrder( @Nonnull final String manufacturingOrder );

    /**
     * <p>
     * Creates a fluent helper for the <b>CloseOrder</b> OData function import.
     * </p>
     *
     * @param manufacturingOrder
     *            Constraints: Not nullable, Maximum length: 12
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ManufacturingOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>CloseOrder</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.CloseOrderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CloseOrderFluentHelper closeOrder( @Nonnull final String manufacturingOrder );

    /**
     * <p>
     * Creates a fluent helper for the <b>DeletionFlagOrder</b> OData function import.
     * </p>
     *
     * @param manufacturingOrder
     *            Constraints: Not nullable, Maximum length: 12
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ManufacturingOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>DeletionFlagOrder</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.DeletionFlagOrderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DeletionFlagOrderFluentHelper deletionFlagOrder( @Nonnull final String manufacturingOrder );

    /**
     * <p>
     * Creates a fluent helper for the <b>DeletionIndOrder</b> OData function import.
     * </p>
     *
     * @param manufacturingOrder
     *            Constraints: Not nullable, Maximum length: 12
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ManufacturingOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>DeletionIndOrder</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.DeletionIndOrderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DeletionIndOrderFluentHelper deletionIndOrder( @Nonnull final String manufacturingOrder );

    /**
     * <p>
     * Creates a fluent helper for the <b>DiscardOrder</b> OData function import.
     * </p>
     *
     * @param manufacturingOrder
     *            Constraints: Not nullable, Maximum length: 12
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ManufacturingOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>DiscardOrder</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.DiscardOrderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DiscardOrderFluentHelper discardOrder( @Nonnull final String manufacturingOrder );

    /**
     * <p>
     * Creates a fluent helper for the <b>ConvertPlndOrder</b> OData function import.
     * </p>
     *
     * @param plannedOrder
     *            Constraints: Not nullable, Maximum length: 10
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PlannedOrder</b>
     *            </p>
     * @param manufacturingOrderType
     *            Constraints: Nullable, Maximum length: 4
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ManufacturingOrderType</b>
     *            </p>
     * @param manufacturingOrder
     *            Constraints: Nullable, Maximum length: 12
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ManufacturingOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ConvertPlndOrder</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ConvertPlndOrderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ConvertPlndOrderFluentHelper convertPlndOrder(
        @Nonnull final String plannedOrder,
        @Nullable final String manufacturingOrderType,
        @Nullable final String manufacturingOrder );

    /**
     * <p>
     * Creates a fluent helper for the <b>ScheduleProcessOrderOperation</b> OData function import.
     * </p>
     *
     * @param orderIntBillOfOperationsItem
     *            Operation Internal ID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OrderIntBillOfOperationsItem</b>
     *            </p>
     * @param opSchedldStartDate
     *            Execution Start Date
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OpSchedldStartDate</b>
     *            </p>
     * @param opSchedulingStrategy
     *            Component of the Version Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OpSchedulingStrategy</b>
     *            </p>
     * @param orderInternalBillOfOperations
     *            Order Internal ID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OrderInternalBillOfOperations</b>
     *            </p>
     * @param opSchedulingStatus
     *            Status
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OpSchedulingStatus</b>
     *            </p>
     * @param opSchedulingMode
     *            Scheduling type
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OpSchedulingMode</b>
     *            </p>
     * @param manufacturingOrder
     *            Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ManufacturingOrder</b>
     *            </p>
     * @param opSchedldStartTime
     *            Execution Start Time
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OpSchedldStartTime</b>
     *            </p>
     * @param opSchedldEndDate
     *            Execution End Date
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OpSchedldEndDate</b>
     *            </p>
     * @param opSchedldEndTime
     *            Execution End Time
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OpSchedldEndTime</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ScheduleProcessOrderOperation</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ScheduleProcessOrderOperationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ScheduleProcessOrderOperationFluentHelper scheduleProcessOrderOperation(
        @Nonnull final String manufacturingOrder,
        @Nonnull final String orderInternalBillOfOperations,
        @Nonnull final String orderIntBillOfOperationsItem,
        @Nullable final LocalDateTime opSchedldStartDate,
        @Nullable final LocalTime opSchedldStartTime,
        @Nullable final LocalDateTime opSchedldEndDate,
        @Nullable final LocalTime opSchedldEndTime,
        @Nonnull final String opSchedulingMode,
        @Nullable final String opSchedulingStatus,
        @Nonnull final String opSchedulingStrategy );

}
