/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.DeleteActiveTimeSeriesFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.DeleteActvCharcValCombinationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcMetaDataByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcMetaDataFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombnByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombnCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombnFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombnUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocObjTimeSeries;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocObjTimeSeriesByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocObjTimeSeriesFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocObjTimeSeriesUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObjectCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObjectTByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObjectTFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.SetLifecycleStatusToActiveFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.SetLifecycleStatusToInactiveFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.batch.ProductAllocationObjectServiceBatch;

/**
 * <p>
 * You can use this service to read the data from product allocation objects as well as read, edit and delete
 * characteristic value combinations and their corresponding time series (planned allocation quantities per period).
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/ac/8316e52e5347b0b5259757b7faf2e4/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PRODUCT_ALLOCATION_OBJECT_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PRODUCT_ALLOCATION_OBJECT_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.1.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Product Allocation Object Integration(SAP_COM_0152)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1JW'>Advanced Available-to-Promise Processing(1JW)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Product Allocation Object</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface ProductAllocationObjectService extends BatchService<ProductAllocationObjectServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_PRODUCT_ALLOCATION_OBJECT_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    ProductAllocationObjectService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObject
     * ProdAllocationObject} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObject
     *         ProdAllocationObject} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObjectFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProdAllocationObjectFluentHelper getAllProdAllocationObject();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObject
     * ProdAllocationObject} entity using key fields.
     *
     * @param productAllocationObjectUUID
     *            Product Allocation Object UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObject
     *         ProdAllocationObject} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObjectByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProdAllocationObjectByKeyFluentHelper getProdAllocationObjectByKey( final UUID productAllocationObjectUUID );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObject
     * ProdAllocationObject} entity and save it to the S/4HANA system.
     *
     * @param prodAllocationObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObject
     *            ProdAllocationObject} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObject
     *         ProdAllocationObject} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObjectCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProdAllocationObjectCreateFluentHelper
        createProdAllocationObject( @Nonnull final ProdAllocationObject prodAllocationObject );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObjectT
     * ProdAllocationObjectT} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObjectT
     *         ProdAllocationObjectT} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObjectTFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProdAllocationObjectTFluentHelper getAllProdAllocationObjectT();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObjectT
     * ProdAllocationObjectT} entity using key fields.
     *
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param productAllocationObjectUUID
     *            Product Allocation Object UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObjectT
     *         ProdAllocationObjectT} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObjectTByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProdAllocationObjectTByKeyFluentHelper
        getProdAllocationObjectTByKey( final UUID productAllocationObjectUUID, final String language );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcMetaData
     * ProdAllocCharcMetaData} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcMetaData
     *         ProdAllocCharcMetaData} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcMetaDataFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProdAllocCharcMetaDataFluentHelper getAllProdAllocCharcMetaData();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcMetaData
     * ProdAllocCharcMetaData} entity using key fields.
     *
     * @param characteristicsMetaDataUUID
     *            Characteristic Meta Data UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcMetaData
     *         ProdAllocCharcMetaData} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcMetaDataByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProdAllocCharcMetaDataByKeyFluentHelper getProdAllocCharcMetaDataByKey( final UUID characteristicsMetaDataUUID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn
     * ProdAllocCharcValCombn} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn
     *         ProdAllocCharcValCombn} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombnFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProdAllocCharcValCombnFluentHelper getAllProdAllocCharcValCombn();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn
     * ProdAllocCharcValCombn} entity using key fields.
     *
     * @param charcValueCombinationUUID
     *            Characteristic Value Combination UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn
     *         ProdAllocCharcValCombn} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombnByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProdAllocCharcValCombnByKeyFluentHelper getProdAllocCharcValCombnByKey( final UUID charcValueCombinationUUID );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn
     * ProdAllocCharcValCombn} entity and save it to the S/4HANA system.
     *
     * @param prodAllocCharcValCombn
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn
     *            ProdAllocCharcValCombn} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn
     *         ProdAllocCharcValCombn} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombnCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProdAllocCharcValCombnCreateFluentHelper
        createProdAllocCharcValCombn( @Nonnull final ProdAllocCharcValCombn prodAllocCharcValCombn );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn
     * ProdAllocCharcValCombn} entity and save it to the S/4HANA system.
     *
     * @param prodAllocCharcValCombn
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn
     *            ProdAllocCharcValCombn} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn
     *         ProdAllocCharcValCombn} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombnUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProdAllocCharcValCombnUpdateFluentHelper
        updateProdAllocCharcValCombn( @Nonnull final ProdAllocCharcValCombn prodAllocCharcValCombn );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocObjTimeSeries
     * ProdAllocObjTimeSeries} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocObjTimeSeries
     *         ProdAllocObjTimeSeries} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocObjTimeSeriesFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProdAllocObjTimeSeriesFluentHelper getAllProdAllocObjTimeSeries();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocObjTimeSeries
     * ProdAllocObjTimeSeries} entity using key fields.
     *
     * @param prodAllocationTimeSeriesUUID
     *            Product Allocation Time SeriesUUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocObjTimeSeries
     *         ProdAllocObjTimeSeries} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocObjTimeSeriesByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProdAllocObjTimeSeriesByKeyFluentHelper getProdAllocObjTimeSeriesByKey( final UUID prodAllocationTimeSeriesUUID );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocObjTimeSeries
     * ProdAllocObjTimeSeries} entity and save it to the S/4HANA system.
     *
     * @param prodAllocObjTimeSeries
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocObjTimeSeries
     *            ProdAllocObjTimeSeries} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocObjTimeSeries
     *         ProdAllocObjTimeSeries} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocObjTimeSeriesUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProdAllocObjTimeSeriesUpdateFluentHelper
        updateProdAllocObjTimeSeries( @Nonnull final ProdAllocObjTimeSeries prodAllocObjTimeSeries );

    /**
     * <p>
     * Creates a fluent helper for the <b>DeleteActvCharcValCombination</b> OData function import.
     * </p>
     *
     * @param isdeleteqa
     *            TRUE
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Isdeleteqa</b>
     *            </p>
     * @param charcValueCombinationUUID
     *            Characteristic Value Combination UUID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CharcValueCombinationUUID</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>DeleteActvCharcValCombination</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.DeleteActvCharcValCombinationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DeleteActvCharcValCombinationFluentHelper deleteActvCharcValCombination(
        @Nonnull final UUID charcValueCombinationUUID,
        @Nonnull final Boolean isdeleteqa );

    /**
     * <p>
     * Creates a fluent helper for the <b>SetLifecycleStatusToActive</b> OData function import.
     * </p>
     *
     * @param charcValueCombinationUUID
     *            Characteristic Value Combination UUID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CharcValueCombinationUUID</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>SetLifecycleStatusToActive</b> OData function import with
     *         the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.SetLifecycleStatusToActiveFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SetLifecycleStatusToActiveFluentHelper setLifecycleStatusToActive( @Nonnull final UUID charcValueCombinationUUID );

    /**
     * <p>
     * Creates a fluent helper for the <b>SetLifecycleStatusToInactive</b> OData function import.
     * </p>
     *
     * @param charcValueCombinationUUID
     *            Characteristic Value Combination UUID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CharcValueCombinationUUID</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>SetLifecycleStatusToInactive</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.SetLifecycleStatusToInactiveFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SetLifecycleStatusToInactiveFluentHelper
        setLifecycleStatusToInactive( @Nonnull final UUID charcValueCombinationUUID );

    /**
     * <p>
     * Creates a fluent helper for the <b>DeleteActiveTimeSeries</b> OData function import.
     * </p>
     *
     * @param prodAllocationTimeSeriesUUID
     *            Product Allocation Time SeriesUUID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ProdAllocationTimeSeriesUUID</b>
     *            </p>
     * @param isdeleteqa
     *            TRUE
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Isdeleteqa</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>DeleteActiveTimeSeries</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.DeleteActiveTimeSeriesFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DeleteActiveTimeSeriesFluentHelper
        deleteActiveTimeSeries( @Nonnull final UUID prodAllocationTimeSeriesUUID, @Nonnull final Boolean isdeleteqa );

}
