/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnClassForKeyDateByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnClassForKeyDateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProductByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProductFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductCharcByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductCharcFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductCharcValueByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductCharcValueFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductClassByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductClassCharcByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductClassCharcFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductClassFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductDescriptionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductDescriptionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlantByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlantFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlantProcurementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlantProcurementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSalesDeliveryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSalesDeliveryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSalesTaxByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSalesTaxFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductStorageLocationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductStorageLocationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSupplyPlanningByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSupplyPlanningFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductWorkSchedulingByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductWorkSchedulingFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.batch.ProductMasterDataIncludingClassificationServiceBatch;

/**
 * <p>
 * Product master is a reusable set of data describing a product or service. Using the API you can read product master
 * data, class assignment and characteristic valuation.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/34/f342df989544e3913eda5bf42c4bc3/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_CLFN_PRODUCT_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_CLFN_PRODUCT_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Product Classification Integration(SAP_COM_0309)</td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Product</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface ProductMasterDataIncludingClassificationService
    extends
    BatchService<ProductMasterDataIncludingClassificationServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_CLFN_PRODUCT_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    ProductMasterDataIncludingClassificationService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlantProcurement
     * ProductPlantProcurement} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlantProcurement
     *         ProductPlantProcurement} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlantProcurementFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantProcurementFluentHelper getAllProductPlantProcurement();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlantProcurement
     * ProductPlantProcurement} entity using key fields.
     *
     * @param product
     *            Product Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlantProcurement
     *         ProductPlantProcurement} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlantProcurementByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantProcurementByKeyFluentHelper
        getProductPlantProcurementByKey( final String product, final String plant );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductStorageLocation
     * ProductStorageLocation} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductStorageLocation
     *         ProductStorageLocation} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductStorageLocationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductStorageLocationFluentHelper getAllProductStorageLocation();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductStorageLocation
     * ProductStorageLocation} entity using key fields.
     *
     * @param product
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param storageLocation
     *            Storage Location
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductStorageLocation
     *         ProductStorageLocation} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductStorageLocationByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductStorageLocationByKeyFluentHelper
        getProductStorageLocationByKey( final String product, final String plant, final String storageLocation );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSupplyPlanning
     * ProductSupplyPlanning} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSupplyPlanning
     *         ProductSupplyPlanning} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSupplyPlanningFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductSupplyPlanningFluentHelper getAllProductSupplyPlanning();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSupplyPlanning
     * ProductSupplyPlanning} entity using key fields.
     *
     * @param product
     *            Product Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSupplyPlanning
     *         ProductSupplyPlanning} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSupplyPlanningByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductSupplyPlanningByKeyFluentHelper getProductSupplyPlanningByKey( final String product, final String plant );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct
     * ClfnProduct} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct
     *         ClfnProduct} entities. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProductFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnProductFluentHelper getAllClfnProduct();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct
     * ClfnProduct} entity using key fields.
     *
     * @param product
     *            Product Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct
     *         ClfnProduct} entity using key fields. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProductByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnProductByKeyFluentHelper getClfnProductByKey( final String product );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnClassForKeyDate
     * ClfnClassForKeyDate} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnClassForKeyDate
     *         ClfnClassForKeyDate} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnClassForKeyDateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnClassForKeyDateFluentHelper getAllClfnClassForKeyDate();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnClassForKeyDate
     * ClfnClassForKeyDate} entity using key fields.
     *
     * @param classInternalID
     *            Internal Class Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnClassForKeyDate
     *         ClfnClassForKeyDate} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnClassForKeyDateByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnClassForKeyDateByKeyFluentHelper getClfnClassForKeyDateByKey( final String classInternalID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductDescription
     * ProductDescription} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductDescription
     *         ProductDescription} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductDescriptionFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductDescriptionFluentHelper getAllProductDescription();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductDescription
     * ProductDescription} entity using key fields.
     *
     * @param product
     *            Product Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductDescription
     *         ProductDescription} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductDescriptionByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductDescriptionByKeyFluentHelper getProductDescriptionByKey( final String product, final String language );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant
     * ProductPlant} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant
     *         ProductPlant} entities. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlantFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantFluentHelper getAllProductPlant();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant
     * ProductPlant} entity using key fields.
     *
     * @param product
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant
     *         ProductPlant} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlantByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantByKeyFluentHelper getProductPlantByKey( final String product, final String plant );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSalesDelivery
     * ProductSalesDelivery} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSalesDelivery
     *         ProductSalesDelivery} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSalesDeliveryFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductSalesDeliveryFluentHelper getAllProductSalesDelivery();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSalesDelivery
     * ProductSalesDelivery} entity using key fields.
     *
     * @param product
     *            Product Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param productDistributionChnl
     *            Distribution Channel
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param productSalesOrg
     *            Sales Organization
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSalesDelivery
     *         ProductSalesDelivery} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSalesDeliveryByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductSalesDeliveryByKeyFluentHelper getProductSalesDeliveryByKey(
        final String product,
        final String productSalesOrg,
        final String productDistributionChnl );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSalesTax
     * ProductSalesTax} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSalesTax
     *         ProductSalesTax} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSalesTaxFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductSalesTaxFluentHelper getAllProductSalesTax();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSalesTax
     * ProductSalesTax} entity using key fields.
     *
     * @param country
     *            Departure Country/Region (from which the goods are sent)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param product
     *            Product Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param taxClassification
     *
     * @param taxCategory
     *            Tax Condition Type (Sales Tax, Value-Added Tax,...)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSalesTax
     *         ProductSalesTax} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSalesTaxByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductSalesTaxByKeyFluentHelper getProductSalesTaxByKey(
        final String product,
        final String country,
        final String taxCategory,
        final String taxClassification );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductWorkScheduling
     * ProductWorkScheduling} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductWorkScheduling
     *         ProductWorkScheduling} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductWorkSchedulingFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductWorkSchedulingFluentHelper getAllProductWorkScheduling();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductWorkScheduling
     * ProductWorkScheduling} entity using key fields.
     *
     * @param product
     *            Product Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductWorkScheduling
     *         ProductWorkScheduling} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductWorkSchedulingByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductWorkSchedulingByKeyFluentHelper getProductWorkSchedulingByKey( final String product, final String plant );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductCharc
     * ProductCharc} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductCharc
     *         ProductCharc} entities. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductCharcFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductCharcFluentHelper getAllProductCharc();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductCharc
     * ProductCharc} entity using key fields.
     *
     * @param product
     *            Key of Object to be Classified
     *            <p>
     *            Constraints: Not nullable, Maximum length: 90
     *            </p>
     * @param charcInternalID
     *            Characteristic Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param classType
     *            Class Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductCharc
     *         ProductCharc} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductCharcByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductCharcByKeyFluentHelper
        getProductCharcByKey( final String product, final String charcInternalID, final String classType );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductCharcValue
     * ProductCharcValue} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductCharcValue
     *         ProductCharcValue} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductCharcValueFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductCharcValueFluentHelper getAllProductCharcValue();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductCharcValue
     * ProductCharcValue} entity using key fields.
     *
     * @param charcValuePositionNumber
     *            Characteristic value counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param product
     *            Key of Object to be Classified
     *            <p>
     *            Constraints: Not nullable, Maximum length: 90
     *            </p>
     * @param charcInternalID
     *            Characteristic Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param classType
     *            Class Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductCharcValue
     *         ProductCharcValue} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductCharcValueByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductCharcValueByKeyFluentHelper getProductCharcValueByKey(
        final String product,
        final String classType,
        final String charcInternalID,
        final String charcValuePositionNumber );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductClass
     * ProductClass} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductClass
     *         ProductClass} entities. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductClassFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductClassFluentHelper getAllProductClass();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductClass
     * ProductClass} entity using key fields.
     *
     * @param product
     *            Key of Object to be Classified
     *            <p>
     *            Constraints: Not nullable, Maximum length: 90
     *            </p>
     * @param classInternalID
     *            Internal Class Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductClass
     *         ProductClass} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductClassByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductClassByKeyFluentHelper getProductClassByKey( final String product, final String classInternalID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductClassCharc
     * ProductClassCharc} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductClassCharc
     *         ProductClassCharc} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductClassCharcFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductClassCharcFluentHelper getAllProductClassCharc();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductClassCharc
     * ProductClassCharc} entity using key fields.
     *
     * @param product
     *            Key of Object to be Classified
     *            <p>
     *            Constraints: Not nullable, Maximum length: 90
     *            </p>
     * @param charcInternalID
     *            Characteristic Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param classInternalID
     *            Internal Class Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductClassCharc
     *         ProductClassCharc} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductClassCharcByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductClassCharcByKeyFluentHelper
        getProductClassCharcByKey( final String product, final String classInternalID, final String charcInternalID );

}
